/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.hc.core.impl.monitor;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;
import org.apache.felix.hc.api.HealthCheck;
import org.apache.felix.hc.api.execution.HealthCheckExecutionResult;
import org.apache.felix.hc.api.execution.HealthCheckSelector;
import org.apache.felix.hc.core.impl.executor.CombinedExecutionResult;
import org.apache.felix.hc.core.impl.executor.ExtendedHealthCheckExecutor;
import org.apache.felix.hc.core.impl.executor.HealthCheckExecutorThreadPool;
import org.apache.felix.hc.core.impl.monitor.HealthState;
import org.apache.felix.hc.core.impl.scheduling.AsyncIntervalJob;
import org.apache.felix.hc.core.impl.scheduling.AsyncJob;
import org.apache.felix.hc.core.impl.scheduling.CronJobFactory;
import org.apache.felix.hc.core.impl.servlet.ResultTxtVerboseSerializer;
import org.apache.felix.hc.core.impl.util.HealthCheckFilter;
import org.apache.felix.hc.core.impl.util.lang.StringUtils;
import org.osgi.framework.BundleContext;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.framework.ServiceEvent;
import org.osgi.framework.ServiceListener;
import org.osgi.framework.ServiceReference;
import org.osgi.service.component.ComponentContext;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.ConfigurationPolicy;
import org.osgi.service.component.annotations.Deactivate;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.event.EventAdmin;
import org.osgi.service.metatype.annotations.AttributeDefinition;
import org.osgi.service.metatype.annotations.Designate;
import org.osgi.service.metatype.annotations.ObjectClassDefinition;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(immediate=true, configurationPolicy=ConfigurationPolicy.REQUIRE)
@Designate(ocd=Config.class, factory=true)
public class HealthCheckMonitor
implements Runnable {
    private static final Logger LOG = LoggerFactory.getLogger(HealthCheckMonitor.class);
    @Reference
    ExtendedHealthCheckExecutor executor;
    @Reference
    HealthCheckExecutorThreadPool healthCheckExecutorThreadPool;
    @Reference
    ResultTxtVerboseSerializer resultTxtVerboseSerializer;
    @Reference
    CronJobFactory cronJobFactory;
    @Reference
    private EventAdmin eventAdmin;
    AsyncJob monitorJob = null;
    List<String> tags;
    List<String> names;
    Map<Object, HealthState> healthStates = new ConcurrentHashMap<Object, HealthState>();
    private long intervalInSec;
    private String cronExpression;
    private boolean registerHealthyMarkerService;
    private boolean registerUnhealthyMarkerService;
    private boolean treatWarnAsHealthy;
    private ChangeType sendEvents;
    private ChangeType logResults;
    private boolean logAllResultsAsInfo;
    private BundleContext bundleContext;
    private String monitorId;
    private boolean isDynamic;
    private ServiceListener healthCheckServiceListener;

    @Activate
    protected final void activate(BundleContext bundleContext, Config config, ComponentContext componentContext) throws InvalidSyntaxException {
        this.bundleContext = bundleContext;
        this.tags = Arrays.stream(config.tags()).filter(StringUtils::isNotBlank).collect(Collectors.toList());
        this.names = Arrays.stream(config.names()).filter(StringUtils::isNotBlank).collect(Collectors.toList());
        this.isDynamic = config.isDynamic();
        this.initHealthStates();
        this.registerHealthyMarkerService = config.registerHealthyMarkerService();
        this.registerUnhealthyMarkerService = config.registerUnhealthyMarkerService();
        this.treatWarnAsHealthy = config.treatWarnAsHealthy();
        this.sendEvents = config.sendEvents();
        this.logResults = config.logResults();
        this.logAllResultsAsInfo = config.logAllResultsAsInfo();
        this.intervalInSec = config.intervalInSec();
        this.cronExpression = config.cronExpression();
        this.monitorId = this.getMonitorId(componentContext.getProperties().get("component.id"));
        if (StringUtils.isNotBlank(this.cronExpression)) {
            this.monitorJob = this.cronJobFactory.createAsyncCronJob(this, this.monitorId, "healthcheck-monitor", this.cronExpression);
        } else if (this.intervalInSec > 0L) {
            this.monitorJob = new AsyncIntervalJob(this, this.healthCheckExecutorThreadPool, this.intervalInSec);
        } else {
            throw new IllegalArgumentException("Either cronExpression or intervalInSec needs to be set");
        }
        this.monitorJob.schedule();
        LOG.info("Monitor active for tags {} and names {} (isDynamic={})", new Object[]{this.tags, this.names, this.isDynamic});
    }

    private void initHealthStates() throws InvalidSyntaxException {
        if (!this.isDynamic) {
            this.tags.stream().filter(StringUtils::isNotBlank).forEach(tag -> {
                if (tag.contains("*") || tag.startsWith("-")) {
                    throw new IllegalArgumentException("Health check monitor is configured to isDyamic=false but tags contain query items like '*' or '-': " + String.join((CharSequence)",", this.tags));
                }
                this.healthStates.put(tag, new HealthState(this, (String)tag, true));
            });
            this.names.stream().filter(StringUtils::isNotBlank).forEach(name -> this.healthStates.put(name, new HealthState(this, (String)name, false)));
        } else {
            this.updateHealthStatesMap();
            this.healthCheckServiceListener = new HealthCheckServiceListener();
            this.bundleContext.addServiceListener(this.healthCheckServiceListener, HealthCheckFilter.HC_FILTER_OBJECT_CLASS);
        }
    }

    private String getMonitorId(Object compId) {
        return "hc-monitor-" + compId + "-" + String.join((CharSequence)",", this.tags) + (String)(!this.names.isEmpty() ? "-" + this.names.size() + "_names" : "");
    }

    public String toString() {
        return "[HealthCheckMonitor tags=" + this.tags + "/names=" + this.names + ", intervalInSec=" + this.intervalInSec + "/cron=" + this.cronExpression + "]";
    }

    @Deactivate
    protected final void deactivate() {
        if (this.healthCheckServiceListener != null) {
            this.bundleContext.removeServiceListener(this.healthCheckServiceListener);
        }
        this.healthStates.values().stream().forEach(HealthState::cleanUp);
        this.healthStates.clear();
        this.monitorJob.unschedule();
        LOG.info("Monitor deactivated for tags {} and names {}", this.tags, this.names);
    }

    public void updateHealthStatesMap() {
        HealthCheckFilter filter = new HealthCheckFilter(this.bundleContext);
        HealthCheckSelector selector = HealthCheckSelector.tags((String[])this.tags.toArray(new String[this.tags.size()])).withNames(this.names.toArray(new String[this.names.size()]));
        ServiceReference<HealthCheck>[] refs = filter.getHealthCheckServiceReferences(selector, true);
        LOG.debug("Found {} health check service refs", (Object)refs.length);
        ArrayList<Object> oldServiceIds = new ArrayList<Object>(this.healthStates.keySet());
        for (ServiceReference<HealthCheck> ref : refs) {
            Long serviceId = (Long)ref.getProperty("service.id");
            if (this.healthStates.containsKey(serviceId)) {
                oldServiceIds.remove(serviceId);
                continue;
            }
            HealthState healthState = new HealthState(this, ref);
            LOG.debug("Monitoring health state: {}", (Object)healthState);
            this.healthStates.put(serviceId, healthState);
        }
        for (Object e : oldServiceIds) {
            HealthState removed = this.healthStates.remove(e);
            removed.cleanUp();
            LOG.debug("Removed monitoring for health state: {}", (Object)removed);
        }
    }

    @Override
    public void run() {
        this.runWithThreadNameContext(() -> {
            try {
                this.healthStates.values().parallelStream().forEach(healthState -> this.runWithThreadNameContext(healthState::update));
                if (this.logResults != ChangeType.NONE) {
                    this.logResults();
                }
                LOG.debug("Updated {} health states for tags {} and names {}", new Object[]{this.healthStates.size(), this.tags, this.names});
            }
            catch (Exception e) {
                LOG.error("Exception during execution of checks in HealthCheckMonitor: " + e, (Throwable)e);
            }
        });
    }

    private void logResults() {
        for (HealthState healthState : this.healthStates.values()) {
            String label;
            boolean notOkToBeLogged;
            HealthCheckExecutionResult executionResult = healthState.getExecutionResult();
            boolean isOk = executionResult.getHealthCheckResult().isOk();
            if (!LOG.isInfoEnabled() && isOk) {
                return;
            }
            boolean changeToBeLogged = healthState.hasChanged() && (this.logResults == ChangeType.STATUS_CHANGES || this.logResults == ChangeType.STATUS_CHANGES_OR_NOT_OK);
            boolean bl = notOkToBeLogged = !isOk && this.logResults == ChangeType.STATUS_CHANGES_OR_NOT_OK;
            if (!changeToBeLogged && !notOkToBeLogged && this.logResults != ChangeType.ALL) continue;
            boolean isCombinedResult = executionResult instanceof CombinedExecutionResult;
            List<Object> execResults = isCombinedResult ? ((CombinedExecutionResult)executionResult).getExecutionResults() : Arrays.asList(executionResult);
            String string = isCombinedResult ? String.format("Health State for %s '%s': healthy:%b isOk:%b hasChanged:%b count HCs:%d", healthState.isTag() ? "tag" : "name", healthState.getTagOrName(), healthState.isHealthy(), isOk, healthState.hasChanged(), execResults.size()) : (label = String.format("Health State for '%s': healthy:%b hasChanged:%b", executionResult.getHealthCheckMetadata().getTitle(), healthState.isHealthy(), healthState.hasChanged()));
            if (!healthState.hasChanged() && notOkToBeLogged) {
                execResults = execResults.stream().filter(r -> !r.getHealthCheckResult().isOk()).collect(Collectors.toList());
            }
            String logMsg = this.resultTxtVerboseSerializer.serialize(label, execResults, false);
            this.logResultItem(isOk, logMsg);
        }
    }

    void logResultItem(boolean isOk, String msg) {
        if (isOk || this.logAllResultsAsInfo) {
            LOG.info(msg);
        } else {
            LOG.warn(msg);
        }
    }

    private void runWithThreadNameContext(Runnable r) {
        String threadNameToRestore = Thread.currentThread().getName();
        try {
            Thread.currentThread().setName(this.monitorId);
            r.run();
        }
        finally {
            Thread.currentThread().setName(threadNameToRestore);
        }
    }

    ExtendedHealthCheckExecutor getExecutor() {
        return this.executor;
    }

    EventAdmin getEventAdmin() {
        return this.eventAdmin;
    }

    boolean isRegisterHealthyMarkerService() {
        return this.registerHealthyMarkerService;
    }

    boolean isRegisterUnhealthyMarkerService() {
        return this.registerUnhealthyMarkerService;
    }

    ChangeType getSendEvents() {
        return this.sendEvents;
    }

    BundleContext getBundleContext() {
        return this.bundleContext;
    }

    boolean isTreatWarnAsHealthy() {
        return this.treatWarnAsHealthy;
    }

    private final class HealthCheckServiceListener
    implements ServiceListener {
        private HealthCheckServiceListener() {
        }

        public void serviceChanged(ServiceEvent event) {
            HealthCheckMonitor.this.updateHealthStatesMap();
        }
    }

    @ObjectClassDefinition(name="Health Check Monitor", description="Regularly executes health checks according to given interval/cron expression")
    public static @interface Config {
        @AttributeDefinition(name="Tags", description="List of tags to monitor")
        public String[] tags() default {};

        @AttributeDefinition(name="Names", description="List of health check names to monitor")
        public String[] names() default {};

        @AttributeDefinition(name="Interval (Sec)", description="Will execute the checks for given tags/names every n seconds (either use intervalInSec or cronExpression )")
        public long intervalInSec() default 0L;

        @AttributeDefinition(name="Interval (Cron Expresson)", description="Will execute the checks for given tags/names according to cron expression")
        public String cronExpression() default "";

        @AttributeDefinition(name="Register Healthy Marker Service", description="For the case a given tag/name is healthy, will register a service Healthy with property tag=<tagname> (or name=<hc.name>) that other services can depend on")
        public boolean registerHealthyMarkerService() default true;

        @AttributeDefinition(name="Register Unhealthy Marker Service", description="For the case a given tag/name is unhealthy, will register a service Unhealthy with property tag=<tagname> (or name=<hc.name>) that other services can depend on")
        public boolean registerUnhealthyMarkerService() default false;

        @AttributeDefinition(name="Treat WARN as Healthy", description="Whether to treat status WARN as healthy (defaults to true because WARN indicates a working system that only possibly might become unavailable if no action is taken)")
        public boolean treatWarnAsHealthy() default true;

        @AttributeDefinition(name="Send Events", description="What updates should be sent as OSGi events (none, status changes, status changes and not ok results, all updates)")
        public ChangeType sendEvents() default ChangeType.STATUS_CHANGES;

        @AttributeDefinition(name="Log results", description="What updates should be logged to regular log file (none, status changes, status changes and not ok results, all updates)")
        public ChangeType logResults() default ChangeType.NONE;

        @AttributeDefinition(name="Log all results as INFO", description="If logResults is enabled and this is enabled, all results will be logged with INFO log level. Otherwise WARN and INFO are used depending on the health state.")
        public boolean logAllResultsAsInfo() default false;

        @AttributeDefinition(name="Resolve Tags (dynamic)", description="In dynamic mode tags are resolved to a list of health checks that are monitored individually (this means events are sent/services are registered for name only, never for given tags). This mode allows to use '*' in tags to query for all health checks in system. It is also possible to query for all except certain tags by using '-', e.g. by configuring the values '*', '-tag1' and '-tag2' for tags.")
        public boolean isDynamic() default false;

        @AttributeDefinition
        public String webconsole_configurationFactory_nameHint() default "Health Monitor for '{tags}'/'{names}', {intervalInSec}sec/{cronExpression}, Marker Service Healthy:{registerHealthyMarkerService} Unhealthy:{registerUnhealthyMarkerService}, Send Events {sendEvents}";
    }

    public static enum ChangeType {
        NONE,
        STATUS_CHANGES,
        STATUS_CHANGES_OR_NOT_OK,
        ALL;

    }
}

