/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.hc.generalchecks.scrutil;

import java.util.Collection;
import org.apache.felix.hc.api.FormattingResultLog;
import org.apache.felix.hc.generalchecks.scrutil.DsRootCauseAdapter;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ReferencePolicyOption;
import org.osgi.service.component.runtime.ServiceComponentRuntime;
import org.osgi.service.component.runtime.dto.ComponentDescriptionDTO;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(service={DsRootCauseAnalyzer.class}, immediate=true)
public class DsRootCauseAnalyzer {
    private static final Logger LOG = LoggerFactory.getLogger(DsRootCauseAnalyzer.class);
    private DsRootCauseAdapter dsRootCauseAdapter;
    @Reference(policyOption=ReferencePolicyOption.GREEDY)
    private ServiceComponentRuntime scr;

    @Activate
    public void activate() throws InterruptedException {
        String rootCauseClassName = "org.apache.felix.rootcause.DSRootCause";
        try {
            Class<?> rootCauseClass = Class.forName(rootCauseClassName);
            LOG.debug("Class {} could be loaded", rootCauseClass);
            this.dsRootCauseAdapter = new DsRootCauseAdapter(this.scr);
        }
        catch (ClassNotFoundException e) {
            LOG.debug("Class {} could NOT be loaded", (Object)rootCauseClassName, (Object)e);
            this.dsRootCauseAdapter = null;
        }
    }

    public void logMissingService(FormattingResultLog log, String missingServiceName, Collection<ComponentDescriptionDTO> componentDescriptionDTOs) {
        if (this.dsRootCauseAdapter != null) {
            this.dsRootCauseAdapter.logMissingService(log, missingServiceName, componentDescriptionDTOs);
        } else {
            log.info("Service '{}' is missing", new Object[]{missingServiceName});
        }
    }

    public void logNotEnabledComponent(FormattingResultLog log, ComponentDescriptionDTO desc, Collection<ComponentDescriptionDTO> componentDescriptionDTOs) {
        if (this.dsRootCauseAdapter != null) {
            this.dsRootCauseAdapter.logNotEnabledComponent(log, desc, componentDescriptionDTOs);
        } else {
            log.info("Component '{}' is missing", new Object[]{desc.name});
        }
    }
}

