/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.http.base.internal.dispatch;

import java.io.IOException;
import javax.servlet.FilterChain;
import javax.servlet.RequestDispatcher;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletRequestWrapper;
import javax.servlet.http.HttpServletResponse;
import org.apache.felix.http.base.internal.dispatch.InvocationFilterChain;
import org.apache.felix.http.base.internal.dispatch.RequestDispatcherProvider;
import org.apache.felix.http.base.internal.dispatch.ServletPipeline;
import org.apache.felix.http.base.internal.handler.FilterHandler;

public final class FilterPipeline {
    private final FilterHandler[] handlers;
    private final ServletPipeline servletPipeline;

    public FilterPipeline(FilterHandler[] handlers, ServletPipeline servletPipeline) {
        this.handlers = handlers;
        this.servletPipeline = servletPipeline;
    }

    public void dispatch(HttpServletRequest req, HttpServletResponse res, FilterChain proceedingChain) throws ServletException, IOException {
        InvocationFilterChain chain = new InvocationFilterChain(this.handlers, this.servletPipeline, proceedingChain);
        if (this.servletPipeline.hasServletsMapped()) {
            req = new FilterRequestWrapper((HttpServletRequest)req);
        }
        chain.doFilter((ServletRequest)req, (ServletResponse)res);
    }

    private static class FilterRequestWrapper
    extends HttpServletRequestWrapper {
        public FilterRequestWrapper(HttpServletRequest req) {
            super(req);
        }

        public RequestDispatcher getRequestDispatcher(String path) {
            RequestDispatcherProvider provider = (RequestDispatcherProvider)this.getAttribute("org.apache.felix.http.requestDispatcherProvider");
            RequestDispatcher dispatcher = null;
            if (provider != null) {
                dispatcher = provider.getRequestDispatcher(path);
            }
            return dispatcher != null ? dispatcher : super.getRequestDispatcher(path);
        }

        public String toString() {
            return ((Object)((Object)this)).getClass().getSimpleName() + "->" + super.getRequest();
        }
    }
}

