/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.http.whiteboard.internal.manager;

import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Dictionary;
import java.util.EventListener;
import java.util.Hashtable;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.servlet.Filter;
import javax.servlet.Servlet;
import javax.servlet.ServletContextAttributeListener;
import javax.servlet.ServletRequestAttributeListener;
import javax.servlet.ServletRequestListener;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSessionAttributeListener;
import javax.servlet.http.HttpSessionListener;
import org.apache.felix.http.base.internal.logger.SystemLogger;
import org.osgi.framework.ServiceReference;
import org.osgi.framework.ServiceRegistration;
import org.osgi.service.http.HttpContext;
import org.osgi.service.http.context.ServletContextHelper;

public final class ExtenderManager {
    private static final String MARKER = "org.apache.felix.http.whiteboard";
    private final Map<String, ServiceRegistration<?>> registrations = new ConcurrentHashMap();

    private void removeServiceRegistration(Type type, ServiceReference<?> ref) {
        ServiceRegistration<?> reg = this.registrations.remove(type.name() + String.valueOf(ref.getProperty("service.id")));
        if (reg != null) {
            try {
                reg.unregister();
            }
            catch (IllegalStateException illegalStateException) {
                // empty catch block
            }
        }
    }

    private void putServiceRegistration(Type type, ServiceReference<?> ref, ServiceRegistration<?> reg) {
        this.registrations.put(type.name() + String.valueOf(ref.getProperty("service.id")), reg);
    }

    private String getStringProperty(ServiceReference<?> ref, String key) {
        Object value = ref.getProperty(key);
        return value instanceof String ? (String)value : null;
    }

    private boolean getBooleanProperty(ServiceReference<?> ref, String key) {
        Object value = ref.getProperty(key);
        if (value instanceof String) {
            return Boolean.valueOf((String)value);
        }
        if (value instanceof Boolean) {
            return (Boolean)value;
        }
        return false;
    }

    private void addInitParams(ServiceReference<?> ref, String prefix, Dictionary<String, Object> props) {
        for (String key : ref.getPropertyKeys()) {
            String paramKey;
            Object paramValue;
            if (!key.startsWith("init.") || (paramValue = ref.getProperty(paramKey = key.substring("init.".length()))) == null) continue;
            props.put(prefix + paramKey, paramValue);
        }
    }

    private void addServiceRanking(ServiceReference<?> ref, Dictionary<String, Object> props) {
        Object val = ref.getProperty("service.ranking");
        if (val != null) {
            props.put("service.ranking", val);
        }
    }

    private void addHttpContextSelect(ServiceReference<?> ref, Dictionary<String, Object> props) {
        String contextId = this.getStringProperty(ref, "contextId");
        if (contextId != null) {
            StringBuilder select = new StringBuilder();
            select.append("(!(");
            select.append("osgi.http.whiteboard.context.name");
            select.append('=');
            select.append(this.getHttpContextName(ref, contextId, false));
            select.append(")(");
            select.append("osgi.http.whiteboard.context.name");
            select.append('=');
            select.append(this.getHttpContextName(ref, contextId, true));
            select.append("))");
            props.put("osgi.http.whiteboard.context.select", select.toString());
        } else {
            props.put("osgi.http.whiteboard.context.select", "(osgi.http.whiteboard.context.name=org.osgi.service.http)");
        }
    }

    private String getHttpContextName(ServiceReference<?> ref, String contextId, boolean shared) {
        StringBuilder name = new StringBuilder();
        name.append(MARKER);
        name.append('.');
        if (shared) {
            name.append("shared");
        } else {
            name.append(ref.getBundle().getBundleId());
        }
        name.append('.');
        name.append(contextId);
        return name.toString();
    }

    public void addHttpContext(final HttpContext service, ServiceReference<HttpContext> ref) {
        String contextId = this.getStringProperty(ref, "contextId");
        if (contextId != null && !contextId.isEmpty()) {
            boolean shared = this.getBooleanProperty(ref, "context.shared");
            String contextName = this.getHttpContextName(ref, contextId, shared);
            Hashtable<String, Object> props = new Hashtable<String, Object>();
            ((Dictionary)props).put("osgi.http.whiteboard.context.name", contextName);
            ((Dictionary)props).put("osgi.http.whiteboard.context.path", "/");
            ((Dictionary)props).put("osgi.http.whiteboard.context.httpservice", "true");
            ((Dictionary)props).put("org.apache.felix.http.whiteboard.id", contextId);
            ((Dictionary)props).put(MARKER, "true");
            this.addServiceRanking(ref, props);
            ServiceRegistration reg = ref.getBundle().getBundleContext().registerService(ServletContextHelper.class, (Object)new ServletContextHelper(){

                public boolean handleSecurity(HttpServletRequest request, HttpServletResponse response) throws IOException {
                    return service.handleSecurity(request, response);
                }

                public URL getResource(String name) {
                    return service.getResource(name);
                }

                public String getMimeType(String name) {
                    return service.getMimeType(name);
                }
            }, props);
            this.putServiceRegistration(Type.CONTEXT, ref, reg);
        } else {
            SystemLogger.debug("Ignoring HttpContext Service " + ref + ", " + "contextId" + " is missing or empty");
        }
    }

    public void removeHttpContext(ServiceReference<HttpContext> ref) {
        this.removeServiceRegistration(Type.CONTEXT, ref);
    }

    public void addFilter(Filter service, ServiceReference<Filter> ref) {
        String pattern = this.getStringProperty(ref, "pattern");
        if (pattern == null || pattern.isEmpty()) {
            SystemLogger.debug("Ignoring Filter Service " + ref + ", " + "pattern" + " is missing or empty");
            return;
        }
        Hashtable<String, Object> props = new Hashtable<String, Object>();
        ((Dictionary)props).put("osgi.http.whiteboard.filter.regex", pattern);
        ((Dictionary)props).put(MARKER, "true");
        this.addHttpContextSelect(ref, props);
        this.addInitParams(ref, "servlet.init.", props);
        this.addServiceRanking(ref, props);
        ServiceRegistration reg = ref.getBundle().getBundleContext().registerService(Filter.class, (Object)service, props);
        this.putServiceRegistration(Type.FILTER, ref, reg);
    }

    public void addServlet(Servlet service, ServiceReference<Servlet> ref) {
        String alias = this.getStringProperty(ref, "alias");
        if (alias == null || alias.isEmpty() || !alias.startsWith("/")) {
            SystemLogger.debug("Ignoring Servlet Service " + ref + ", " + "alias" + " is missing, empty or invalid");
            return;
        }
        Hashtable<String, Object> props = new Hashtable<String, Object>();
        ((Dictionary)props).put("osgi.http.whiteboard.servlet.pattern", alias);
        ((Dictionary)props).put(MARKER, "true");
        this.addHttpContextSelect(ref, props);
        this.addInitParams(ref, "servlet.init.", props);
        this.addServiceRanking(ref, props);
        ServiceRegistration reg = ref.getBundle().getBundleContext().registerService(Servlet.class, (Object)service, props);
        this.putServiceRegistration(Type.SERVLET, ref, reg);
    }

    public void addListeners(EventListener service, ServiceReference<EventListener> ref) {
        Hashtable<String, Object> props = new Hashtable<String, Object>();
        ArrayList<String> names = new ArrayList<String>();
        if (service instanceof HttpSessionAttributeListener) {
            names.add(HttpSessionAttributeListener.class.getName());
        }
        if (service instanceof HttpSessionListener) {
            names.add(HttpSessionListener.class.getName());
        }
        if (service instanceof ServletContextAttributeListener) {
            names.add(ServletContextAttributeListener.class.getName());
        }
        if (service instanceof ServletRequestAttributeListener) {
            names.add(ServletRequestAttributeListener.class.getName());
        }
        if (service instanceof ServletRequestListener) {
            names.add(ServletRequestListener.class.getName());
        }
        ((Dictionary)props).put(MARKER, "true");
        ((Dictionary)props).put("osgi.http.whiteboard.listener", "true");
        this.addHttpContextSelect(ref, props);
        this.addServiceRanking(ref, props);
        ServiceRegistration reg = ref.getBundle().getBundleContext().registerService(names.toArray(new String[names.size()]), (Object)service, props);
        this.putServiceRegistration(Type.LISTENERS, ref, reg);
    }

    public void removeFilter(ServiceReference<Filter> ref) {
        this.removeServiceRegistration(Type.FILTER, ref);
    }

    public void removeServlet(ServiceReference<Servlet> ref) {
        this.removeServiceRegistration(Type.SERVLET, ref);
    }

    public void removeListeners(ServiceReference<EventListener> ref) {
        this.removeServiceRegistration(Type.LISTENERS, ref);
    }

    public static enum Type {
        CONTEXT,
        FILTER,
        SERVLET,
        LISTENERS;

    }
}

