/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.ipojo.task;

import java.io.File;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.GnuParser;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.MissingArgumentException;
import org.apache.commons.cli.MissingOptionException;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.OptionBuilder;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;
import org.apache.felix.ipojo.manipulator.Pojoization;
import org.apache.felix.ipojo.manipulator.util.Constants;

public class IPojoc {
    private File m_input;
    private File m_output;
    private File m_metadata;
    private Pojoization m_pojoization;

    public static void main(String[] args) {
        Options options = IPojoc.buildOptions();
        CommandLine cmd = null;
        try {
            cmd = IPojoc.buildCommandLine(args, options);
            if (cmd.hasOption('h')) {
                IPojoc.printHelp(options);
            } else {
                IPojoc compiler = new IPojoc();
                compiler.execute(cmd);
            }
        }
        catch (MissingOptionException e) {
            for (String opt : e.getMissingOptions()) {
                System.err.println("The '" + opt + "' option is missing");
            }
            IPojoc.printHelp(options);
        }
        catch (MissingArgumentException e) {
            System.err.println("The option '" + e.getOption() + "' requires an argument");
            IPojoc.printHelp(options);
        }
        catch (Exception e) {
            System.out.printf("Manipulation failed: %s%n", e.getMessage());
            if (cmd != null && cmd.hasOption('X')) {
                e.printStackTrace(System.out);
            }
            System.out.printf("Use -X option to print the full stack trace%n", new Object[0]);
        }
    }

    private static CommandLine buildCommandLine(String[] args, Options options) throws ParseException {
        GnuParser parser = new GnuParser();
        return parser.parse(options, args);
    }

    private void execute(CommandLine cmd) throws Exception {
        System.out.printf("iPOJO Manipulation (%s)%n", Constants.getVersion());
        System.out.println("-----------------------------------------------");
        this.readInputOption(cmd);
        this.readOutputOption(cmd);
        this.readMetadataOption(cmd);
        this.manipulate();
        this.printStatus();
    }

    private void readMetadataOption(CommandLine cmd) throws Exception {
        if (cmd.hasOption("m")) {
            this.m_metadata = (File)cmd.getParsedOptionValue("m");
            if (this.m_metadata != null && !this.m_metadata.isFile()) {
                throw new Exception(String.format("The metadata option must be an existing file, '%s' does not exist", cmd.getOptionValue('m')));
            }
            System.out.println("metadata file  => " + this.m_metadata.getAbsolutePath());
        } else {
            System.out.println("metadata file  => no metadata file");
        }
    }

    private void readOutputOption(CommandLine cmd) throws Exception {
        if (cmd.hasOption("o")) {
            try {
                this.m_output = (File)cmd.getParsedOptionValue("o");
            }
            catch (ParseException pe) {
                throw new Exception(String.format("The output option must be an existing file, '%s' does not exist", cmd.getOptionValue('o')));
            }
            System.out.println("output file    => " + this.m_output.getAbsolutePath());
        } else {
            this.m_output = new File("__" + this.m_input.getName());
            System.out.println("output file    => " + this.m_input.getAbsolutePath());
        }
    }

    private void readInputOption(CommandLine cmd) throws Exception {
        this.m_input = (File)cmd.getParsedOptionValue("i");
        if (this.m_input == null || !this.m_input.isFile()) {
            throw new Exception(String.format("The input option must be an existing file, '%s' does not exist", cmd.getOptionValue('i')));
        }
        System.out.println("input file     => " + this.m_input.getAbsolutePath());
    }

    private void manipulate() {
        this.m_pojoization = new Pojoization();
        this.m_pojoization.pojoization(this.m_input, this.m_output, this.m_metadata);
    }

    private void printStatus() {
        if (this.m_pojoization.getErrors().size() != 0) {
            System.err.println("iPOJO Manipulation failed :");
            for (String error : this.m_pojoization.getErrors()) {
                System.err.println("\t" + error);
            }
            System.exit(-1);
        } else {
            System.err.println("iPOJO Manipulation successfully completed.");
            for (String warning : this.m_pojoization.getWarnings()) {
                System.err.println(warning);
            }
            this.cleanup();
            System.exit(0);
        }
    }

    private void cleanup() {
        if (this.m_output.getName().startsWith("__")) {
            this.m_input.delete();
            this.m_output.renameTo(this.m_input);
        }
    }

    private static void printHelp(Options options) {
        HelpFormatter formatter = new HelpFormatter();
        formatter.printHelp("java -jar org.apache.felix.ipojo.ant-" + Constants.getVersion() + ".jar", options);
    }

    public static Options buildOptions() {
        OptionBuilder.withArgName("input file");
        OptionBuilder.withLongOpt("input");
        OptionBuilder.hasArg();
        OptionBuilder.withDescription("the input jar file");
        OptionBuilder.isRequired(true);
        OptionBuilder.withType(File.class);
        Option input = OptionBuilder.create('i');
        OptionBuilder.withLongOpt("output");
        OptionBuilder.withArgName("output file");
        OptionBuilder.hasArg();
        OptionBuilder.withDescription("the output jar file, if not set the manipulation replaces the input file");
        OptionBuilder.isRequired(false);
        OptionBuilder.withType(File.class);
        Option output = OptionBuilder.create('o');
        OptionBuilder.withLongOpt("metadata");
        OptionBuilder.withArgName("metadata file");
        OptionBuilder.hasArg();
        OptionBuilder.withDescription("the XML metadata file");
        OptionBuilder.isRequired(false);
        OptionBuilder.withType(File.class);
        Option metadata = OptionBuilder.create('m');
        Option verbose = new Option("X", "exception", false, "print exception stack trace in case of error");
        OptionBuilder.withLongOpt("help");
        OptionBuilder.withDescription("print this message");
        Option help = OptionBuilder.create('h');
        return new Options().addOption(input).addOption(output).addOption(metadata).addOption(verbose).addOption(help);
    }
}

