/*
 * Decompiled with CFR 0.152.
 */
package org.cybergarage.net;

import java.net.InetAddress;
import java.net.UnknownHostException;
import org.cybergarage.util.Debug;

public class HostInterface {
    public static boolean USE_LOOPBACK_ADDR = false;
    public static boolean USE_ONLY_IPV4_ADDR = false;
    public static boolean USE_ONLY_IPV6_ADDR = false;
    private static String ifAddress = "";
    public static final int IPV4_BITMASK = 1;
    public static final int IPV6_BITMASK = 16;
    public static final int LOCAL_BITMASK = 256;

    public static final void setInterface(String ifaddr) {
        ifAddress = ifaddr;
    }

    public static final String getInterface() {
        return ifAddress;
    }

    private static final boolean hasAssignedInterface() {
        return 0 < ifAddress.length();
    }

    public static final int getNHostAddresses() {
        if (HostInterface.hasAssignedInterface()) {
            return 1;
        }
        try {
            InetAddress.getLocalHost();
            return 1;
        }
        catch (Exception e) {
            Debug.warning("Unable to retrive hostname and/or IP", e);
            return 0;
        }
    }

    public static final String getHostAddress(int n) {
        if (HostInterface.hasAssignedInterface()) {
            return HostInterface.getInterface();
        }
        if (n <= 1) {
            try {
                return InetAddress.getLocalHost().getHostAddress();
            }
            catch (UnknownHostException e) {
                Debug.warning("Unable to retrive hostname and/or IP", e);
            }
        }
        return "";
    }

    public static final boolean hasIPv4Addresses() {
        int addrCnt = HostInterface.getNHostAddresses();
        return addrCnt > 0;
    }

    public static final String getIPv4Address() {
        int n = 0;
        int addrCnt = HostInterface.getNHostAddresses();
        if (n < addrCnt) {
            String addr = HostInterface.getHostAddress(n);
            return addr;
        }
        return "";
    }

    public static final String getHostURL(String host, int port, String uri) {
        String hostAddr = host;
        return "http://" + hostAddr + ":" + Integer.toString(port) + uri;
    }
}

