/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.upnp.tester;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.net.URL;
import javax.swing.AbstractAction;
import javax.swing.ButtonGroup;
import javax.swing.ImageIcon;
import javax.swing.JFrame;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JRadioButtonMenuItem;
import javax.swing.JSplitPane;
import javax.swing.event.PopupMenuEvent;
import javax.swing.event.PopupMenuListener;
import org.apache.felix.upnp.tester.Activator;
import org.apache.felix.upnp.tester.Mediator;
import org.apache.felix.upnp.tester.discovery.DriverProxy;
import org.apache.felix.upnp.tester.discovery.RootDeviceListener;
import org.apache.felix.upnp.tester.gui.LogPanel;
import org.apache.felix.upnp.tester.gui.PropertiesViewer;
import org.apache.felix.upnp.tester.gui.TreeViewer;
import org.osgi.framework.BundleException;

public class ControlPoint
implements PopupMenuListener {
    RootDeviceListener listener;
    TreeViewer viewer;
    PropertiesViewer properties;
    JFrame frame = new JFrame("Felix UPnPDevice Tester");
    JMenu searchMenu;
    JMenu loggerMenu;
    JMenu cyberMenu;
    static /* synthetic */ Class class$org$apache$felix$upnp$tester$gui$Util;

    public ControlPoint() {
        try {
            URL eventIconUrl = (class$org$apache$felix$upnp$tester$gui$Util == null ? (class$org$apache$felix$upnp$tester$gui$Util = ControlPoint.class$("org.apache.felix.upnp.tester.gui.Util")) : class$org$apache$felix$upnp$tester$gui$Util).getResource("IMAGES/logo.gif");
            ImageIcon icon = new ImageIcon(eventIconUrl, "logo");
            this.frame.setIconImage(icon.getImage());
        }
        catch (Exception ex) {
            System.out.println("Resource: IMAGES/logo.gif not found : " + ex.toString());
        }
        this.frame.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent e) {
                try {
                    Activator.context.getBundle().stop();
                }
                catch (BundleException ex) {
                    ex.printStackTrace();
                }
            }
        });
        this.frame.setBounds(0, 0, 300, 200);
        this.doMenuBar(this.frame);
        this.doControlPanel();
        Mediator.setControlPoint(this);
        Mediator.setMainFrame(this.frame);
        this.listener = new RootDeviceListener();
        Mediator.setRootDeviceListener(this.listener);
        this.listener.setDeviceNodeListener(this.viewer);
        this.frame.pack();
        this.frame.setVisible(true);
        DriverProxy driverProxy = new DriverProxy();
        Mediator.setDriverProxy(driverProxy);
        this.listener.activate();
    }

    public void close() {
        this.listener.deactive();
        this.frame.dispose();
        Mediator.getDriverProxy().close();
    }

    private void doControlPanel() {
        JPanel panel = new JPanel(new BorderLayout());
        this.viewer = new TreeViewer();
        this.viewer.setPreferredSize(new Dimension(180, 450));
        this.properties = new PropertiesViewer();
        Mediator.setPropertiesViewer(this.properties);
        JSplitPane treeSplitter = new JSplitPane(1, this.viewer, this.properties);
        LogPanel logPanel = new LogPanel();
        logPanel.setPreferredSize(new Dimension(180, 100));
        JSplitPane logSplitter = new JSplitPane(0, treeSplitter, logPanel);
        panel.add(logSplitter);
        this.frame.getContentPane().add(panel);
    }

    public void doMenuBar(JFrame frame) {
        JMenuBar menuBar = new JMenuBar();
        JMenu file_menu = new JMenu("File");
        file_menu.setMnemonic(70);
        this.searchMenu = new JMenu("Search");
        String ALL_DEVICE = "ssdp:all";
        String ROOT_DEVICE = "upnp:rootdevice";
        this.searchMenu.setMnemonic(76);
        this.searchMenu.setEnabled(false);
        AbstractAction searchAction = new AbstractAction(){

            public void actionPerformed(ActionEvent e) {
                DriverProxy controller = Mediator.getDriverProxy();
                if (e.getActionCommand().equals("ssdp:all")) {
                    controller.doSearch("ssdp:all");
                } else if (e.getActionCommand().equals("upnp:rootdevice")) {
                    controller.doSearch("upnp:rootdevice");
                }
            }
        };
        JMenuItem rootDeviceItem = new JMenuItem("Root Devices");
        rootDeviceItem.setMnemonic(82);
        rootDeviceItem.addActionListener(searchAction);
        rootDeviceItem.setActionCommand("upnp:rootdevice");
        this.searchMenu.add(rootDeviceItem);
        JMenuItem allDeviceItem = new JMenuItem("All Devices");
        allDeviceItem.setMnemonic(65);
        allDeviceItem.addActionListener(searchAction);
        allDeviceItem.setActionCommand("ssdp:all");
        this.searchMenu.add(allDeviceItem);
        JMenuItem checkIncompleteItem = new JMenuItem("Print Pending Devices");
        checkIncompleteItem.setMnemonic(73);
        checkIncompleteItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                Mediator.getRootDeviceListener().checkIncompleteDevice();
            }
        });
        JMenuItem checkErrataItem = new JMenuItem("Check Errata UPnPDevices");
        checkErrataItem.setMnemonic(69);
        checkErrataItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                RootDeviceListener.checkErrataDevice();
            }
        });
        this.loggerMenu = new JMenu("Felix Logger");
        String NO_LOGGING = "No Logging";
        String ERROR = "Error";
        String WARNING = "Warning";
        String INFO = "Info";
        String DEBUG = "Debug";
        this.loggerMenu.getPopupMenu().addPopupMenuListener(this);
        this.loggerMenu.setMnemonic(76);
        this.loggerMenu.setEnabled(false);
        AbstractAction loggerAction = new AbstractAction(){

            public void actionPerformed(ActionEvent e) {
                DriverProxy controller = Mediator.getDriverProxy();
                if (e.getActionCommand().equals("No Logging")) {
                    controller.setLogLevel(0);
                } else if (e.getActionCommand().equals("Error")) {
                    controller.setLogLevel(1);
                } else if (e.getActionCommand().equals("Warning")) {
                    controller.setLogLevel(2);
                } else if (e.getActionCommand().equals("Info")) {
                    controller.setLogLevel(3);
                } else if (e.getActionCommand().equals("Debug")) {
                    controller.setLogLevel(4);
                }
            }
        };
        ButtonGroup group = new ButtonGroup();
        JRadioButtonMenuItem rbMenuItem = new JRadioButtonMenuItem("No Logging");
        rbMenuItem.setSelected(true);
        rbMenuItem.setMnemonic(78);
        rbMenuItem.setActionCommand("No Logging");
        rbMenuItem.addActionListener(loggerAction);
        group.add(rbMenuItem);
        this.loggerMenu.add(rbMenuItem);
        this.loggerMenu.addSeparator();
        rbMenuItem = new JRadioButtonMenuItem("Error");
        rbMenuItem.setMnemonic(69);
        rbMenuItem.setActionCommand("Error");
        rbMenuItem.addActionListener(loggerAction);
        group.add(rbMenuItem);
        this.loggerMenu.add(rbMenuItem);
        rbMenuItem = new JRadioButtonMenuItem("Warning");
        rbMenuItem.setMnemonic(87);
        rbMenuItem.setActionCommand("Warning");
        rbMenuItem.addActionListener(loggerAction);
        group.add(rbMenuItem);
        this.loggerMenu.add(rbMenuItem);
        rbMenuItem = new JRadioButtonMenuItem("Info");
        rbMenuItem.setMnemonic(73);
        rbMenuItem.setActionCommand("Info");
        rbMenuItem.addActionListener(loggerAction);
        group.add(rbMenuItem);
        this.loggerMenu.add(rbMenuItem);
        rbMenuItem = new JRadioButtonMenuItem("Debug");
        rbMenuItem.setMnemonic(68);
        rbMenuItem.setActionCommand("Debug");
        rbMenuItem.addActionListener(loggerAction);
        group.add(rbMenuItem);
        this.loggerMenu.add(rbMenuItem);
        String ON = "On";
        String OFF = "Off";
        this.cyberMenu = new JMenu("Cyber Debugger");
        this.cyberMenu.getPopupMenu().addPopupMenuListener(this);
        this.cyberMenu.setMnemonic(67);
        this.cyberMenu.setEnabled(false);
        AbstractAction cyberAction = new AbstractAction(){

            public void actionPerformed(ActionEvent e) {
                DriverProxy controller = Mediator.getDriverProxy();
                if (e.getActionCommand().equals("On")) {
                    controller.setCyberDebug(true);
                } else if (e.getActionCommand().equals("Off")) {
                    controller.setCyberDebug(false);
                }
            }
        };
        ButtonGroup cyberGroup = new ButtonGroup();
        rbMenuItem = new JRadioButtonMenuItem("On");
        rbMenuItem.setSelected(true);
        rbMenuItem.setMnemonic(79);
        rbMenuItem.setActionCommand("On");
        rbMenuItem.addActionListener(cyberAction);
        cyberGroup.add(rbMenuItem);
        this.cyberMenu.add(rbMenuItem);
        rbMenuItem = new JRadioButtonMenuItem("Off");
        rbMenuItem.setMnemonic(70);
        rbMenuItem.setActionCommand("Off");
        rbMenuItem.addActionListener(cyberAction);
        cyberGroup.add(rbMenuItem);
        this.cyberMenu.add(rbMenuItem);
        JMenuItem exitItem = new JMenuItem("Exit");
        exitItem.setMnemonic(88);
        exitItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                try {
                    Activator.context.getBundle().stop();
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
            }
        });
        file_menu.add(this.searchMenu);
        file_menu.addSeparator();
        file_menu.add(this.loggerMenu);
        file_menu.add(this.cyberMenu);
        file_menu.addSeparator();
        file_menu.add(checkIncompleteItem);
        file_menu.add(checkErrataItem);
        file_menu.addSeparator();
        file_menu.add(exitItem);
        menuBar.add(file_menu);
        frame.setJMenuBar(menuBar);
    }

    public void enableMenus(boolean driverAvailable, int logLevel, boolean cyberDebug) {
        int i;
        this.searchMenu.setEnabled(driverAvailable);
        Component[] items = this.searchMenu.getPopupMenu().getComponents();
        for (i = 0; i < items.length; ++i) {
            items[i].setEnabled(driverAvailable);
        }
        this.loggerMenu.setEnabled(driverAvailable);
        items = this.loggerMenu.getPopupMenu().getComponents();
        for (i = 0; i < items.length; ++i) {
            items[i].setEnabled(driverAvailable);
        }
        if (driverAvailable) {
            ((JRadioButtonMenuItem)items[logLevel > 0 ? logLevel + 1 : 0]).setSelected(true);
        }
        this.cyberMenu.setEnabled(driverAvailable);
        items = this.cyberMenu.getPopupMenu().getComponents();
        for (i = 0; i < items.length; ++i) {
            items[i].setEnabled(driverAvailable);
        }
        if (driverAvailable) {
            if (cyberDebug) {
                ((JRadioButtonMenuItem)items[0]).setSelected(true);
            } else {
                ((JRadioButtonMenuItem)items[1]).setSelected(true);
            }
        }
    }

    public void popupMenuCanceled(PopupMenuEvent e) {
    }

    public void popupMenuWillBecomeInvisible(PopupMenuEvent e) {
    }

    public void popupMenuWillBecomeVisible(PopupMenuEvent e) {
        JPopupMenu loggerPopup = this.loggerMenu.getPopupMenu();
        JPopupMenu cyberPopup = this.cyberMenu.getPopupMenu();
        if (e.getSource() == loggerPopup) {
            int logLevel = Mediator.getDriverProxy().getLogLevel();
            Component[] items = loggerPopup.getComponents();
            ((JRadioButtonMenuItem)items[logLevel > 0 ? logLevel + 1 : 0]).setSelected(true);
        } else if (e.getSource() == cyberPopup) {
            boolean cyberDebug = Mediator.getDriverProxy().getCyberDebug();
            Component[] items = cyberPopup.getComponents();
            if (cyberDebug) {
                ((JRadioButtonMenuItem)items[0]).setSelected(true);
            } else {
                ((JRadioButtonMenuItem)items[1]).setSelected(true);
            }
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

