/*
 * Decompiled with CFR 0.152.
 */
package flex2.compiler;

import flex2.compiler.CompilationUnit;
import flex2.compiler.CompilerAPI;
import flex2.compiler.CompilerContext;
import flex2.compiler.CompilerException;
import flex2.compiler.Source;
import flex2.compiler.SourcePathBase;
import flex2.compiler.common.SinglePathResolver;
import flex2.compiler.io.FileUtil;
import flex2.compiler.io.LocalFile;
import flex2.compiler.io.VirtualFile;
import flex2.compiler.util.QName;
import flex2.tools.oem.ApplicationCache;
import java.io.File;
import java.util.LinkedList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SourcePath
extends SourcePathBase
implements SinglePathResolver {
    protected final List<File> directories = new LinkedList<File>();
    private ApplicationCache applicationCache;

    public SourcePath(VirtualFile[] classPath, VirtualFile appPath, String[] mimeTypes, boolean allowSourcePathOverlap) {
        this(mimeTypes, allowSourcePathOverlap);
        SourcePath.addApplicationParentToSourcePath(appPath, classPath, this.directories);
        SourcePath.addPathElements(classPath, this.directories, allowSourcePathOverlap, this.warnings);
    }

    public SourcePath(String[] mimeTypes, boolean allowSourcePathOverlap) {
        super(mimeTypes, allowSourcePathOverlap);
    }

    public void addPathElements(VirtualFile[] classPath) {
        SourcePath.addPathElements(classPath, this.directories, this.allowSourcePathOverlap, this.warnings);
    }

    private Source newSource(File file, File pathRoot, String namespaceURI, String localPart) {
        String className;
        Source cachedSource;
        Source source = new Source((VirtualFile)new LocalFile(file), new LocalFile(pathRoot), namespaceURI.replace('.', '/'), localPart, this, false, false);
        if (this.applicationCache != null && (cachedSource = this.applicationCache.getSource(className = CompilerAPI.constructClassName(namespaceURI, localPart))) != null && !cachedSource.isUpdated()) {
            CompilationUnit cachedCompilationUnit = cachedSource.getCompilationUnit();
            if (cachedSource.getPathRoot().equals(source.getPathRoot()) && cachedCompilationUnit != null && cachedCompilationUnit.hasTypeInfo) {
                CompilationUnit compilationUnit = source.newCompilationUnit(cachedCompilationUnit.getSyntaxTree(), new CompilerContext());
                Source.copyCompilationUnit(cachedCompilationUnit, compilationUnit, true);
                source.setFileTime(cachedSource.getFileTime());
                cachedSource.reused();
            }
        }
        return source;
    }

    @Override
    boolean checkPreference(Source s) {
        assert (s.getOwner() == this);
        String relativePath = this.constructRelativePath(s);
        String pathRoot = s.getPathRoot().getName();
        if (relativePath == null) {
            return true;
        }
        boolean thisPath = false;
        int size = this.directories.size();
        for (int i = 0; i < size; ++i) {
            File d = this.directories.get(i);
            File f = null;
            if (pathRoot.equals(FileUtil.getCanonicalPath(d))) {
                thisPath = true;
            }
            try {
                f = this.findFile(d, relativePath, this.mimeTypes);
            }
            catch (CompilerException ex) {
                this.removeSource(s);
                return false;
            }
            if (f == null || thisPath) continue;
            this.removeSource(s);
            return false;
        }
        return true;
    }

    @Override
    protected Source findFile(String className, String namespaceURI, String localPart) throws CompilerException {
        String p = className.replace(':', '.').replace('.', File.separatorChar);
        Source s = null;
        int size = this.directories.size();
        for (int i = 0; i < size; ++i) {
            File d = this.directories.get(i);
            File f = this.findFile(d, p, this.mimeTypes);
            if (f == null) continue;
            s = this.newSource(f, d, namespaceURI, localPart);
            this.sources.put(className, s);
            return s;
        }
        return null;
    }

    public boolean hasPackage(String packageName) {
        int size = this.directories.size();
        for (int i = 0; i < size; ++i) {
            File d = this.directories.get(i);
            if (!this.hasDirectory(d, packageName)) continue;
            return true;
        }
        return false;
    }

    public boolean hasDefinition(QName qName) {
        String className = CompilerAPI.constructClassName(qName.getNamespace(), qName.getLocalPart());
        if (this.misses.contains(className)) {
            return false;
        }
        if (this.hits.contains(className)) {
            return true;
        }
        String p = className.replace(':', '.').replace('.', File.separatorChar);
        int size = this.directories.size();
        for (int i = 0; i < size; ++i) {
            File d = this.directories.get(i);
            try {
                File f = this.findFile(d, p, this.mimeTypes);
                if (f == null) continue;
                this.hits.add(className);
                return true;
            }
            catch (CompilerException compilerException) {
                // empty catch block
            }
        }
        this.misses.add(className);
        return false;
    }

    private boolean hasDirectory(File dir, String packageName) {
        if (packageName.length() == 0) {
            return true;
        }
        String relativePath = packageName.replace('.', File.separatorChar);
        String fullPath = dir.getPath() + File.separator + relativePath;
        if (this.dirs.get(fullPath) == "") {
            return false;
        }
        boolean result = new File(dir, relativePath).isDirectory();
        this.dirs.put(fullPath, result ? fullPath : "");
        return result;
    }

    public List<File> getPaths() {
        return this.directories;
    }

    @Override
    public VirtualFile resolve(String path) {
        if (path.charAt(0) == '/') {
            String relativePath = path.substring(1);
            for (File directory : this.directories) {
                File file = FileUtil.openFile(directory, relativePath);
                if (file == null || !file.exists()) continue;
                return new LocalFile(file);
            }
        }
        return null;
    }

    public void setApplicationCache(ApplicationCache applicationCache) {
        this.applicationCache = applicationCache;
    }
}

