/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.collections.comparators;

import java.io.Serializable;
import java.util.Comparator;

public final class BooleanComparator
implements Comparator,
Serializable {
    private boolean trueFirst = false;
    private static final BooleanComparator TRUE_FIRST = new BooleanComparator(true);
    private static final BooleanComparator FALSE_FIRST = new BooleanComparator(false);

    public BooleanComparator() {
        this(false);
    }

    public BooleanComparator(boolean trueFirst) {
        this.trueFirst = trueFirst;
    }

    public int compare(Object o1, Object o2) {
        return this.compare((Boolean)o1, (Boolean)o2);
    }

    public int compare(Boolean b1, Boolean b2) {
        boolean v2;
        boolean v1 = b1;
        return v1 ^ (v2 = b2.booleanValue()) ? (v1 ^ this.trueFirst ? 1 : -1) : 0;
    }

    public int hashCode() {
        int hash = "BooleanComparator".hashCode();
        return this.trueFirst ? -1 * hash : hash;
    }

    public boolean equals(Object that) {
        return this == that || that instanceof BooleanComparator && this.trueFirst == ((BooleanComparator)that).trueFirst;
    }

    public boolean sortsTrueFirst() {
        return this.trueFirst;
    }

    public static BooleanComparator getTrueFirstComparator() {
        return TRUE_FIRST;
    }

    public static BooleanComparator getFalseFirstComparator() {
        return FALSE_FIRST;
    }

    public static BooleanComparator getBooleanComparator(boolean trueFirst) {
        return trueFirst ? TRUE_FIRST : FALSE_FIRST;
    }
}

