/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.store.shaded.org.apache.flink.formats.avro;

import java.io.IOException;
import java.util.Objects;
import javax.annotation.Nullable;
import org.apache.flink.api.common.serialization.DeserializationSchema;
import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.table.store.avro.shaded.org.apache.avro.Schema;
import org.apache.flink.table.store.avro.shaded.org.apache.avro.generic.GenericData;
import org.apache.flink.table.store.avro.shaded.org.apache.avro.generic.GenericDatumReader;
import org.apache.flink.table.store.avro.shaded.org.apache.avro.generic.GenericRecord;
import org.apache.flink.table.store.avro.shaded.org.apache.avro.io.Decoder;
import org.apache.flink.table.store.avro.shaded.org.apache.avro.io.DecoderFactory;
import org.apache.flink.table.store.avro.shaded.org.apache.avro.specific.SpecificData;
import org.apache.flink.table.store.avro.shaded.org.apache.avro.specific.SpecificDatumReader;
import org.apache.flink.table.store.avro.shaded.org.apache.avro.specific.SpecificRecord;
import org.apache.flink.table.store.shaded.org.apache.flink.formats.avro.typeutils.AvroFactory;
import org.apache.flink.table.store.shaded.org.apache.flink.formats.avro.typeutils.AvroTypeInfo;
import org.apache.flink.table.store.shaded.org.apache.flink.formats.avro.typeutils.GenericRecordAvroTypeInfo;
import org.apache.flink.table.store.shaded.org.apache.flink.formats.avro.utils.MutableByteArrayInputStream;
import org.apache.flink.util.Preconditions;

public class AvroDeserializationSchema<T>
implements DeserializationSchema<T> {
    private static final long serialVersionUID = -6766681879020862312L;
    private final Class<T> recordClazz;
    private final String schemaString;
    private transient GenericDatumReader<T> datumReader;
    private transient MutableByteArrayInputStream inputStream;
    private transient Decoder decoder;
    private transient Schema reader;

    public static AvroDeserializationSchema<GenericRecord> forGeneric(Schema schema) {
        return new AvroDeserializationSchema<GenericRecord>(GenericRecord.class, schema);
    }

    public static <T extends SpecificRecord> AvroDeserializationSchema<T> forSpecific(Class<T> tClass) {
        return new AvroDeserializationSchema<T>(tClass, null);
    }

    AvroDeserializationSchema(Class<T> recordClazz, @Nullable Schema reader) {
        Preconditions.checkNotNull(recordClazz, (String)"Avro record class must not be null.");
        this.recordClazz = recordClazz;
        this.reader = reader;
        this.schemaString = reader != null ? reader.toString() : null;
    }

    GenericDatumReader<T> getDatumReader() {
        return this.datumReader;
    }

    Schema getReaderSchema() {
        return this.reader;
    }

    MutableByteArrayInputStream getInputStream() {
        return this.inputStream;
    }

    Decoder getDecoder() {
        return this.decoder;
    }

    public T deserialize(@Nullable byte[] message) throws IOException {
        if (message == null) {
            return null;
        }
        this.checkAvroInitialized();
        this.inputStream.setBuffer(message);
        Schema readerSchema = this.getReaderSchema();
        GenericDatumReader<T> datumReader = this.getDatumReader();
        datumReader.setSchema(readerSchema);
        return datumReader.read(null, this.decoder);
    }

    void checkAvroInitialized() {
        if (this.datumReader != null) {
            return;
        }
        ClassLoader cl = Thread.currentThread().getContextClassLoader();
        if (SpecificRecord.class.isAssignableFrom(this.recordClazz)) {
            SpecificData specificData = AvroFactory.getSpecificDataForClass(this.recordClazz, cl);
            this.datumReader = new SpecificDatumReader(specificData);
            this.reader = AvroFactory.extractAvroSpecificSchema(this.recordClazz, specificData);
        } else {
            this.reader = new Schema.Parser().parse(this.schemaString);
            GenericData genericData = new GenericData(cl);
            this.datumReader = new GenericDatumReader(null, this.reader, genericData);
        }
        this.inputStream = new MutableByteArrayInputStream();
        this.decoder = DecoderFactory.get().binaryDecoder(this.inputStream, null);
    }

    public boolean isEndOfStream(T nextElement) {
        return false;
    }

    public TypeInformation<T> getProducedType() {
        if (SpecificRecord.class.isAssignableFrom(this.recordClazz)) {
            return new AvroTypeInfo<T>(this.recordClazz);
        }
        return new GenericRecordAvroTypeInfo(this.reader);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AvroDeserializationSchema that = (AvroDeserializationSchema)o;
        return this.recordClazz.equals(that.recordClazz) && Objects.equals(this.reader, that.reader);
    }

    public int hashCode() {
        return Objects.hash(this.recordClazz, this.reader);
    }
}

