/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.store.table;

import java.io.IOException;
import org.apache.flink.core.fs.Path;
import org.apache.flink.table.data.RowData;
import org.apache.flink.table.store.CoreOptions;
import org.apache.flink.table.store.file.AppendOnlyFileStore;
import org.apache.flink.table.store.file.operation.AppendOnlyFileStoreRead;
import org.apache.flink.table.store.file.operation.AppendOnlyFileStoreScan;
import org.apache.flink.table.store.file.operation.FileStoreWrite;
import org.apache.flink.table.store.file.predicate.Predicate;
import org.apache.flink.table.store.file.schema.SchemaManager;
import org.apache.flink.table.store.file.schema.TableSchema;
import org.apache.flink.table.store.file.utils.FileStorePathFactory;
import org.apache.flink.table.store.file.utils.RecordReader;
import org.apache.flink.table.store.file.writer.RecordWriter;
import org.apache.flink.table.store.table.AbstractFileStoreTable;
import org.apache.flink.table.store.table.sink.AbstractTableWrite;
import org.apache.flink.table.store.table.sink.SinkRecord;
import org.apache.flink.table.store.table.sink.SinkRecordConverter;
import org.apache.flink.table.store.table.sink.TableWrite;
import org.apache.flink.table.store.table.source.AppendOnlySplitGenerator;
import org.apache.flink.table.store.table.source.Split;
import org.apache.flink.table.store.table.source.SplitGenerator;
import org.apache.flink.table.store.table.source.TableRead;
import org.apache.flink.table.store.table.source.TableScan;
import org.apache.flink.types.RowKind;
import org.apache.flink.util.Preconditions;

public class AppendOnlyFileStoreTable
extends AbstractFileStoreTable {
    private static final long serialVersionUID = 1L;
    private final AppendOnlyFileStore store;

    AppendOnlyFileStoreTable(Path path, SchemaManager schemaManager, TableSchema tableSchema) {
        super(path, tableSchema);
        this.store = new AppendOnlyFileStore(schemaManager, tableSchema.id(), new CoreOptions(tableSchema.options()), tableSchema.logicalPartitionType(), tableSchema.logicalBucketKeyType(), tableSchema.logicalRowType());
    }

    @Override
    public TableScan newScan() {
        final AppendOnlyFileStoreScan scan = this.store.newScan();
        return new TableScan(scan, this.tableSchema, this.store.pathFactory()){

            @Override
            protected SplitGenerator splitGenerator(FileStorePathFactory pathFactory) {
                return new AppendOnlySplitGenerator(AppendOnlyFileStoreTable.this.store.options().splitTargetSize(), AppendOnlyFileStoreTable.this.store.options().splitOpenFileCost());
            }

            @Override
            protected void withNonPartitionFilter(Predicate predicate) {
                scan.withFilter(predicate);
            }
        };
    }

    @Override
    public TableRead newRead() {
        final AppendOnlyFileStoreRead read = this.store.newRead();
        return new TableRead(){

            @Override
            public TableRead withFilter(Predicate predicate) {
                read.withFilter(predicate);
                return this;
            }

            @Override
            public TableRead withProjection(int[][] projection) {
                read.withProjection(projection);
                return this;
            }

            @Override
            public RecordReader<RowData> createReader(Split split) throws IOException {
                return read.createReader(split);
            }
        };
    }

    @Override
    public TableWrite newWrite() {
        SinkRecordConverter recordConverter = new SinkRecordConverter(this.store.options().bucket(), this.tableSchema);
        return new AbstractTableWrite<RowData>((FileStoreWrite)this.store.newWrite(), recordConverter){

            @Override
            protected void writeSinkRecord(SinkRecord record, RecordWriter<RowData> writer) throws Exception {
                Preconditions.checkState((record.row().getRowKind() == RowKind.INSERT ? 1 : 0) != 0, (String)"Append only writer can not accept row with RowKind %s", (Object[])new Object[]{record.row().getRowKind()});
                writer.write(record.row());
            }
        };
    }

    public AppendOnlyFileStore store() {
        return this.store;
    }
}

