/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.scheduler;

import org.apache.flink.api.common.JobID;
import org.apache.flink.api.common.JobStatus;
import org.apache.flink.runtime.executiongraph.JobStatusListener;
import org.apache.flink.runtime.executiongraph.JobStatusProvider;

public class JobStatusStore
implements JobStatusListener,
JobStatusProvider {
    private final long[] stateTimestamps = new long[JobStatus.values().length];
    private JobStatus jobStatus = JobStatus.INITIALIZING;

    public JobStatusStore(long initializationTimestamp) {
        this.stateTimestamps[JobStatus.INITIALIZING.ordinal()] = initializationTimestamp;
    }

    @Override
    public void jobStatusChanges(JobID jobId, JobStatus newJobStatus, long timestamp) {
        this.jobStatus = newJobStatus;
        this.stateTimestamps[this.jobStatus.ordinal()] = timestamp;
    }

    @Override
    public JobStatus getState() {
        return this.jobStatus;
    }

    @Override
    public long getStatusTimestamp(JobStatus status) {
        return this.stateTimestamps[status.ordinal()];
    }
}

