/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.store.spark;

import java.io.IOException;
import java.io.UncheckedIOException;
import java.util.List;
import org.apache.flink.table.data.RowData;
import org.apache.flink.table.store.file.predicate.Predicate;
import org.apache.flink.table.store.file.predicate.PredicateBuilder;
import org.apache.flink.table.store.file.utils.RecordReader;
import org.apache.flink.table.store.file.utils.RecordReaderIterator;
import org.apache.flink.table.store.spark.SparkInputPartition;
import org.apache.flink.table.store.spark.SparkInternalRow;
import org.apache.flink.table.store.table.FileStoreTable;
import org.apache.flink.table.store.table.source.TableRead;
import org.apache.flink.table.store.utils.TypeUtils;
import org.apache.flink.table.types.logical.RowType;
import org.apache.spark.sql.catalyst.InternalRow;
import org.apache.spark.sql.connector.read.InputPartition;
import org.apache.spark.sql.connector.read.PartitionReader;
import org.apache.spark.sql.connector.read.PartitionReaderFactory;

public class SparkReaderFactory
implements PartitionReaderFactory {
    private static final long serialVersionUID = 1L;
    private final FileStoreTable table;
    private final int[] projectedFields;
    private final List<Predicate> predicates;

    public SparkReaderFactory(FileStoreTable table, int[] projectedFields, List<Predicate> predicates) {
        this.table = table;
        this.projectedFields = projectedFields;
        this.predicates = predicates;
    }

    private RowType readRowType() {
        return TypeUtils.project(this.table.schema().logicalRowType(), this.projectedFields);
    }

    public PartitionReader<InternalRow> createReader(InputPartition partition) {
        RecordReader<RowData> reader;
        TableRead read = this.table.newRead().withProjection(this.projectedFields);
        if (this.predicates.size() > 0) {
            read.withFilter(PredicateBuilder.and(this.predicates));
        }
        try {
            reader = read.createReader(((SparkInputPartition)partition).split());
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
        final RecordReaderIterator<RowData> iterator = new RecordReaderIterator<RowData>(reader);
        final SparkInternalRow row = new SparkInternalRow(this.readRowType());
        return new PartitionReader<InternalRow>(){

            public boolean next() {
                if (iterator.hasNext()) {
                    row.replace((RowData)iterator.next());
                    return true;
                }
                return false;
            }

            public InternalRow get() {
                return row;
            }

            public void close() throws IOException {
                try {
                    iterator.close();
                }
                catch (Exception e) {
                    throw new IOException(e);
                }
            }
        };
    }
}

