/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.types;

import java.util.Arrays;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import javax.annotation.Nullable;
import org.apache.flink.annotation.Internal;
import org.apache.flink.annotation.PublicEvolving;
import org.apache.flink.types.Row;
import org.apache.flink.types.RowKind;
import org.apache.flink.util.StringUtils;

@PublicEvolving
public final class RowUtils {
    public static boolean USE_LEGACY_TO_STRING = false;

    public static boolean compareRows(List<Row> l1, List<Row> l2) {
        return RowUtils.compareRows(l1, l2, false);
    }

    public static boolean compareRows(List<Row> l1, List<Row> l2, boolean ignoreOrder) {
        if (l1 == l2) {
            return true;
        }
        if (l1 == null || l2 == null) {
            return false;
        }
        if (ignoreOrder) {
            return RowUtils.deepEqualsListUnordered(l1, l2);
        }
        return RowUtils.deepEqualsListOrdered(l1, l2);
    }

    @Internal
    public static Row createRowWithNamedPositions(RowKind kind, Object[] fieldByPosition, LinkedHashMap<String, Integer> positionByName) {
        return new Row(kind, fieldByPosition, null, positionByName);
    }

    static boolean deepEqualsRow(RowKind kind1, @Nullable Object[] fieldByPosition1, @Nullable Map<String, Object> fieldByName1, @Nullable LinkedHashMap<String, Integer> positionByName1, RowKind kind2, @Nullable Object[] fieldByPosition2, @Nullable Map<String, Object> fieldByName2, @Nullable LinkedHashMap<String, Integer> positionByName2) {
        if (kind1 != kind2) {
            return false;
        }
        if (fieldByPosition1 != null && fieldByPosition2 != null) {
            return RowUtils.deepEqualsInternal(fieldByPosition1, fieldByPosition2);
        }
        if (fieldByName1 != null && fieldByName2 != null) {
            return RowUtils.deepEqualsInternal(fieldByName1, fieldByName2);
        }
        if (positionByName1 != null && fieldByName2 != null) {
            return RowUtils.deepEqualsNamedRows(fieldByPosition1, positionByName1, fieldByName2);
        }
        if (positionByName2 != null && fieldByName1 != null) {
            return RowUtils.deepEqualsNamedRows(fieldByPosition2, positionByName2, fieldByName1);
        }
        return false;
    }

    static int deepHashCodeRow(RowKind kind, @Nullable Object[] fieldByPosition, @Nullable Map<String, Object> fieldByName) {
        int result = kind.toByteValue();
        result = fieldByPosition != null ? 31 * result + RowUtils.deepHashCodeInternal(fieldByPosition) : 31 * result + RowUtils.deepHashCodeInternal(fieldByName);
        return result;
    }

    static String deepToStringRow(RowKind kind, @Nullable Object[] fieldByPosition, @Nullable Map<String, Object> fieldByName) {
        StringBuilder sb = new StringBuilder();
        if (fieldByPosition != null) {
            if (USE_LEGACY_TO_STRING) {
                RowUtils.deepToStringArrayLegacy(sb, fieldByPosition);
            } else {
                sb.append(kind.shortString());
                RowUtils.deepToStringArray(sb, fieldByPosition);
            }
        } else {
            assert (fieldByName != null);
            sb.append(kind.shortString());
            RowUtils.deepToStringMap(sb, fieldByName);
        }
        return sb.toString();
    }

    private static boolean deepEqualsNamedRows(Object[] fieldByPosition1, LinkedHashMap<String, Integer> positionByName1, Map<String, Object> fieldByName2) {
        for (Map.Entry<String, Object> entry : fieldByName2.entrySet()) {
            Integer pos = positionByName1.get(entry.getKey());
            if (pos == null) {
                return false;
            }
            if (RowUtils.deepEqualsInternal(fieldByPosition1[pos], entry.getValue())) continue;
            return false;
        }
        return true;
    }

    private static boolean deepEqualsInternal(Object o1, Object o2) {
        if (o1 == o2) {
            return true;
        }
        if (o1 == null || o2 == null) {
            return false;
        }
        if (o1 instanceof Object[] && o2 instanceof Object[]) {
            return RowUtils.deepEqualsArray((Object[])o1, (Object[])o2);
        }
        if (o1 instanceof Map && o2 instanceof Map) {
            return RowUtils.deepEqualsMap((Map)o1, (Map)o2);
        }
        if (o1 instanceof List && o2 instanceof List) {
            return RowUtils.deepEqualsListOrdered((List)o1, (List)o2);
        }
        return Objects.deepEquals(o1, o2);
    }

    private static boolean deepEqualsArray(Object[] a1, Object[] a2) {
        if (a1.getClass() != a2.getClass()) {
            return false;
        }
        if (a1.length != a2.length) {
            return false;
        }
        for (int pos = 0; pos < a1.length; ++pos) {
            Object e1 = a1[pos];
            Object e2 = a2[pos];
            if (RowUtils.deepEqualsInternal(e1, e2)) continue;
            return false;
        }
        return true;
    }

    private static <K, V> boolean deepEqualsMap(Map<K, V> m1, Map<?, ?> m2) {
        if (m1.size() != m2.size()) {
            return false;
        }
        try {
            for (Map.Entry<K, V> e : m1.entrySet()) {
                K key = e.getKey();
                V value = e.getValue();
                if (!(value == null ? m2.get(key) != null || !m2.containsKey(key) : !RowUtils.deepEqualsInternal(value, m2.get(key)))) continue;
                return false;
            }
        }
        catch (ClassCastException | NullPointerException unused) {
            return false;
        }
        return true;
    }

    private static <E> boolean deepEqualsListOrdered(List<E> l1, List<?> l2) {
        if (l1.size() != l2.size()) {
            return false;
        }
        Iterator<E> i1 = l1.iterator();
        Iterator<?> i2 = l2.iterator();
        while (i1.hasNext() && i2.hasNext()) {
            Object o2;
            E o1 = i1.next();
            if (RowUtils.deepEqualsInternal(o1, o2 = i2.next())) continue;
            return false;
        }
        return true;
    }

    private static <E> boolean deepEqualsListUnordered(List<E> l1, List<?> l2) {
        LinkedList l2Mutable = new LinkedList(l2);
        for (E e1 : l1) {
            Iterator iterator = l2Mutable.iterator();
            boolean found = false;
            while (iterator.hasNext()) {
                Object e2 = iterator.next();
                if (!RowUtils.deepEqualsInternal(e1, e2)) continue;
                found = true;
                iterator.remove();
                break;
            }
            if (found) continue;
            return false;
        }
        return l2Mutable.size() == 0;
    }

    private static int deepHashCodeInternal(Object o) {
        if (o == null) {
            return 0;
        }
        if (o instanceof Object[]) {
            return RowUtils.deepHashCodeArray((Object[])o);
        }
        if (o instanceof Map) {
            return RowUtils.deepHashCodeMap((Map)o);
        }
        if (o instanceof List) {
            return RowUtils.deepHashCodeList((List)o);
        }
        return Arrays.deepHashCode(new Object[]{o});
    }

    private static int deepHashCodeArray(Object[] a) {
        int result = 1;
        for (Object element : a) {
            result = 31 * result + RowUtils.deepHashCodeInternal(element);
        }
        return result;
    }

    private static int deepHashCodeMap(Map<?, ?> m) {
        int result = 1;
        for (Map.Entry<?, ?> entry : m.entrySet()) {
            result += RowUtils.deepHashCodeInternal(entry.getKey()) ^ RowUtils.deepHashCodeInternal(entry.getValue());
        }
        return result;
    }

    private static int deepHashCodeList(List<?> l) {
        int result = 1;
        for (Object e : l) {
            result = 31 * result + RowUtils.deepHashCodeInternal(e);
        }
        return result;
    }

    private static void deepToStringInternal(StringBuilder sb, Object o) {
        if (o instanceof Object[]) {
            RowUtils.deepToStringArray(sb, (Object[])o);
        } else if (o instanceof Map) {
            RowUtils.deepToStringMap(sb, (Map)o);
        } else if (o instanceof List) {
            RowUtils.deepToStringList(sb, (List)o);
        } else {
            sb.append(StringUtils.arrayAwareToString(o));
        }
    }

    private static void deepToStringArray(StringBuilder sb, Object[] a) {
        sb.append('[');
        boolean isFirst = true;
        for (Object o : a) {
            if (isFirst) {
                isFirst = false;
            } else {
                sb.append(", ");
            }
            RowUtils.deepToStringInternal(sb, o);
        }
        sb.append(']');
    }

    private static void deepToStringArrayLegacy(StringBuilder sb, Object[] a) {
        for (int i = 0; i < a.length; ++i) {
            if (i > 0) {
                sb.append(",");
            }
            sb.append(StringUtils.arrayAwareToString(a[i]));
        }
    }

    private static <K, V> void deepToStringMap(StringBuilder sb, Map<K, V> m) {
        sb.append('{');
        boolean isFirst = true;
        for (Map.Entry<K, V> entry : m.entrySet()) {
            if (isFirst) {
                isFirst = false;
            } else {
                sb.append(", ");
            }
            RowUtils.deepToStringInternal(sb, entry.getKey());
            sb.append('=');
            RowUtils.deepToStringInternal(sb, entry.getValue());
        }
        sb.append('}');
    }

    private static <E> void deepToStringList(StringBuilder sb, List<E> l) {
        sb.append('[');
        boolean isFirst = true;
        for (E element : l) {
            if (isFirst) {
                isFirst = false;
            } else {
                sb.append(", ");
            }
            RowUtils.deepToStringInternal(sb, element);
        }
        sb.append(']');
    }

    private RowUtils() {
    }
}

