/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.api.common.serialization;

import java.io.IOException;
import org.apache.flink.annotation.PublicEvolving;
import org.apache.flink.api.common.functions.InvalidTypesException;
import org.apache.flink.api.common.serialization.DeserializationSchema;
import org.apache.flink.api.common.typeinfo.TypeHint;
import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.api.java.typeutils.TypeExtractor;
import org.apache.flink.util.FlinkRuntimeException;
import org.apache.flink.util.Preconditions;

@PublicEvolving
public abstract class AbstractDeserializationSchema<T>
implements DeserializationSchema<T> {
    private static final long serialVersionUID = 2L;
    private final TypeInformation<T> type;

    protected AbstractDeserializationSchema() {
        try {
            this.type = TypeExtractor.createTypeInfo(AbstractDeserializationSchema.class, this.getClass(), 0, null, null);
        }
        catch (InvalidTypesException e) {
            throw new FlinkRuntimeException("The implementation of AbstractDeserializationSchema is using a generic variable. This is not supported, because due to Java's generic type erasure, it will not be possible to determine the full type at runtime. For generic implementations, please pass the TypeInformation or type class explicitly to the constructor.");
        }
    }

    protected AbstractDeserializationSchema(Class<T> type) {
        Preconditions.checkNotNull(type, "type");
        this.type = TypeInformation.of(type);
    }

    protected AbstractDeserializationSchema(TypeHint<T> typeHint) {
        Preconditions.checkNotNull(typeHint, "typeHint");
        this.type = typeHint.getTypeInfo();
    }

    protected AbstractDeserializationSchema(TypeInformation<T> typeInfo) {
        this.type = Preconditions.checkNotNull(typeInfo, "typeInfo");
    }

    @Override
    public abstract T deserialize(byte[] var1) throws IOException;

    @Override
    public boolean isEndOfStream(T nextElement) {
        return false;
    }

    @Override
    public TypeInformation<T> getProducedType() {
        return this.type;
    }
}

