/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.operations.utils;

import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.flink.annotation.Internal;
import org.apache.flink.table.expressions.ApiExpressionUtils;
import org.apache.flink.table.expressions.CallExpression;
import org.apache.flink.table.expressions.Expression;
import org.apache.flink.table.expressions.ExpressionUtils;
import org.apache.flink.table.expressions.FieldReferenceExpression;
import org.apache.flink.table.expressions.LocalReferenceExpression;
import org.apache.flink.table.expressions.LookupCallExpression;
import org.apache.flink.table.expressions.ResolvedExpression;
import org.apache.flink.table.expressions.TableReferenceExpression;
import org.apache.flink.table.expressions.UnresolvedCallExpression;
import org.apache.flink.table.expressions.utils.ApiExpressionDefaultVisitor;
import org.apache.flink.table.functions.BuiltInFunctionDefinitions;
import org.apache.flink.table.functions.FunctionDefinition;
import org.apache.flink.table.functions.FunctionKind;

@Internal
public class OperationExpressionsUtils {
    private static final ExtractNameVisitor extractNameVisitor = new ExtractNameVisitor();

    public static CategorizedExpressions extractAggregationsAndProperties(List<Expression> expressions) {
        AggregationAndPropertiesSplitter splitter = new AggregationAndPropertiesSplitter();
        expressions.forEach(expr -> expr.accept(splitter));
        List<Expression> projections = expressions.stream().map(expr -> expr.accept(new AggregationAndPropertiesReplacer(splitter.aggregates, splitter.properties))).collect(Collectors.toList());
        List<Expression> aggregates = OperationExpressionsUtils.nameExpressions(splitter.aggregates);
        List<Expression> properties = OperationExpressionsUtils.nameExpressions(splitter.properties);
        return new CategorizedExpressions(projections, aggregates, properties);
    }

    private static List<Expression> nameExpressions(Map<Expression, String> expressions) {
        return expressions.entrySet().stream().map(entry -> ApiExpressionUtils.unresolvedCall((FunctionDefinition)BuiltInFunctionDefinitions.AS, (Expression)entry.getKey(), ApiExpressionUtils.valueLiteral(entry.getValue()))).collect(Collectors.toList());
    }

    public static List<Optional<String>> extractNames(List<ResolvedExpression> expressions) {
        return expressions.stream().map(OperationExpressionsUtils::extractName).collect(Collectors.toList());
    }

    public static Optional<String> extractName(Expression expression) {
        return expression.accept(extractNameVisitor);
    }

    private OperationExpressionsUtils() {
    }

    private static class ExtractNameVisitor
    extends ApiExpressionDefaultVisitor<Optional<String>> {
        private ExtractNameVisitor() {
        }

        @Override
        public Optional<String> visit(LookupCallExpression lookupCall) {
            throw new IllegalStateException("All lookup calls should be resolved by now.");
        }

        @Override
        public Optional<String> visit(UnresolvedCallExpression unresolvedCall) {
            if (unresolvedCall.getFunctionDefinition() == BuiltInFunctionDefinitions.AS) {
                return ExpressionUtils.extractValue(unresolvedCall.getChildren().get(1), String.class);
            }
            return Optional.empty();
        }

        @Override
        public Optional<String> visit(CallExpression call) {
            if (call.getFunctionDefinition() == BuiltInFunctionDefinitions.AS) {
                return ExpressionUtils.extractValue(call.getChildren().get(1), String.class);
            }
            return Optional.empty();
        }

        @Override
        public Optional<String> visit(LocalReferenceExpression localReference) {
            return Optional.of(localReference.getName());
        }

        @Override
        public Optional<String> visit(TableReferenceExpression tableReference) {
            return Optional.of(tableReference.getName());
        }

        @Override
        public Optional<String> visit(FieldReferenceExpression fieldReference) {
            return Optional.of(fieldReference.getName());
        }

        @Override
        protected Optional<String> defaultMethod(Expression expression) {
            return Optional.empty();
        }
    }

    private static class AggregationAndPropertiesReplacer
    extends ApiExpressionDefaultVisitor<Expression> {
        private final Map<Expression, String> aggregates;
        private final Map<Expression, String> properties;

        private AggregationAndPropertiesReplacer(Map<Expression, String> aggregates, Map<Expression, String> properties) {
            this.aggregates = aggregates;
            this.properties = properties;
        }

        @Override
        public Expression visit(LookupCallExpression unresolvedCall) {
            throw new IllegalStateException("All lookup calls should be resolved by now. Got: " + unresolvedCall);
        }

        @Override
        public Expression visit(CallExpression call) {
            throw new IllegalStateException("All calls should still be unresolved by now.");
        }

        @Override
        public Expression visit(UnresolvedCallExpression unresolvedCall) {
            if (this.aggregates.get(unresolvedCall) != null) {
                return ApiExpressionUtils.unresolvedRef(this.aggregates.get(unresolvedCall));
            }
            if (this.properties.get(unresolvedCall) != null) {
                return ApiExpressionUtils.unresolvedRef(this.properties.get(unresolvedCall));
            }
            List<Expression> args = unresolvedCall.getChildren().stream().map(c -> c.accept(this)).collect(Collectors.toList());
            return unresolvedCall.replaceArgs(args);
        }

        @Override
        protected Expression defaultMethod(Expression expression) {
            return expression;
        }
    }

    private static class AggregationAndPropertiesSplitter
    extends ApiExpressionDefaultVisitor<Void> {
        private int uniqueId = 0;
        private final Map<Expression, String> aggregates = new LinkedHashMap<Expression, String>();
        private final Map<Expression, String> properties = new LinkedHashMap<Expression, String>();

        private AggregationAndPropertiesSplitter() {
        }

        @Override
        public Void visit(LookupCallExpression unresolvedCall) {
            throw new IllegalStateException("All lookup calls should be resolved by now. Got: " + unresolvedCall);
        }

        @Override
        public Void visit(UnresolvedCallExpression unresolvedCall) {
            FunctionDefinition functionDefinition = unresolvedCall.getFunctionDefinition();
            if (ApiExpressionUtils.isFunctionOfKind(unresolvedCall, FunctionKind.AGGREGATE)) {
                this.aggregates.computeIfAbsent(unresolvedCall, expr -> "EXPR$" + this.uniqueId++);
            } else if (BuiltInFunctionDefinitions.WINDOW_PROPERTIES.contains(functionDefinition)) {
                this.properties.computeIfAbsent(unresolvedCall, expr -> "EXPR$" + this.uniqueId++);
            } else {
                unresolvedCall.getChildren().forEach(c -> c.accept(this));
            }
            return null;
        }

        @Override
        protected Void defaultMethod(Expression expression) {
            return null;
        }
    }

    public static class CategorizedExpressions {
        private final List<Expression> projections;
        private final List<Expression> aggregations;
        private final List<Expression> windowProperties;

        CategorizedExpressions(List<Expression> projections, List<Expression> aggregations, List<Expression> windowProperties) {
            this.projections = projections;
            this.aggregations = aggregations;
            this.windowProperties = windowProperties;
        }

        public List<Expression> getProjections() {
            return this.projections;
        }

        public List<Expression> getAggregations() {
            return this.aggregations;
        }

        public List<Expression> getWindowProperties() {
            return this.windowProperties;
        }
    }
}

