/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.deployment;

import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.util.List;
import javax.annotation.Nullable;
import org.apache.flink.api.common.JobID;
import org.apache.flink.runtime.blob.PermanentBlobKey;
import org.apache.flink.runtime.blob.PermanentBlobService;
import org.apache.flink.runtime.checkpoint.JobManagerTaskRestore;
import org.apache.flink.runtime.clusterframework.types.AllocationID;
import org.apache.flink.runtime.deployment.InputGateDeploymentDescriptor;
import org.apache.flink.runtime.deployment.ResultPartitionDeploymentDescriptor;
import org.apache.flink.runtime.executiongraph.ExecutionAttemptID;
import org.apache.flink.runtime.executiongraph.JobInformation;
import org.apache.flink.runtime.executiongraph.TaskInformation;
import org.apache.flink.util.FileUtils;
import org.apache.flink.util.Preconditions;
import org.apache.flink.util.SerializedValue;

public final class TaskDeploymentDescriptor
implements Serializable {
    private static final long serialVersionUID = -3233562176034358530L;
    private MaybeOffloaded<JobInformation> serializedJobInformation;
    private MaybeOffloaded<TaskInformation> serializedTaskInformation;
    private final JobID jobId;
    private final ExecutionAttemptID executionId;
    private final AllocationID allocationId;
    private final List<ResultPartitionDeploymentDescriptor> producedPartitions;
    private final List<InputGateDeploymentDescriptor> inputGates;
    @Nullable
    private final JobManagerTaskRestore taskRestore;

    public TaskDeploymentDescriptor(JobID jobId, MaybeOffloaded<JobInformation> serializedJobInformation, MaybeOffloaded<TaskInformation> serializedTaskInformation, ExecutionAttemptID executionAttemptId, AllocationID allocationId, @Nullable JobManagerTaskRestore taskRestore, List<ResultPartitionDeploymentDescriptor> resultPartitionDeploymentDescriptors, List<InputGateDeploymentDescriptor> inputGateDeploymentDescriptors) {
        this.jobId = Preconditions.checkNotNull(jobId);
        this.serializedJobInformation = Preconditions.checkNotNull(serializedJobInformation);
        this.serializedTaskInformation = Preconditions.checkNotNull(serializedTaskInformation);
        this.executionId = Preconditions.checkNotNull(executionAttemptId);
        this.allocationId = Preconditions.checkNotNull(allocationId);
        this.taskRestore = taskRestore;
        this.producedPartitions = Preconditions.checkNotNull(resultPartitionDeploymentDescriptors);
        this.inputGates = Preconditions.checkNotNull(inputGateDeploymentDescriptors);
    }

    public SerializedValue<JobInformation> getSerializedJobInformation() {
        if (this.serializedJobInformation instanceof NonOffloaded) {
            NonOffloaded jobInformation = (NonOffloaded)this.serializedJobInformation;
            return jobInformation.serializedValue;
        }
        throw new IllegalStateException("Trying to work with offloaded serialized job information.");
    }

    public SerializedValue<TaskInformation> getSerializedTaskInformation() {
        if (this.serializedTaskInformation instanceof NonOffloaded) {
            NonOffloaded taskInformation = (NonOffloaded)this.serializedTaskInformation;
            return taskInformation.serializedValue;
        }
        throw new IllegalStateException("Trying to work with offloaded serialized job information.");
    }

    public JobID getJobId() {
        return this.jobId;
    }

    public ExecutionAttemptID getExecutionAttemptId() {
        return this.executionId;
    }

    public int getSubtaskIndex() {
        return this.executionId.getSubtaskIndex();
    }

    public int getAttemptNumber() {
        return this.executionId.getAttemptNumber();
    }

    public List<ResultPartitionDeploymentDescriptor> getProducedPartitions() {
        return this.producedPartitions;
    }

    public List<InputGateDeploymentDescriptor> getInputGates() {
        return this.inputGates;
    }

    @Nullable
    public JobManagerTaskRestore getTaskRestore() {
        return this.taskRestore;
    }

    public AllocationID getAllocationId() {
        return this.allocationId;
    }

    public void loadBigData(@Nullable PermanentBlobService blobService) throws IOException, ClassNotFoundException {
        SerializedValue serializedValue;
        File dataFile;
        if (this.serializedJobInformation instanceof Offloaded) {
            PermanentBlobKey jobInfoKey = ((Offloaded)this.serializedJobInformation).serializedValueKey;
            Preconditions.checkNotNull(blobService);
            dataFile = blobService.getFile(this.jobId, jobInfoKey);
            serializedValue = SerializedValue.fromBytes(FileUtils.readAllBytes(dataFile.toPath()));
            this.serializedJobInformation = new NonOffloaded<JobInformation>(serializedValue);
        }
        if (this.serializedTaskInformation instanceof Offloaded) {
            PermanentBlobKey taskInfoKey = ((Offloaded)this.serializedTaskInformation).serializedValueKey;
            Preconditions.checkNotNull(blobService);
            dataFile = blobService.getFile(this.jobId, taskInfoKey);
            serializedValue = SerializedValue.fromBytes(FileUtils.readAllBytes(dataFile.toPath()));
            this.serializedTaskInformation = new NonOffloaded<TaskInformation>(serializedValue);
        }
        for (InputGateDeploymentDescriptor inputGate : this.inputGates) {
            inputGate.loadBigData(blobService, this.jobId);
        }
        Preconditions.checkNotNull(this.serializedJobInformation);
        Preconditions.checkNotNull(this.serializedTaskInformation);
    }

    public String toString() {
        return String.format("TaskDeploymentDescriptor [execution id: %s, produced partitions: %s, input gates: %s]", this.executionId, TaskDeploymentDescriptor.collectionToString(this.producedPartitions), TaskDeploymentDescriptor.collectionToString(this.inputGates));
    }

    private static String collectionToString(Iterable<?> collection) {
        StringBuilder strBuilder = new StringBuilder();
        strBuilder.append("[");
        for (Object elem : collection) {
            strBuilder.append(elem);
        }
        strBuilder.append("]");
        return strBuilder.toString();
    }

    public static class Offloaded<T>
    extends MaybeOffloaded<T> {
        private static final long serialVersionUID = 4544135485379071679L;
        public PermanentBlobKey serializedValueKey;

        public Offloaded() {
        }

        public Offloaded(PermanentBlobKey serializedValueKey) {
            this.serializedValueKey = Preconditions.checkNotNull(serializedValueKey);
        }
    }

    public static class NonOffloaded<T>
    extends MaybeOffloaded<T> {
        private static final long serialVersionUID = 4246628617754862463L;
        public SerializedValue<T> serializedValue;

        public NonOffloaded() {
        }

        public NonOffloaded(SerializedValue<T> serializedValue) {
            this.serializedValue = Preconditions.checkNotNull(serializedValue);
        }
    }

    public static class MaybeOffloaded<T>
    implements Serializable {
        private static final long serialVersionUID = 5977104446396536907L;
    }
}

