/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.streaming.api.operators;

import java.io.IOException;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.annotation.Nonnull;
import org.apache.flink.annotation.Internal;
import org.apache.flink.api.common.typeutils.BackwardsCompatibleSerializerSnapshot;
import org.apache.flink.api.common.typeutils.TypeSerializer;
import org.apache.flink.api.common.typeutils.TypeSerializerSerializationUtil;
import org.apache.flink.api.common.typeutils.TypeSerializerSnapshot;
import org.apache.flink.api.common.typeutils.base.LongSerializer;
import org.apache.flink.api.java.tuple.Tuple2;
import org.apache.flink.api.java.typeutils.runtime.DataInputViewStream;
import org.apache.flink.core.memory.ByteArrayOutputStreamWithPos;
import org.apache.flink.core.memory.DataInputView;
import org.apache.flink.core.memory.DataOutputView;
import org.apache.flink.streaming.api.operators.InternalTimersSnapshot;
import org.apache.flink.streaming.api.operators.TimerHeapInternalTimer;
import org.apache.flink.util.InstantiationUtil;
import org.apache.flink.util.Preconditions;

@Internal
public class InternalTimersSnapshotReaderWriters {
    public static final int NO_VERSION = Integer.MIN_VALUE;

    public static <K, N> InternalTimersSnapshotWriter getWriterForVersion(int version, InternalTimersSnapshot<K, N> timersSnapshot, TypeSerializer<K> keySerializer, TypeSerializer<N> namespaceSerializer) {
        switch (version) {
            case -2147483648: {
                return new InternalTimersSnapshotWriterPreVersioned<K, N>(timersSnapshot, keySerializer, namespaceSerializer);
            }
            case 1: {
                return new InternalTimersSnapshotWriterV1<K, N>(timersSnapshot, keySerializer, namespaceSerializer);
            }
            case 2: {
                return new InternalTimersSnapshotWriterV2<K, N>(timersSnapshot, keySerializer, namespaceSerializer);
            }
        }
        throw new IllegalStateException("Unrecognized internal timers snapshot writer version: " + version);
    }

    public static <K, N> InternalTimersSnapshotReader<K, N> getReaderForVersion(int version, ClassLoader userCodeClassLoader) {
        switch (version) {
            case -2147483648: {
                return new InternalTimersSnapshotReaderPreVersioned(userCodeClassLoader);
            }
            case 1: {
                return new InternalTimersSnapshotReaderV1(userCodeClassLoader);
            }
            case 2: {
                return new InternalTimersSnapshotReaderV2(userCodeClassLoader);
            }
        }
        throw new IllegalStateException("Unrecognized internal timers snapshot writer version: " + version);
    }

    public static class LegacyTimerSerializer<K, N>
    extends TypeSerializer<TimerHeapInternalTimer<K, N>> {
        private static final long serialVersionUID = 1119562170939152304L;
        @Nonnull
        private final TypeSerializer<K> keySerializer;
        @Nonnull
        private final TypeSerializer<N> namespaceSerializer;

        LegacyTimerSerializer(@Nonnull TypeSerializer<K> keySerializer, @Nonnull TypeSerializer<N> namespaceSerializer) {
            this.keySerializer = keySerializer;
            this.namespaceSerializer = namespaceSerializer;
        }

        @Override
        public boolean isImmutableType() {
            return false;
        }

        @Override
        public TypeSerializer<TimerHeapInternalTimer<K, N>> duplicate() {
            TypeSerializer<K> keySerializerDuplicate = this.keySerializer.duplicate();
            TypeSerializer<N> namespaceSerializerDuplicate = this.namespaceSerializer.duplicate();
            if (keySerializerDuplicate == this.keySerializer && namespaceSerializerDuplicate == this.namespaceSerializer) {
                return this;
            }
            return new LegacyTimerSerializer<K, N>(keySerializerDuplicate, namespaceSerializerDuplicate);
        }

        @Override
        public TimerHeapInternalTimer<K, N> createInstance() {
            throw new UnsupportedOperationException();
        }

        @Override
        public TimerHeapInternalTimer<K, N> copy(TimerHeapInternalTimer<K, N> from) {
            return new TimerHeapInternalTimer<K, N>(from.getTimestamp(), from.getKey(), from.getNamespace());
        }

        @Override
        public TimerHeapInternalTimer<K, N> copy(TimerHeapInternalTimer<K, N> from, TimerHeapInternalTimer<K, N> reuse) {
            return this.copy(from);
        }

        @Override
        public int getLength() {
            return -1;
        }

        @Override
        public void serialize(TimerHeapInternalTimer<K, N> record, DataOutputView target) throws IOException {
            this.keySerializer.serialize(record.getKey(), target);
            this.namespaceSerializer.serialize(record.getNamespace(), target);
            LongSerializer.INSTANCE.serialize(record.getTimestamp(), target);
        }

        @Override
        public TimerHeapInternalTimer<K, N> deserialize(DataInputView source) throws IOException {
            K key = this.keySerializer.deserialize(source);
            N namespace = this.namespaceSerializer.deserialize(source);
            Long timestamp = LongSerializer.INSTANCE.deserialize(source);
            return new TimerHeapInternalTimer<K, N>(timestamp, key, namespace);
        }

        @Override
        public TimerHeapInternalTimer<K, N> deserialize(TimerHeapInternalTimer<K, N> reuse, DataInputView source) throws IOException {
            return this.deserialize(source);
        }

        @Override
        public void copy(DataInputView source, DataOutputView target) throws IOException {
            this.keySerializer.copy(source, target);
            this.namespaceSerializer.copy(source, target);
            LongSerializer.INSTANCE.copy(source, target);
        }

        @Override
        public boolean equals(Object obj) {
            return obj == this || obj != null && obj.getClass() == this.getClass() && this.keySerializer.equals(((LegacyTimerSerializer)obj).keySerializer) && this.namespaceSerializer.equals(((LegacyTimerSerializer)obj).namespaceSerializer);
        }

        @Override
        public int hashCode() {
            return this.getClass().hashCode();
        }

        @Override
        public TypeSerializerSnapshot<TimerHeapInternalTimer<K, N>> snapshotConfiguration() {
            throw new UnsupportedOperationException("This serializer is not registered for managed state.");
        }
    }

    private static class InternalTimersSnapshotReaderV2<K, N>
    extends AbstractInternalTimersSnapshotReader<K, N> {
        public InternalTimersSnapshotReaderV2(ClassLoader userCodeClassLoader) {
            super(userCodeClassLoader);
        }

        @Override
        protected void restoreKeyAndNamespaceSerializers(InternalTimersSnapshot<K, N> restoredTimersSnapshot, DataInputView in) throws IOException {
            restoredTimersSnapshot.setKeySerializerSnapshot(TypeSerializerSnapshot.readVersionedSnapshot(in, this.userCodeClassLoader));
            restoredTimersSnapshot.setNamespaceSerializerSnapshot(TypeSerializerSnapshot.readVersionedSnapshot(in, this.userCodeClassLoader));
        }
    }

    private static class InternalTimersSnapshotReaderV1<K, N>
    extends AbstractInternalTimersSnapshotReader<K, N> {
        public InternalTimersSnapshotReaderV1(ClassLoader userCodeClassLoader) {
            super(userCodeClassLoader);
        }

        @Override
        protected void restoreKeyAndNamespaceSerializers(InternalTimersSnapshot<K, N> restoredTimersSnapshot, DataInputView in) throws IOException {
            List<Tuple2<TypeSerializer<?>, TypeSerializerSnapshot<?>>> serializersAndConfigs = TypeSerializerSerializationUtil.readSerializersAndConfigsWithResilience(in, this.userCodeClassLoader);
            restoredTimersSnapshot.setKeySerializerSnapshot((TypeSerializerSnapshot)serializersAndConfigs.get((int)0).f1);
            restoredTimersSnapshot.setNamespaceSerializerSnapshot((TypeSerializerSnapshot)serializersAndConfigs.get((int)1).f1);
        }
    }

    private static class InternalTimersSnapshotReaderPreVersioned<K, N>
    extends AbstractInternalTimersSnapshotReader<K, N> {
        public InternalTimersSnapshotReaderPreVersioned(ClassLoader userCodeClassLoader) {
            super(userCodeClassLoader);
        }

        @Override
        protected void restoreKeyAndNamespaceSerializers(InternalTimersSnapshot<K, N> restoredTimersSnapshot, DataInputView in) throws IOException {
            DataInputViewStream dis = new DataInputViewStream(in);
            try {
                TypeSerializer keySerializer = (TypeSerializer)InstantiationUtil.deserializeObject(dis, this.userCodeClassLoader, true);
                TypeSerializer namespaceSerializer = (TypeSerializer)InstantiationUtil.deserializeObject(dis, this.userCodeClassLoader, true);
                restoredTimersSnapshot.setKeySerializerSnapshot(new BackwardsCompatibleSerializerSnapshot(keySerializer));
                restoredTimersSnapshot.setNamespaceSerializerSnapshot(new BackwardsCompatibleSerializerSnapshot(namespaceSerializer));
            }
            catch (ClassNotFoundException exception) {
                throw new IOException(exception);
            }
        }
    }

    private static abstract class AbstractInternalTimersSnapshotReader<K, N>
    implements InternalTimersSnapshotReader<K, N> {
        protected final ClassLoader userCodeClassLoader;

        public AbstractInternalTimersSnapshotReader(ClassLoader userCodeClassLoader) {
            this.userCodeClassLoader = Preconditions.checkNotNull(userCodeClassLoader);
        }

        protected abstract void restoreKeyAndNamespaceSerializers(InternalTimersSnapshot<K, N> var1, DataInputView var2) throws IOException;

        @Override
        public final InternalTimersSnapshot<K, N> readTimersSnapshot(DataInputView in) throws IOException {
            InternalTimersSnapshot restoredTimersSnapshot = new InternalTimersSnapshot();
            this.restoreKeyAndNamespaceSerializers(restoredTimersSnapshot, in);
            LegacyTimerSerializer timerSerializer = new LegacyTimerSerializer(restoredTimersSnapshot.getKeySerializerSnapshot().restoreSerializer(), restoredTimersSnapshot.getNamespaceSerializerSnapshot().restoreSerializer());
            int sizeOfEventTimeTimers = in.readInt();
            HashSet restoredEventTimers = new HashSet(sizeOfEventTimeTimers);
            if (sizeOfEventTimeTimers > 0) {
                for (int i = 0; i < sizeOfEventTimeTimers; ++i) {
                    Object timer = timerSerializer.deserialize(in);
                    restoredEventTimers.add(timer);
                }
            }
            restoredTimersSnapshot.setEventTimeTimers(restoredEventTimers);
            int sizeOfProcessingTimeTimers = in.readInt();
            HashSet restoredProcessingTimers = new HashSet(sizeOfProcessingTimeTimers);
            if (sizeOfProcessingTimeTimers > 0) {
                for (int i = 0; i < sizeOfProcessingTimeTimers; ++i) {
                    Object timer = timerSerializer.deserialize(in);
                    restoredProcessingTimers.add(timer);
                }
            }
            restoredTimersSnapshot.setProcessingTimeTimers(restoredProcessingTimers);
            return restoredTimersSnapshot;
        }
    }

    public static interface InternalTimersSnapshotReader<K, N> {
        public InternalTimersSnapshot<K, N> readTimersSnapshot(DataInputView var1) throws IOException;
    }

    private static class InternalTimersSnapshotWriterV2<K, N>
    extends AbstractInternalTimersSnapshotWriter<K, N> {
        public InternalTimersSnapshotWriterV2(InternalTimersSnapshot<K, N> timersSnapshot, TypeSerializer<K> keySerializer, TypeSerializer<N> namespaceSerializer) {
            super(timersSnapshot, keySerializer, namespaceSerializer);
        }

        @Override
        protected void writeKeyAndNamespaceSerializers(DataOutputView out) throws IOException {
            TypeSerializerSnapshot.writeVersionedSnapshot(out, this.timersSnapshot.getKeySerializerSnapshot());
            TypeSerializerSnapshot.writeVersionedSnapshot(out, this.timersSnapshot.getNamespaceSerializerSnapshot());
        }
    }

    private static class InternalTimersSnapshotWriterV1<K, N>
    extends AbstractInternalTimersSnapshotWriter<K, N> {
        public InternalTimersSnapshotWriterV1(InternalTimersSnapshot<K, N> timersSnapshot, TypeSerializer<K> keySerializer, TypeSerializer<N> namespaceSerializer) {
            super(timersSnapshot, keySerializer, namespaceSerializer);
        }

        @Override
        protected void writeKeyAndNamespaceSerializers(DataOutputView out) throws IOException {
            TypeSerializerSerializationUtil.writeSerializersAndConfigsWithResilience(out, Arrays.asList(Tuple2.of(this.keySerializer, this.timersSnapshot.getKeySerializerSnapshot()), Tuple2.of(this.namespaceSerializer, this.timersSnapshot.getNamespaceSerializerSnapshot())));
        }
    }

    private static class InternalTimersSnapshotWriterPreVersioned<K, N>
    extends AbstractInternalTimersSnapshotWriter<K, N> {
        public InternalTimersSnapshotWriterPreVersioned(InternalTimersSnapshot<K, N> timersSnapshot, TypeSerializer<K> keySerializer, TypeSerializer<N> namespaceSerializer) {
            super(timersSnapshot, keySerializer, namespaceSerializer);
        }

        @Override
        protected void writeKeyAndNamespaceSerializers(DataOutputView out) throws IOException {
            try (ByteArrayOutputStreamWithPos stream = new ByteArrayOutputStreamWithPos();){
                InstantiationUtil.serializeObject(stream, this.keySerializer);
                InstantiationUtil.serializeObject(stream, this.namespaceSerializer);
                out.write(stream.getBuf(), 0, stream.getPosition());
            }
        }
    }

    private static abstract class AbstractInternalTimersSnapshotWriter<K, N>
    implements InternalTimersSnapshotWriter {
        protected final InternalTimersSnapshot<K, N> timersSnapshot;
        protected final TypeSerializer<K> keySerializer;
        protected final TypeSerializer<N> namespaceSerializer;

        public AbstractInternalTimersSnapshotWriter(InternalTimersSnapshot<K, N> timersSnapshot, TypeSerializer<K> keySerializer, TypeSerializer<N> namespaceSerializer) {
            this.timersSnapshot = Preconditions.checkNotNull(timersSnapshot);
            this.keySerializer = Preconditions.checkNotNull(keySerializer);
            this.namespaceSerializer = Preconditions.checkNotNull(namespaceSerializer);
        }

        protected abstract void writeKeyAndNamespaceSerializers(DataOutputView var1) throws IOException;

        @Override
        public final void writeTimersSnapshot(DataOutputView out) throws IOException {
            this.writeKeyAndNamespaceSerializers(out);
            LegacyTimerSerializer<K, N> timerSerializer = new LegacyTimerSerializer<K, N>(this.keySerializer, this.namespaceSerializer);
            Set<TimerHeapInternalTimer<K, N>> eventTimers = this.timersSnapshot.getEventTimeTimers();
            if (eventTimers != null) {
                out.writeInt(eventTimers.size());
                for (TimerHeapInternalTimer<K, N> eventTimer : eventTimers) {
                    timerSerializer.serialize(eventTimer, out);
                }
            } else {
                out.writeInt(0);
            }
            Set<TimerHeapInternalTimer<K, N>> processingTimers = this.timersSnapshot.getProcessingTimeTimers();
            if (processingTimers != null) {
                out.writeInt(processingTimers.size());
                for (TimerHeapInternalTimer<K, N> processingTimer : processingTimers) {
                    timerSerializer.serialize(processingTimer, out);
                }
            } else {
                out.writeInt(0);
            }
        }
    }

    public static interface InternalTimersSnapshotWriter {
        public void writeTimersSnapshot(DataOutputView var1) throws IOException;
    }
}

