/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.streaming.runtime.io;

import java.util.concurrent.CompletableFuture;
import org.apache.flink.annotation.Internal;
import org.apache.flink.util.concurrent.FutureUtils;

@Internal
public class MultipleFuturesAvailabilityHelper {
    private final CompletableFuture<?>[] futuresToCombine;
    private volatile CompletableFuture<?> availableFuture = new CompletableFuture();

    public MultipleFuturesAvailabilityHelper(int size) {
        this.futuresToCombine = new CompletableFuture[size];
    }

    public CompletableFuture<?> getAvailableFuture() {
        return this.availableFuture;
    }

    public void resetToUnAvailable() {
        if (this.availableFuture.isDone()) {
            this.availableFuture = new CompletableFuture();
        }
    }

    private void notifyCompletion() {
        this.availableFuture.complete(null);
    }

    public void anyOf(int idx, CompletableFuture<?> availabilityFuture) {
        if (this.futuresToCombine[idx] == null || this.futuresToCombine[idx].isDone()) {
            this.futuresToCombine[idx] = availabilityFuture;
            FutureUtils.assertNoException(availabilityFuture.thenRun(this::notifyCompletion));
        }
    }
}

