/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.runtime.operators.over;

import java.util.List;
import org.apache.flink.table.data.RowData;
import org.apache.flink.table.runtime.generated.GeneratedAggsHandleFunction;
import org.apache.flink.table.runtime.operators.over.AbstractRowTimeUnboundedPrecedingOver;
import org.apache.flink.table.types.logical.LogicalType;
import org.apache.flink.util.Collector;

public class RowTimeRangeUnboundedPrecedingFunction<K>
extends AbstractRowTimeUnboundedPrecedingOver<K> {
    private static final long serialVersionUID = 1L;

    public RowTimeRangeUnboundedPrecedingFunction(long minRetentionTime, long maxRetentionTime, GeneratedAggsHandleFunction genAggsHandler, LogicalType[] accTypes, LogicalType[] inputFieldTypes, int rowTimeIdx) {
        super(minRetentionTime, maxRetentionTime, genAggsHandler, accTypes, inputFieldTypes, rowTimeIdx);
    }

    @Override
    public void processElementsWithSameTimestamp(List<RowData> curRowList, Collector<RowData> out) throws Exception {
        int i;
        for (i = 0; i < curRowList.size(); ++i) {
            RowData curRow = curRowList.get(i);
            this.function.accumulate(curRow);
        }
        RowData aggValue = this.function.getValue();
        for (i = 0; i < curRowList.size(); ++i) {
            RowData curRow = curRowList.get(i);
            this.output.replace(curRow, aggValue);
            out.collect(this.output);
        }
    }
}

