/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.store.spark;

import java.util.ArrayList;
import java.util.List;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.table.store.file.predicate.Predicate;
import org.apache.flink.table.store.spark.SparkFilterConverter;
import org.apache.flink.table.store.spark.SparkScan;
import org.apache.flink.table.store.table.Table;
import org.apache.spark.sql.connector.read.Scan;
import org.apache.spark.sql.connector.read.ScanBuilder;
import org.apache.spark.sql.connector.read.SupportsPushDownFilters;
import org.apache.spark.sql.connector.read.SupportsPushDownRequiredColumns;
import org.apache.spark.sql.sources.Filter;
import org.apache.spark.sql.types.StructType;

public class SparkScanBuilder
implements ScanBuilder,
SupportsPushDownFilters,
SupportsPushDownRequiredColumns {
    private final Table table;
    private final Configuration conf;
    private List<Predicate> predicates = new ArrayList<Predicate>();
    private Filter[] pushedFilters;
    private int[] projectedFields;

    public SparkScanBuilder(Table table, Configuration conf) {
        this.table = table;
        this.conf = conf;
    }

    public Filter[] pushFilters(Filter[] filters) {
        SparkFilterConverter converter = new SparkFilterConverter(this.table.rowType());
        ArrayList<Predicate> predicates = new ArrayList<Predicate>();
        ArrayList<Filter> pushed = new ArrayList<Filter>();
        for (Filter filter : filters) {
            try {
                predicates.add(converter.convert(filter));
                pushed.add(filter);
            }
            catch (UnsupportedOperationException unsupportedOperationException) {
                // empty catch block
            }
        }
        this.predicates = predicates;
        this.pushedFilters = pushed.toArray(new Filter[0]);
        return filters;
    }

    public Filter[] pushedFilters() {
        return this.pushedFilters;
    }

    public void pruneColumns(StructType requiredSchema) {
        String[] pruneFields = requiredSchema.fieldNames();
        List<String> fieldNames = this.table.rowType().getFieldNames();
        int[] projected = new int[pruneFields.length];
        for (int i = 0; i < projected.length; ++i) {
            projected[i] = fieldNames.indexOf(pruneFields[i]);
        }
        this.projectedFields = projected;
    }

    public Scan build() {
        return new SparkScan(this.table, this.predicates, this.projectedFields, this.conf);
    }
}

