/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.store.utils;

import java.util.stream.IntStream;
import org.apache.flink.table.data.RowData;
import org.apache.flink.table.store.utils.RowDataUtils;
import org.apache.flink.table.types.logical.RowType;

public class RowDataToObjectArrayConverter {
    private final RowType rowType;
    private final RowData.FieldGetter[] fieldGetters;

    public RowDataToObjectArrayConverter(RowType rowType) {
        this.rowType = rowType;
        this.fieldGetters = (RowData.FieldGetter[])IntStream.range(0, rowType.getFieldCount()).mapToObj(i -> RowDataUtils.createNullCheckingFieldGetter(rowType.getTypeAt(i), i)).toArray(RowData.FieldGetter[]::new);
    }

    public RowType rowType() {
        return this.rowType;
    }

    public int getArity() {
        return this.fieldGetters.length;
    }

    public Object[] convert(RowData rowData) {
        Object[] result = new Object[this.fieldGetters.length];
        for (int i = 0; i < this.fieldGetters.length; ++i) {
            result[i] = this.fieldGetters[i].getFieldOrNull(rowData);
        }
        return result;
    }
}

