/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.util;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.nio.file.Path;
import java.nio.file.Paths;
import org.apache.flink.annotation.Internal;
import org.apache.flink.util.Preconditions;

@Internal
public class FileLock {
    private static final String TEMP_DIR = System.getProperty("java.io.tmpdir");
    private final File file;
    private FileOutputStream outputStream;
    private java.nio.channels.FileLock lock;

    public FileLock(String fullPath) {
        Preconditions.checkNotNull(fullPath, "fullPath should not be null");
        Path path = Paths.get(fullPath, new String[0]);
        String normalizedFileName = FileLock.normalizeFileName(path.getFileName().toString());
        if (normalizedFileName.isEmpty()) {
            throw new IllegalArgumentException("There are no legal characters in the file name");
        }
        this.file = path.getParent() == null ? new File(TEMP_DIR, normalizedFileName) : new File(path.getParent().toString(), normalizedFileName);
    }

    public FileLock(String parentDir, String fileName) {
        Preconditions.checkNotNull(parentDir, "parentDir should not be null");
        Preconditions.checkNotNull(fileName, "fileName should not be null");
        this.file = new File(parentDir, FileLock.normalizeFileName(fileName));
    }

    public static FileLock inTempFolder(String fileName) {
        return new FileLock(TEMP_DIR, fileName);
    }

    private void init() throws IOException {
        if (!this.file.exists()) {
            this.file.createNewFile();
        }
        this.outputStream = new FileOutputStream(this.file);
    }

    public boolean tryLock() throws IOException {
        if (this.outputStream == null) {
            this.init();
        }
        try {
            this.lock = this.outputStream.getChannel().tryLock();
        }
        catch (Exception e) {
            return false;
        }
        return this.lock != null;
    }

    public void unlock() throws IOException {
        if (this.lock != null && this.lock.channel().isOpen()) {
            this.lock.release();
        }
    }

    public void unlockAndDestroy() throws IOException {
        try {
            this.unlock();
            if (this.lock != null) {
                this.lock.channel().close();
                this.lock = null;
            }
            if (this.outputStream != null) {
                this.outputStream.close();
                this.outputStream = null;
            }
        }
        finally {
            this.file.delete();
        }
    }

    public boolean isValid() {
        if (this.lock != null) {
            return this.lock.isValid();
        }
        return false;
    }

    private static String normalizeFileName(String fileName) {
        return fileName.replaceAll("[^\\w/\\\\]", "");
    }
}

