/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.executiongraph.failover.flip1;

import java.util.Collections;
import java.util.Optional;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.flink.runtime.executiongraph.Execution;
import org.apache.flink.runtime.scheduler.strategy.ExecutionVertexID;
import org.apache.flink.util.Preconditions;

public class FailureHandlingResult {
    private final Set<ExecutionVertexID> verticesToRestart;
    private final long restartDelayMS;
    @Nullable
    private final Execution failedExecution;
    @Nullable
    private final Throwable error;
    private final long timestamp;
    private final boolean globalFailure;

    private FailureHandlingResult(@Nullable Execution failedExecution, @Nullable Throwable cause, long timestamp, @Nullable Set<ExecutionVertexID> verticesToRestart, long restartDelayMS, boolean globalFailure) {
        Preconditions.checkState(restartDelayMS >= 0L);
        this.verticesToRestart = Collections.unmodifiableSet(Preconditions.checkNotNull(verticesToRestart));
        this.restartDelayMS = restartDelayMS;
        this.failedExecution = failedExecution;
        this.error = cause;
        this.timestamp = timestamp;
        this.globalFailure = globalFailure;
    }

    private FailureHandlingResult(@Nullable Execution failedExecution, @Nonnull Throwable error, long timestamp, boolean globalFailure) {
        this.verticesToRestart = null;
        this.restartDelayMS = -1L;
        this.failedExecution = failedExecution;
        this.error = Preconditions.checkNotNull(error);
        this.timestamp = timestamp;
        this.globalFailure = globalFailure;
    }

    public Set<ExecutionVertexID> getVerticesToRestart() {
        if (this.canRestart()) {
            return this.verticesToRestart;
        }
        throw new IllegalStateException("Cannot get vertices to restart when the restarting is suppressed.");
    }

    public long getRestartDelayMS() {
        if (this.canRestart()) {
            return this.restartDelayMS;
        }
        throw new IllegalStateException("Cannot get restart delay when the restarting is suppressed.");
    }

    public Optional<Execution> getFailedExecution() {
        return Optional.ofNullable(this.failedExecution);
    }

    @Nullable
    public Throwable getError() {
        return this.error;
    }

    public long getTimestamp() {
        return this.timestamp;
    }

    public boolean canRestart() {
        return this.verticesToRestart != null;
    }

    public boolean isGlobalFailure() {
        return this.globalFailure;
    }

    public static FailureHandlingResult restartable(@Nullable Execution failedExecution, @Nullable Throwable cause, long timestamp, @Nullable Set<ExecutionVertexID> verticesToRestart, long restartDelayMS, boolean globalFailure) {
        return new FailureHandlingResult(failedExecution, cause, timestamp, verticesToRestart, restartDelayMS, globalFailure);
    }

    public static FailureHandlingResult unrecoverable(@Nullable Execution failedExecution, @Nonnull Throwable error, long timestamp, boolean globalFailure) {
        return new FailureHandlingResult(failedExecution, error, timestamp, globalFailure);
    }
}

