/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.rest.messages;

import java.util.Objects;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.annotation.JsonCreator;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.annotation.JsonProperty;
import org.apache.flink.util.Preconditions;

public class ConfigurationInfoEntry {
    public static final String FIELD_NAME_CONFIG_KEY = "key";
    public static final String FIELD_NAME_CONFIG_VALUE = "value";
    @JsonProperty(value="key")
    private final String key;
    @JsonProperty(value="value")
    private final String value;

    @JsonCreator
    public ConfigurationInfoEntry(@JsonProperty(value="key") String key, @JsonProperty(value="value") String value) {
        this.key = Preconditions.checkNotNull(key);
        this.value = Preconditions.checkNotNull(value);
    }

    public String getKey() {
        return this.key;
    }

    public String getValue() {
        return this.value;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ConfigurationInfoEntry that = (ConfigurationInfoEntry)o;
        return this.key.equals(that.key) && this.value.equals(that.value);
    }

    public int hashCode() {
        return Objects.hash(this.key, this.value);
    }

    public String toString() {
        return "(" + this.key + "," + this.value + ")";
    }
}

