/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.runtime.functions.table.lookup.fullcache;

import java.util.Collection;
import java.util.Collections;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.metrics.Counter;
import org.apache.flink.metrics.SimpleCounter;
import org.apache.flink.metrics.ThreadSafeSimpleCounter;
import org.apache.flink.metrics.groups.CacheMetricGroup;
import org.apache.flink.table.connector.source.lookup.cache.LookupCache;
import org.apache.flink.table.connector.source.lookup.cache.trigger.CacheReloadTrigger;
import org.apache.flink.table.data.RowData;
import org.apache.flink.table.runtime.functions.table.lookup.fullcache.CacheLoader;
import org.apache.flink.table.runtime.functions.table.lookup.fullcache.ReloadTriggerContext;
import org.apache.flink.util.Preconditions;

public class LookupFullCache
implements LookupCache {
    private static final long serialVersionUID = 1L;
    private final CacheLoader cacheLoader;
    private final CacheReloadTrigger reloadTrigger;
    private volatile transient ReloadTriggerContext reloadTriggerContext;
    private volatile transient Throwable reloadFailCause;
    private transient Counter hitCounter;

    public LookupFullCache(CacheLoader cacheLoader, CacheReloadTrigger reloadTrigger) {
        this.cacheLoader = Preconditions.checkNotNull(cacheLoader);
        this.reloadTrigger = Preconditions.checkNotNull(reloadTrigger);
    }

    @Override
    public synchronized void open(CacheMetricGroup metricGroup) {
        if (this.hitCounter == null) {
            this.hitCounter = new ThreadSafeSimpleCounter();
        }
        metricGroup.hitCounter(this.hitCounter);
        metricGroup.missCounter((Counter)new SimpleCounter());
        this.cacheLoader.open(metricGroup);
    }

    public synchronized void open(Configuration parameters) throws Exception {
        if (this.reloadTriggerContext == null) {
            this.cacheLoader.open(parameters);
            this.reloadTriggerContext = new ReloadTriggerContext(this.cacheLoader, th -> {
                if (this.reloadFailCause == null) {
                    this.reloadFailCause = th;
                } else {
                    this.reloadFailCause.addSuppressed((Throwable)th);
                }
            });
            this.reloadTrigger.open(this.reloadTriggerContext);
            this.cacheLoader.awaitFirstLoad();
        }
    }

    @Override
    public Collection<RowData> getIfPresent(RowData key) {
        if (this.reloadFailCause != null) {
            throw new RuntimeException(this.reloadFailCause);
        }
        Collection result = this.cacheLoader.getCache().getOrDefault(key, Collections.emptyList());
        this.hitCounter.inc();
        return result;
    }

    @Override
    public Collection<RowData> put(RowData key, Collection<RowData> value) {
        throw new UnsupportedOperationException("Lookup Full cache doesn't support public 'put' operation from the outside.");
    }

    @Override
    public void invalidate(RowData key) {
        throw new UnsupportedOperationException("Lookup Full cache doesn't support public 'invalidate' operation from the outside.");
    }

    @Override
    public long size() {
        return this.cacheLoader.getCache().size();
    }

    @Override
    public void close() throws Exception {
        this.reloadTrigger.close();
        this.cacheLoader.close();
    }
}

