/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.runtime.operators.aggregate;

import java.util.Map;
import javax.annotation.Nullable;
import org.apache.flink.table.data.RowData;
import org.apache.flink.table.data.util.RowDataUtil;
import org.apache.flink.table.data.utils.JoinedRowData;
import org.apache.flink.table.runtime.context.ExecutionContext;
import org.apache.flink.table.runtime.dataview.PerKeyStateDataViewStore;
import org.apache.flink.table.runtime.generated.AggsHandleFunction;
import org.apache.flink.table.runtime.generated.GeneratedAggsHandleFunction;
import org.apache.flink.table.runtime.operators.bundle.MapBundleFunction;
import org.apache.flink.util.Collector;

public class MiniBatchLocalGroupAggFunction
extends MapBundleFunction<RowData, RowData, RowData, RowData> {
    private static final long serialVersionUID = 5417039295967495506L;
    private final GeneratedAggsHandleFunction genAggsHandler;
    private transient JoinedRowData resultRow = new JoinedRowData();
    private transient AggsHandleFunction function = null;

    public MiniBatchLocalGroupAggFunction(GeneratedAggsHandleFunction genAggsHandler) {
        this.genAggsHandler = genAggsHandler;
    }

    @Override
    public void open(ExecutionContext ctx) throws Exception {
        super.open(ctx);
        this.function = (AggsHandleFunction)this.genAggsHandler.newInstance(ctx.getRuntimeContext().getUserCodeClassLoader());
        this.function.open(new PerKeyStateDataViewStore(ctx.getRuntimeContext()));
        this.resultRow = new JoinedRowData();
    }

    @Override
    public RowData addInput(@Nullable RowData previousAcc, RowData input) throws Exception {
        RowData currentAcc = previousAcc == null ? this.function.createAccumulators() : previousAcc;
        this.function.setAccumulators(currentAcc);
        if (RowDataUtil.isAccumulateMsg(input)) {
            this.function.accumulate(input);
        } else {
            this.function.retract(input);
        }
        return this.function.getAccumulators();
    }

    @Override
    public void finishBundle(Map<RowData, RowData> buffer, Collector<RowData> out) throws Exception {
        for (Map.Entry<RowData, RowData> entry : buffer.entrySet()) {
            RowData currentKey = entry.getKey();
            RowData currentAcc = entry.getValue();
            this.resultRow.replace(currentKey, currentAcc);
            out.collect(this.resultRow);
        }
        buffer.clear();
    }

    @Override
    public void close() throws Exception {
        if (this.function != null) {
            this.function.close();
        }
    }
}

