/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
package javax.enterprise.inject;

/**
 * If injection point is not resolved by the container, it throws
 * unsatisfied exception.
 * 
 * @version $Rev: 906902 $ $Date: 2010-02-05 12:23:22 +0100 (Fri, 05 Feb 2010) $
 */
public class UnsatisfiedResolutionException extends ResolutionException
{
    private static final long serialVersionUID = 5350603312442756709L;

    public UnsatisfiedResolutionException()
    {
        super();
    }

    public UnsatisfiedResolutionException(String message)
    {
        super(message);
    }

    public UnsatisfiedResolutionException(Throwable e)
    {
        super(e);
    }

    public UnsatisfiedResolutionException(String message, Throwable e)
    {
        super(message, e);
    }

}
