/*
 * Decompiled with CFR 0.152.
 */
package org.apache.groovy.parser.antlr4.internal.atnmanager;

import groovyjarjarantlr4.v4.runtime.atn.ATN;
import java.lang.invoke.MethodHandles;
import java.lang.ref.Reference;
import java.lang.ref.ReferenceQueue;
import java.lang.ref.SoftReference;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.groovy.util.SystemUtil;
import org.codehaus.groovy.runtime.DefaultGroovyMethods;

public abstract class AtnManager {
    private static final ReentrantReadWriteLock RRWL = new ReentrantReadWriteLock(true);
    private static final ReentrantReadWriteLock.WriteLock WRITE_LOCK = RRWL.writeLock();
    public static final ReentrantReadWriteLock.ReadLock READ_LOCK = RRWL.readLock();
    private static final String DFA_CACHE_THRESHOLD_OPT = "groovy.antlr4.cache.threshold";
    private static final long DFA_CACHE_THRESHOLD;
    private final ReferenceQueue<AtnWrapper> atnWrapperReferenceQueue = new ReferenceQueue();
    private AtnWrapperSoftReference atnWrapperSoftReference;

    public AtnManager() {
        Thread cleanupThread = new Thread(() -> {
            while (true) {
                try {
                    while (true) {
                        Reference<AtnWrapper> reference;
                        if (!((reference = this.atnWrapperReferenceQueue.remove()) instanceof AtnWrapperSoftReference && this.shouldClearDfaCache() && AtnManager.isSmartCleanupEnabled())) {
                            continue;
                        }
                        AtnWrapperSoftReference atnWrapperSoftReference = (AtnWrapperSoftReference)reference;
                        atnWrapperSoftReference.getAtnManager().getAtnWrapper(false).clearDFA();
                    }
                }
                catch (Throwable t) {
                    Logger logger = Logger.getLogger(MethodHandles.lookup().lookupClass().getName());
                    if (!logger.isLoggable(Level.WARNING)) continue;
                    logger.warning(DefaultGroovyMethods.asString(t));
                    continue;
                }
                break;
            }
        }, "DFA-cache-cleaner[" + this.getClass().getSimpleName() + "]");
        cleanupThread.setDaemon(true);
        cleanupThread.start();
    }

    private static boolean isSmartCleanupEnabled() {
        return 0L == DFA_CACHE_THRESHOLD;
    }

    public ATN getATN() {
        return this.getAtnWrapper().checkAndClear();
    }

    protected abstract AtnWrapper createAtnWrapper();

    protected AtnWrapper getAtnWrapper() {
        return this.getAtnWrapper(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private AtnWrapper getAtnWrapper(boolean useSoftRef) {
        AtnWrapper atnWrapper;
        if (!useSoftRef) {
            return this.createAtnWrapper();
        }
        AtnManager atnManager = this;
        synchronized (atnManager) {
            if (null == this.atnWrapperSoftReference || null == (atnWrapper = (AtnWrapper)this.atnWrapperSoftReference.get())) {
                atnWrapper = this.createAtnWrapper();
                this.atnWrapperSoftReference = new AtnWrapperSoftReference(atnWrapper, this, this.atnWrapperReferenceQueue);
            }
        }
        return atnWrapper;
    }

    protected abstract boolean shouldClearDfaCache();

    static {
        long t = SystemUtil.getLongSafe(DFA_CACHE_THRESHOLD_OPT, 0L);
        if (t < 0L) {
            t = Long.MAX_VALUE;
        }
        DFA_CACHE_THRESHOLD = t;
    }

    protected class AtnWrapper {
        private final ATN atn;
        private final AtomicLong counter = new AtomicLong(0L);

        public AtnWrapper(ATN atn) {
            this.atn = atn;
        }

        public ATN checkAndClear() {
            if (!AtnManager.this.shouldClearDfaCache() || AtnManager.isSmartCleanupEnabled()) {
                return this.atn;
            }
            if (0L != this.counter.incrementAndGet() % DFA_CACHE_THRESHOLD) {
                return this.atn;
            }
            this.clearDFA();
            return this.atn;
        }

        public void clearDFA() {
            WRITE_LOCK.lock();
            try {
                this.atn.clearDFA();
            }
            finally {
                WRITE_LOCK.unlock();
            }
        }
    }

    private static class AtnWrapperSoftReference
    extends SoftReference<AtnWrapper> {
        private final AtnManager atnManager;

        public AtnWrapperSoftReference(AtnWrapper referent, AtnManager atnManager, ReferenceQueue<? super AtnWrapper> q) {
            super(referent, q);
            this.atnManager = atnManager;
        }

        public AtnManager getAtnManager() {
            return this.atnManager;
        }
    }
}

