/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.spanner.connection;

import com.google.api.core.ApiFuture;
import com.google.api.core.ApiFutures;
import com.google.api.gax.grpc.GrpcCallContext;
import com.google.api.gax.longrunning.OperationFuture;
import com.google.api.gax.rpc.ApiCallContext;
import com.google.cloud.spanner.ErrorCode;
import com.google.cloud.spanner.Options;
import com.google.cloud.spanner.SpannerException;
import com.google.cloud.spanner.SpannerExceptionFactory;
import com.google.cloud.spanner.SpannerOptions;
import com.google.cloud.spanner.Statement;
import com.google.cloud.spanner.connection.AbstractStatementParser;
import com.google.cloud.spanner.connection.StatementExecutionStep;
import com.google.cloud.spanner.connection.StatementExecutor;
import com.google.cloud.spanner.connection.UnitOfWork;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.util.concurrent.MoreExecutors;
import io.grpc.Context;
import io.grpc.MethodDescriptor;
import io.grpc.Status;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.concurrent.Callable;
import java.util.concurrent.CancellationException;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executor;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import javax.annotation.Nullable;
import javax.annotation.concurrent.GuardedBy;

abstract class AbstractBaseUnitOfWork
implements UnitOfWork {
    private final StatementExecutor statementExecutor;
    private final StatementExecutor.StatementTimeout statementTimeout;
    protected final String transactionTag;
    protected final Options.RpcPriority rpcPriority;
    @GuardedBy(value="this")
    private volatile Future<?> currentlyRunningStatementFuture = null;

    AbstractBaseUnitOfWork(Builder<?, ?> builder) {
        Preconditions.checkState((((Builder)builder).statementExecutor != null ? 1 : 0) != 0, (Object)"No statement executor specified");
        this.statementExecutor = ((Builder)builder).statementExecutor;
        this.statementTimeout = ((Builder)builder).statementTimeout;
        this.transactionTag = ((Builder)builder).transactionTag;
        this.rpcPriority = ((Builder)builder).rpcPriority;
    }

    StatementExecutor getStatementExecutor() {
        return this.statementExecutor;
    }

    StatementExecutor.StatementTimeout getStatementTimeout() {
        return this.statementTimeout;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void cancel() {
        AbstractBaseUnitOfWork abstractBaseUnitOfWork = this;
        synchronized (abstractBaseUnitOfWork) {
            if (this.currentlyRunningStatementFuture != null && !this.currentlyRunningStatementFuture.isDone() && !this.currentlyRunningStatementFuture.isCancelled()) {
                this.currentlyRunningStatementFuture.cancel(true);
            }
        }
    }

    <T> ApiFuture<T> executeStatementAsync(AbstractStatementParser.ParsedStatement statement, Callable<T> callable, @Nullable MethodDescriptor<?, ?> applyStatementTimeoutToMethod) {
        return this.executeStatementAsync(statement, callable, InterceptorsUsage.INVOKE_INTERCEPTORS, (Collection<MethodDescriptor<?, ?>>)(applyStatementTimeoutToMethod == null ? Collections.emptySet() : ImmutableList.of(applyStatementTimeoutToMethod)));
    }

    <T> ApiFuture<T> executeStatementAsync(AbstractStatementParser.ParsedStatement statement, Callable<T> callable, Collection<MethodDescriptor<?, ?>> applyStatementTimeoutToMethods) {
        return this.executeStatementAsync(statement, callable, InterceptorsUsage.INVOKE_INTERCEPTORS, applyStatementTimeoutToMethods);
    }

    <ResponseT, MetadataT> ResponseT getWithStatementTimeout(OperationFuture<ResponseT, MetadataT> operation, AbstractStatementParser.ParsedStatement statement) {
        Object res;
        try {
            if (this.statementTimeout.hasTimeout()) {
                TimeUnit unit = this.statementTimeout.getAppropriateTimeUnit();
                res = operation.get(this.statementTimeout.getTimeoutValue(unit), unit);
            } else {
                res = operation.get();
            }
        }
        catch (TimeoutException e) {
            throw SpannerExceptionFactory.newSpannerException(ErrorCode.DEADLINE_EXCEEDED, "Statement execution timeout occurred for " + statement.getSqlWithoutComments(), e);
        }
        catch (ExecutionException e) {
            HashSet<Throwable> causes = new HashSet<Throwable>();
            for (Throwable cause = e.getCause(); cause != null && !causes.contains(cause); cause = cause.getCause()) {
                if (cause instanceof SpannerException) {
                    throw (SpannerException)((Object)cause);
                }
                causes.add(cause);
            }
            throw SpannerExceptionFactory.newSpannerException(ErrorCode.fromGrpcStatus(Status.fromThrowable((Throwable)e)), "Statement execution failed for " + statement.getSqlWithoutComments(), e);
        }
        catch (InterruptedException e) {
            throw SpannerExceptionFactory.newSpannerException(ErrorCode.CANCELLED, "Statement execution was interrupted", e);
        }
        catch (CancellationException e) {
            throw SpannerExceptionFactory.newSpannerException(ErrorCode.CANCELLED, "Statement execution was cancelled", e);
        }
        return (ResponseT)res;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    <T> ApiFuture<T> executeStatementAsync(AbstractStatementParser.ParsedStatement statement, Callable<T> callable, InterceptorsUsage interceptorUsage, final Collection<MethodDescriptor<?, ?>> applyStatementTimeoutToMethods) {
        Preconditions.checkNotNull((Object)statement);
        Preconditions.checkNotNull(callable);
        if (interceptorUsage == InterceptorsUsage.INVOKE_INTERCEPTORS) {
            this.statementExecutor.invokeInterceptors(statement, StatementExecutionStep.EXECUTE_STATEMENT, this);
        }
        Context context = Context.current();
        if (this.statementTimeout.hasTimeout() && !applyStatementTimeoutToMethods.isEmpty()) {
            context = context.withValue(SpannerOptions.CALL_CONTEXT_CONFIGURATOR_KEY, (Object)new SpannerOptions.CallContextConfigurator(){

                @Override
                public <ReqT, RespT> ApiCallContext configure(ApiCallContext context, ReqT request, MethodDescriptor<ReqT, RespT> method) {
                    if (AbstractBaseUnitOfWork.this.statementTimeout.hasTimeout() && applyStatementTimeoutToMethods.contains(method)) {
                        return GrpcCallContext.createDefault().withTimeout(AbstractBaseUnitOfWork.this.statementTimeout.asDuration());
                    }
                    return null;
                }
            });
        }
        ApiFuture f = this.statementExecutor.submit(context.wrap(callable));
        SpannerAsyncExecutionException caller = new SpannerAsyncExecutionException(statement.getStatement());
        final ApiFuture future = ApiFutures.catching(f, Throwable.class, input -> {
            input.addSuppressed(caller);
            throw SpannerExceptionFactory.asSpannerException(input);
        }, (Executor)MoreExecutors.directExecutor());
        AbstractBaseUnitOfWork abstractBaseUnitOfWork = this;
        synchronized (abstractBaseUnitOfWork) {
            this.currentlyRunningStatementFuture = future;
        }
        future.addListener(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                2 var1_1 = this;
                synchronized (var1_1) {
                    if (AbstractBaseUnitOfWork.this.currentlyRunningStatementFuture == future) {
                        AbstractBaseUnitOfWork.this.currentlyRunningStatementFuture = null;
                    }
                }
            }
        }, MoreExecutors.directExecutor());
        return future;
    }

    static abstract class Builder<B extends Builder<?, T>, T extends AbstractBaseUnitOfWork> {
        private StatementExecutor statementExecutor;
        private StatementExecutor.StatementTimeout statementTimeout = new StatementExecutor.StatementTimeout();
        private String transactionTag;
        private Options.RpcPriority rpcPriority;

        Builder() {
        }

        B self() {
            return (B)this;
        }

        B withStatementExecutor(StatementExecutor executor) {
            Preconditions.checkNotNull((Object)executor);
            this.statementExecutor = executor;
            return this.self();
        }

        B setStatementTimeout(StatementExecutor.StatementTimeout timeout) {
            Preconditions.checkNotNull((Object)timeout);
            this.statementTimeout = timeout;
            return this.self();
        }

        B setTransactionTag(@Nullable String tag) {
            this.transactionTag = tag;
            return this.self();
        }

        B setRpcPriority(@Nullable Options.RpcPriority rpcPriority) {
            this.rpcPriority = rpcPriority;
            return this.self();
        }

        abstract T build();
    }

    static enum InterceptorsUsage {
        INVOKE_INTERCEPTORS,
        IGNORE_INTERCEPTORS;

    }

    static final class SpannerAsyncExecutionException
    extends RuntimeException {
        final Statement statement;

        SpannerAsyncExecutionException(Statement statement) {
            this.statement = statement;
        }

        @Override
        public String getMessage() {
            return String.format("Execution failed for statement: %s", this.statement.getSql());
        }
    }
}

