/*
 * Decompiled with CFR 0.152.
 */
package org.snmp4j.util;

import java.text.ParseException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class ArgumentParser {
    public static final String[] TYPES = new String[]{"i", "l", "s"};
    public static final int TYPE_INTEGER = 0;
    public static final int TYPE_LONG = 1;
    public static final int TYPE_STRING = 2;
    private Map optionFormat;
    private Map parameterFormat;

    public ArgumentParser(String string, String string2) {
        this.optionFormat = ArgumentParser.parseFormat(string, false);
        this.parameterFormat = ArgumentParser.parseFormat(string2, true);
    }

    public Map getOptionFormat() {
        return this.optionFormat;
    }

    public Map getParameterFormat() {
        return this.parameterFormat;
    }

    protected static Map parseFormat(String string, boolean bl) {
        LinkedHashMap<String, ArgumentFormat> linkedHashMap = new LinkedHashMap<String, ArgumentFormat>();
        ArgumentFormat argumentFormat = null;
        StringTokenizer stringTokenizer = new StringTokenizer(string, " ");
        while (stringTokenizer.hasMoreTokens()) {
            ArgumentFormat argumentFormat2;
            String string2 = stringTokenizer.nextToken();
            if ("..".equals(string2)) {
                if (argumentFormat != null) {
                    argumentFormat.vararg = true;
                    break;
                }
                throw new IllegalArgumentException("'..' without parameter definition");
            }
            argumentFormat = argumentFormat2 = new ArgumentFormat();
            argumentFormat2.parameter = bl;
            argumentFormat2.mandatory = string2.charAt(0) != '+';
            string2 = string2.substring(1);
            if (string2.endsWith("]")) {
                argumentFormat2.option = string2.substring(0, string2.indexOf(91));
                string2 = string2.substring(argumentFormat2.option.length() + 1, string2.length() - 1);
                StringTokenizer stringTokenizer2 = new StringTokenizer(string2, ",");
                ArrayList<ArgumentParameter> arrayList = new ArrayList<ArgumentParameter>();
                int n = 1;
                while (stringTokenizer2.hasMoreTokens()) {
                    int n2;
                    String string3 = stringTokenizer2.nextToken();
                    ArgumentParameter argumentParameter = new ArgumentParameter();
                    argumentParameter.name = "" + n;
                    if (string3.endsWith(">")) {
                        n2 = string3.indexOf(60);
                        argumentParameter.pattern = Pattern.compile(string3.substring(n2 + 1, string3.length() - 1));
                        string2 = string2.substring(0, n2);
                    }
                    if (string3.endsWith("}")) {
                        argumentParameter.type = ArgumentParser.getType(string3.substring(0, string3.indexOf("{")));
                        string3 = string3.substring(string3.indexOf(123) + 1, string3.length() - 1);
                        n2 = string2.indexOf(61);
                        if (n2 >= 0) {
                            argumentParameter.defaultValue = string3.substring(n2 + 1);
                            argumentParameter.name = string2.substring(0, n2);
                        } else {
                            argumentParameter.name = string3.substring(string3.indexOf("{") + 1, string3.length() - 1);
                        }
                    } else {
                        argumentParameter.type = ArgumentParser.getType(string3);
                    }
                    arrayList.add(argumentParameter);
                    ++n;
                }
                ArgumentFormat.access$802(argumentFormat2, arrayList.toArray(new ArgumentParameter[arrayList.size()]));
            } else {
                argumentFormat2.option = string2;
                if (argumentFormat2.parameter) {
                    throw new IllegalArgumentException("Parameter " + string2 + " has no type");
                }
            }
            linkedHashMap.put(argumentFormat2.option, argumentFormat2);
        }
        return linkedHashMap;
    }

    private static int getType(String string) {
        return Arrays.binarySearch(TYPES, string);
    }

    public Map parse(String[] stringArray) throws ParseException {
        ArgumentFormat argumentFormat;
        LinkedHashMap linkedHashMap = new LinkedHashMap();
        Iterator iterator = this.parameterFormat.values().iterator();
        ArgumentFormat argumentFormat2 = null;
        for (int i = 0; i < stringArray.length; ++i) {
            if (stringArray[i].charAt(0) == '-') {
                String string = stringArray[i].substring(1);
                argumentFormat = (ArgumentFormat)this.optionFormat.get(string);
                if (argumentFormat == null) {
                    throw new ParseException("Unknown option " + string, i);
                }
            } else {
                ArgumentFormat argumentFormat3 = iterator.hasNext() ? (ArgumentFormat)iterator.next() : (argumentFormat = argumentFormat2 != null && argumentFormat2.isVariableLength() ? argumentFormat2 : null);
                if (argumentFormat == null) {
                    throw new ParseException("Unrecognized parameter at position " + i, i);
                }
            }
            if (argumentFormat.getParameters() != null && argumentFormat.getParameters().length > 0) {
                int n = argumentFormat.isParameter() ? 1 : 0;
                List list = this.parseValues(stringArray, i + (1 - n), argumentFormat);
                i += Math.max(list.size() - n, 0);
                if (argumentFormat.isVariableLength() && linkedHashMap.containsKey(argumentFormat.getOption())) {
                    List list2 = (List)linkedHashMap.get(argumentFormat.getOption());
                    list2.addAll(list);
                } else {
                    this.addValues2Option(argumentFormat.getOption(), list, linkedHashMap);
                }
            } else {
                this.addValues2Option(argumentFormat.getOption(), null, linkedHashMap);
            }
            argumentFormat2 = argumentFormat;
        }
        while (iterator.hasNext()) {
            ArgumentFormat argumentFormat4 = (ArgumentFormat)iterator.next();
            if (!argumentFormat4.isMandatory()) continue;
            throw new ArgumentParseException(-1, null, argumentFormat4, argumentFormat4.getParameters()[0]);
        }
        Iterator iterator2 = this.optionFormat.values().iterator();
        while (iterator2.hasNext()) {
            argumentFormat = (ArgumentFormat)iterator2.next();
            if (!argumentFormat.isMandatory() || linkedHashMap.containsKey(argumentFormat.getOption())) continue;
            ArrayList<String> arrayList = new ArrayList<String>();
            for (int i = 0; i < argumentFormat.getParameters().length; ++i) {
                if (argumentFormat.getParameters()[i].getDefaultValue() == null) continue;
                arrayList.add(argumentFormat.getParameters()[i].getDefaultValue());
            }
            if (arrayList.size() == 0) {
                throw new ArgumentParseException(-1, null, argumentFormat, argumentFormat.getParameters()[0]);
            }
            this.addValues2Option(argumentFormat.getOption(), arrayList, linkedHashMap);
        }
        return linkedHashMap;
    }

    protected void addValues2Option(String string, List list, Map map) {
        List list2 = (List)map.get(string);
        if (list2 != null && list != null) {
            list2.addAll(list);
        } else {
            map.put(string, list);
        }
    }

    protected List parseValues(String[] stringArray, int n, ArgumentFormat argumentFormat) throws ParseException {
        int n2 = argumentFormat.getParameters().length;
        ArrayList<Object> arrayList = new ArrayList<Object>(n2);
        for (int i = 0; i + n < stringArray.length && i < n2; ++i) {
            try {
                arrayList.add(this.parseParameterValue(argumentFormat.getParameters()[i], stringArray[i + n]));
                continue;
            }
            catch (Exception exception) {
                exception.printStackTrace();
                int n3 = i + n;
                throw new ArgumentParseException(n3, stringArray[n3], argumentFormat, argumentFormat.getParameters()[i]);
            }
        }
        return arrayList;
    }

    protected Object parseParameterValue(ArgumentParameter argumentParameter, String string) {
        Matcher matcher;
        if (string.startsWith("'") && string.endsWith("'")) {
            string = string.substring(1, string.length() - 2);
        }
        if (argumentParameter.pattern != null && !(matcher = argumentParameter.pattern.matcher(string)).matches()) {
            throw new RuntimeException("Value '" + string + "' does not match pattern '" + argumentParameter.pattern.pattern());
        }
        switch (argumentParameter.getType()) {
            case 0: {
                return new Integer(string);
            }
            case 1: {
                return new Long(string);
            }
        }
        return string;
    }

    public static void main(String[] stringArray) {
        ArgumentParser argumentParser = new ArgumentParser(System.getProperty("org.snmp4j.OptionFormat", "-o1[i{parameter1}] -o2[s,l]"), System.getProperty("org.snmp4j.ParameterFormat", "-param1[i] -param2[s<(udp|tcp):.*[/[0-9]+]?>] +optParam1[l{=-100}] .."));
        System.out.println("Option format is: " + argumentParser.getOptionFormat());
        System.out.println("Parameter format is: " + argumentParser.getParameterFormat());
        Map map = null;
        try {
            map = argumentParser.parse(stringArray);
            System.out.println(map);
        }
        catch (ParseException parseException) {
            System.err.println("Failed to parse args: " + parseException.getMessage());
            parseException.printStackTrace();
        }
    }

    public static class ArgumentParseException
    extends ParseException {
        private ArgumentParameter parameterFormatDetail;
        private ArgumentFormat parameterFormat;
        private String value;

        public ArgumentParseException(int n, String string, ArgumentFormat argumentFormat, ArgumentParameter argumentParameter) {
            super(string != null ? "Invalid value '" + string + "' at position " + n : "Mandatory parameter -" + argumentFormat.getOption() + argumentParameter.getName() + " not specified", n);
            this.parameterFormat = argumentFormat;
            this.parameterFormatDetail = argumentParameter;
            this.value = string;
        }

        public ArgumentParameter getParameterFormatDetail() {
            return this.parameterFormatDetail;
        }

        public ArgumentFormat getParameterFormat() {
            return this.parameterFormat;
        }

        public String getValue() {
            return this.value;
        }
    }

    public static class ArgumentParameter {
        private String name;
        private int type;
        private Pattern pattern;
        private String defaultValue;

        public String getName() {
            return this.name;
        }

        public String getDefaultValue() {
            return this.defaultValue;
        }

        public int getType() {
            return this.type;
        }

        public String toString() {
            return "ArgumentParameter[name=" + this.name + ",type=" + this.type + ",patttern=" + (this.pattern == null ? null : this.pattern.pattern()) + ",defaultValue=" + this.defaultValue + "]";
        }
    }

    public static class ArgumentFormat {
        private String option;
        private boolean mandatory;
        private boolean parameter;
        private ArgumentParameter[] params;
        private boolean vararg;

        public boolean isMandatory() {
            return this.mandatory;
        }

        public boolean isParameter() {
            return this.parameter;
        }

        public String getOption() {
            return this.option;
        }

        public ArgumentParameter[] getParameters() {
            return this.params;
        }

        public boolean isVariableLength() {
            return this.vararg;
        }

        public String toString() {
            return "ArgumentFormat[option=" + this.option + ",parameter=" + this.parameter + ",vararg=" + this.vararg + ",mandatatory=" + this.mandatory + ",parameters=" + Arrays.asList(this.params) + "]";
        }

        static /* synthetic */ ArgumentParameter[] access$802(ArgumentFormat argumentFormat, ArgumentParameter[] argumentParameterArray) {
            argumentFormat.params = argumentParameterArray;
            return argumentParameterArray;
        }
    }
}

