/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.ui.core.database.dialog;

import java.lang.reflect.InvocationTargetException;
import java.util.List;
import org.apache.hop.core.IProgressMonitor;
import org.apache.hop.core.IRunnableWithProgress;
import org.apache.hop.core.ProgressMonitorAdapter;
import org.apache.hop.core.database.Database;
import org.apache.hop.core.database.DatabaseMeta;
import org.apache.hop.core.exception.HopException;
import org.apache.hop.core.row.IRowMeta;
import org.apache.hop.core.variables.IVariables;
import org.apache.hop.i18n.BaseMessages;
import org.apache.hop.ui.core.dialog.ErrorDialog;
import org.apache.hop.ui.core.dialog.ProgressMonitorDialog;
import org.apache.hop.ui.hopgui.HopGui;
import org.eclipse.swt.widgets.Shell;

public class GetPreviewTableProgressDialog {
    private static final Class<?> PKG = GetPreviewTableProgressDialog.class;
    private final IVariables variables;
    private Shell shell;
    private DatabaseMeta dbMeta;
    private String tableName;
    private int limit;
    private List<Object[]> rows;
    private IRowMeta rowMeta;
    private Database db;

    public GetPreviewTableProgressDialog(Shell shell, IVariables variables, DatabaseMeta dbInfo, String schemaName, String tableName, int limit) {
        this.shell = shell;
        this.variables = variables;
        this.dbMeta = dbInfo;
        this.tableName = dbInfo.getQuotedSchemaTableCombination(variables, schemaName, tableName);
        this.limit = limit;
    }

    public List<Object[]> open() {
        IRunnableWithProgress op = monitor -> {
            this.db = new Database(HopGui.getInstance().getLoggingObject(), this.variables, this.dbMeta);
            try {
                this.db.connect();
                if (this.limit > 0) {
                    this.db.setQueryLimit(this.limit);
                }
                this.rows = this.db.getFirstRows(this.tableName, this.limit, (IProgressMonitor)new ProgressMonitorAdapter(monitor));
                this.rowMeta = this.db.getReturnRowMeta();
            }
            catch (HopException e) {
                throw new InvocationTargetException(e, "Couldn't find any rows because of an error :" + e.toString());
            }
            finally {
                this.db.disconnect();
            }
        };
        try {
            ProgressMonitorDialog pmd = new ProgressMonitorDialog(this.shell);
            Runnable run = () -> {
                IProgressMonitor monitor = pmd.getProgressMonitor();
                while (pmd.getShell() == null || !pmd.getShell().isDisposed() && !monitor.isCanceled()) {
                    try {
                        Thread.sleep(100L);
                    }
                    catch (InterruptedException interruptedException) {}
                }
                if (monitor.isCanceled()) {
                    try {
                        this.db.cancelQuery();
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
            };
            new Thread(run).start();
            pmd.run(true, op);
        }
        catch (InvocationTargetException e) {
            this.showErrorDialog(e);
            return null;
        }
        catch (InterruptedException e) {
            this.showErrorDialog(e);
            return null;
        }
        return this.rows;
    }

    private void showErrorDialog(Exception e) {
        new ErrorDialog(this.shell, BaseMessages.getString(PKG, (String)"GetPreviewTableProgressDialog.Error.Title", (String[])new String[0]), BaseMessages.getString(PKG, (String)"GetPreviewTableProgressDialog.Error.Message", (String[])new String[0]), e);
    }

    public IRowMeta getRowMeta() {
        return this.rowMeta;
    }
}

