/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.workflow.actions.copyfiles;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.vfs2.FileFilter;
import org.apache.commons.vfs2.FileFilterSelector;
import org.apache.commons.vfs2.FileName;
import org.apache.commons.vfs2.FileObject;
import org.apache.commons.vfs2.FileSelectInfo;
import org.apache.commons.vfs2.FileSelector;
import org.apache.commons.vfs2.FileSystemException;
import org.apache.commons.vfs2.FileType;
import org.apache.commons.vfs2.NameScope;
import org.apache.commons.vfs2.filter.NameFileFilter;
import org.apache.hop.core.Const;
import org.apache.hop.core.ICheckResult;
import org.apache.hop.core.ICheckResultSource;
import org.apache.hop.core.Result;
import org.apache.hop.core.ResultFile;
import org.apache.hop.core.RowMetaAndData;
import org.apache.hop.core.annotations.Action;
import org.apache.hop.core.exception.HopException;
import org.apache.hop.core.exception.HopXmlException;
import org.apache.hop.core.util.Utils;
import org.apache.hop.core.variables.IVariables;
import org.apache.hop.core.vfs.HopVfs;
import org.apache.hop.core.xml.XmlHandler;
import org.apache.hop.i18n.BaseMessages;
import org.apache.hop.metadata.api.IHopMetadataProvider;
import org.apache.hop.workflow.WorkflowMeta;
import org.apache.hop.workflow.action.ActionBase;
import org.apache.hop.workflow.action.IAction;
import org.apache.hop.workflow.action.validator.AbstractFileValidator;
import org.apache.hop.workflow.action.validator.ActionValidatorUtils;
import org.apache.hop.workflow.action.validator.AndValidator;
import org.apache.hop.workflow.action.validator.IActionValidator;
import org.apache.hop.workflow.action.validator.ValidatorContext;
import org.apache.hop.workflow.engine.IWorkflowEngine;
import org.w3c.dom.Node;

@Action(id="COPY_FILES", name="i18n::ActionCopyFiles.Name", description="i18n::ActionCopyFiles.Description", image="CopyFiles.svg", categoryDescription="i18n:org.apache.hop.workflow:ActionCategory.Category.FileManagement", keywords={"i18n::ActionCopyFiles.keyword"}, documentationUrl="/workflow/actions/copyfiles.html")
public class ActionCopyFiles
extends ActionBase
implements Cloneable,
IAction {
    private static final Class<?> PKG = ActionCopyFiles.class;
    public static final String SOURCE_CONFIGURATION_NAME = "source_configuration_name";
    public static final String SOURCE_FILE_FOLDER = "source_filefolder";
    public static final String DESTINATION_CONFIGURATION_NAME = "destination_configuration_name";
    public static final String DESTINATION_FILE_FOLDER = "destination_filefolder";
    public static final String LOCAL_SOURCE_FILE = "LOCAL-SOURCE-FILE-";
    public static final String LOCAL_DEST_FILE = "LOCAL-DEST-FILE-";
    public static final String STATIC_SOURCE_FILE = "STATIC-SOURCE-FILE-";
    public static final String STATIC_DEST_FILE = "STATIC-DEST-FILE-";
    public static final String DEST_URL = "EMPTY_DEST_URL-";
    public static final String SOURCE_URL = "EMPTY_SOURCE_URL-";
    public boolean copyEmptyFolders = true;
    public boolean argFromPrevious = false;
    public boolean overwriteFiles = false;
    public boolean includeSubFolders = false;
    public boolean addResultFilenames = false;
    public boolean removeSourceFiles = false;
    public boolean destinationIsAFile = false;
    public boolean createDestinationFolder = false;
    public String[] sourceFileFolder = null;
    public String[] destinationFileFolder = null;
    public String[] wildcard = null;
    private HashSet<String> listFilesRemove = new HashSet();
    private HashSet<String> listAddResult = new HashSet();
    private int nbrFail = 0;
    private Map<String, String> configurationMappings = new HashMap<String, String>();

    public ActionCopyFiles(String n) {
        super(n, "");
    }

    public ActionCopyFiles() {
        this("");
    }

    public void allocate(int nrFields) {
        this.sourceFileFolder = new String[nrFields];
        this.destinationFileFolder = new String[nrFields];
        this.wildcard = new String[nrFields];
    }

    public Object clone() {
        ActionCopyFiles je = (ActionCopyFiles)super.clone();
        if (this.sourceFileFolder != null) {
            int nrFields = this.sourceFileFolder.length;
            je.allocate(nrFields);
            System.arraycopy(this.sourceFileFolder, 0, je.sourceFileFolder, 0, nrFields);
            System.arraycopy(this.destinationFileFolder, 0, je.destinationFileFolder, 0, nrFields);
            System.arraycopy(this.wildcard, 0, je.wildcard, 0, nrFields);
        }
        return je;
    }

    public String getXml() {
        StringBuilder xml = new StringBuilder(300);
        xml.append(super.getXml());
        xml.append("      ").append(XmlHandler.addTagValue((String)"copy_empty_folders", (boolean)this.copyEmptyFolders));
        xml.append("      ").append(XmlHandler.addTagValue((String)"arg_from_previous", (boolean)this.argFromPrevious));
        xml.append("      ").append(XmlHandler.addTagValue((String)"overwrite_files", (boolean)this.overwriteFiles));
        xml.append("      ").append(XmlHandler.addTagValue((String)"include_subfolders", (boolean)this.includeSubFolders));
        xml.append("      ").append(XmlHandler.addTagValue((String)"remove_source_files", (boolean)this.removeSourceFiles));
        xml.append("      ").append(XmlHandler.addTagValue((String)"add_result_filesname", (boolean)this.addResultFilenames));
        xml.append("      ").append(XmlHandler.addTagValue((String)"destination_is_a_file", (boolean)this.destinationIsAFile));
        xml.append("      ").append(XmlHandler.addTagValue((String)"create_destination_folder", (boolean)this.createDestinationFolder));
        xml.append("      <fields>").append(Const.CR);
        String[] vSourceFileFolder = this.preprocessfilefilder(this.sourceFileFolder);
        String[] vDestinationFileFolder = this.preprocessfilefilder(this.destinationFileFolder);
        if (this.sourceFileFolder != null) {
            for (int i = 0; i < this.sourceFileFolder.length; ++i) {
                xml.append("        <field>").append(Const.CR);
                this.saveSource(xml, this.sourceFileFolder[i]);
                this.saveDestination(xml, this.destinationFileFolder[i]);
                xml.append("          ").append(XmlHandler.addTagValue((String)"wildcard", (String)this.wildcard[i]));
                xml.append("        </field>").append(Const.CR);
            }
        }
        xml.append("      </fields>").append(Const.CR);
        return xml.toString();
    }

    public void loadXml(Node entrynode, IHopMetadataProvider metadataProvider, IVariables variables) throws HopXmlException {
        try {
            super.loadXml(entrynode);
            this.copyEmptyFolders = "Y".equalsIgnoreCase(XmlHandler.getTagValue((Node)entrynode, (String)"copy_empty_folders"));
            this.argFromPrevious = "Y".equalsIgnoreCase(XmlHandler.getTagValue((Node)entrynode, (String)"arg_from_previous"));
            this.overwriteFiles = "Y".equalsIgnoreCase(XmlHandler.getTagValue((Node)entrynode, (String)"overwrite_files"));
            this.includeSubFolders = "Y".equalsIgnoreCase(XmlHandler.getTagValue((Node)entrynode, (String)"include_subfolders"));
            this.removeSourceFiles = "Y".equalsIgnoreCase(XmlHandler.getTagValue((Node)entrynode, (String)"remove_source_files"));
            this.addResultFilenames = "Y".equalsIgnoreCase(XmlHandler.getTagValue((Node)entrynode, (String)"add_result_filesname"));
            this.destinationIsAFile = "Y".equalsIgnoreCase(XmlHandler.getTagValue((Node)entrynode, (String)"destination_is_a_file"));
            this.createDestinationFolder = "Y".equalsIgnoreCase(XmlHandler.getTagValue((Node)entrynode, (String)"create_destination_folder"));
            Node fields = XmlHandler.getSubNode((Node)entrynode, (String)"fields");
            int nrFields = XmlHandler.countNodes((Node)fields, (String)"field");
            this.allocate(nrFields);
            for (int i = 0; i < nrFields; ++i) {
                Node fnode = XmlHandler.getSubNodeByNr((Node)fields, (String)"field", (int)i);
                this.sourceFileFolder[i] = this.loadSource(fnode);
                this.destinationFileFolder[i] = this.loadDestination(fnode);
                this.wildcard[i] = XmlHandler.getTagValue((Node)fnode, (String)"wildcard");
            }
        }
        catch (HopXmlException xe) {
            throw new HopXmlException(BaseMessages.getString(PKG, (String)"ActionCopyFiles.Error.Exception.UnableLoadXML", (String[])new String[0]), (Throwable)xe);
        }
    }

    protected String loadSource(Node fnode) {
        String sourceFileFolder = XmlHandler.getTagValue((Node)fnode, (String)SOURCE_FILE_FOLDER);
        String ncName = XmlHandler.getTagValue((Node)fnode, (String)SOURCE_CONFIGURATION_NAME);
        return this.loadURL(sourceFileFolder, ncName, this.getMetadataProvider(), this.configurationMappings);
    }

    protected String loadDestination(Node fnode) {
        String destinationFileFolder = XmlHandler.getTagValue((Node)fnode, (String)DESTINATION_FILE_FOLDER);
        String ncName = XmlHandler.getTagValue((Node)fnode, (String)DESTINATION_CONFIGURATION_NAME);
        return this.loadURL(destinationFileFolder, ncName, this.getMetadataProvider(), this.configurationMappings);
    }

    protected void saveSource(StringBuilder retval, String source) {
        String namedCluster = this.configurationMappings.get(source);
        retval.append("          ").append(XmlHandler.addTagValue((String)SOURCE_FILE_FOLDER, (String)source));
        retval.append("          ").append(XmlHandler.addTagValue((String)SOURCE_CONFIGURATION_NAME, (String)namedCluster));
    }

    protected void saveDestination(StringBuilder retval, String destination) {
        String namedCluster = this.configurationMappings.get(destination);
        retval.append("          ").append(XmlHandler.addTagValue((String)DESTINATION_FILE_FOLDER, (String)destination));
        retval.append("          ").append(XmlHandler.addTagValue((String)DESTINATION_CONFIGURATION_NAME, (String)namedCluster));
    }

    String[] preprocessfilefilder(String[] folders) {
        ArrayList<String> nfolders = new ArrayList<String>();
        if (folders != null) {
            for (int i = 0; i < folders.length; ++i) {
                nfolders.add(folders[i].replace(SOURCE_URL + i + "-", "").replace(DEST_URL + i + "-", ""));
            }
        }
        return nfolders.toArray(new String[nfolders.size()]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Result execute(Result previousResult, int nr) throws HopException {
        Result result = previousResult;
        List rows = result.getRows();
        RowMetaAndData resultRow = null;
        int nbrFail = 0;
        nbrFail = 0;
        if (this.isBasic()) {
            this.logBasic(BaseMessages.getString(PKG, (String)"ActionCopyFiles.Log.Starting", (String[])new String[0]));
        }
        try {
            String[] vSourceFileFolder = this.preprocessfilefilder(this.sourceFileFolder);
            String[] vDestinationFileFolder = this.preprocessfilefilder(this.destinationFileFolder);
            String[] vwildcard = this.wildcard;
            result.setResult(false);
            result.setNrErrors(1L);
            if (this.argFromPrevious && this.isDetailed()) {
                this.logDetailed(BaseMessages.getString(PKG, (String)"ActionCopyFiles.Log.ArgFromPrevious.Found", (String[])new String[]{"" + (rows != null ? rows.size() : 0)}));
            }
            if (this.argFromPrevious && rows != null) {
                for (int iteration = 0; iteration < rows.size() && !this.parentWorkflow.isStopped(); ++iteration) {
                    resultRow = (RowMetaAndData)rows.get(iteration);
                    String vSourceFileFolderPrevious = resultRow.getString(0, null);
                    String vDestinationFileFolderPrevious = resultRow.getString(1, null);
                    String vWildcardPrevious = resultRow.getString(2, null);
                    if (!Utils.isEmpty((CharSequence)vSourceFileFolderPrevious) && !Utils.isEmpty((CharSequence)vDestinationFileFolderPrevious)) {
                        if (this.isDetailed()) {
                            this.logDetailed(BaseMessages.getString(PKG, (String)"ActionCopyFiles.Log.ProcessingRow", (String[])new String[]{HopVfs.getFriendlyURI((String)this.resolve(vSourceFileFolderPrevious)), HopVfs.getFriendlyURI((String)this.resolve(vDestinationFileFolderPrevious)), this.resolve(vWildcardPrevious)}));
                        }
                        if (this.processFileFolder(vSourceFileFolderPrevious, vDestinationFileFolderPrevious, vWildcardPrevious, (IWorkflowEngine<WorkflowMeta>)this.parentWorkflow, result)) continue;
                        ++nbrFail;
                        continue;
                    }
                    if (!this.isDetailed()) continue;
                    this.logDetailed(BaseMessages.getString(PKG, (String)"ActionCopyFiles.Log.IgnoringRow", (String[])new String[]{HopVfs.getFriendlyURI((String)this.resolve(vSourceFileFolder[iteration])), HopVfs.getFriendlyURI((String)this.resolve(vDestinationFileFolder[iteration])), vwildcard[iteration]}));
                }
            } else if (vSourceFileFolder != null && vDestinationFileFolder != null) {
                for (int i = 0; i < vSourceFileFolder.length && !this.parentWorkflow.isStopped(); ++i) {
                    if (!Utils.isEmpty((CharSequence)vSourceFileFolder[i]) && !Utils.isEmpty((CharSequence)vDestinationFileFolder[i])) {
                        if (this.isBasic()) {
                            this.logBasic(BaseMessages.getString(PKG, (String)"ActionCopyFiles.Log.ProcessingRow", (String[])new String[]{HopVfs.getFriendlyURI((String)this.resolve(vSourceFileFolder[i])), HopVfs.getFriendlyURI((String)this.resolve(vDestinationFileFolder[i])), this.resolve(vwildcard[i])}));
                        }
                        if (this.processFileFolder(vSourceFileFolder[i], vDestinationFileFolder[i], vwildcard[i], (IWorkflowEngine<WorkflowMeta>)this.parentWorkflow, result)) continue;
                        ++nbrFail;
                        continue;
                    }
                    if (!this.isDetailed()) continue;
                    this.logDetailed(BaseMessages.getString(PKG, (String)"ActionCopyFiles.Log.IgnoringRow", (String[])new String[]{HopVfs.getFriendlyURI((String)this.resolve(vSourceFileFolder[i])), HopVfs.getFriendlyURI((String)this.resolve(vDestinationFileFolder[i])), vwildcard[i]}));
                }
            }
        }
        finally {
            this.listAddResult = null;
            this.listFilesRemove = null;
        }
        if (nbrFail == 0) {
            result.setResult(true);
            result.setNrErrors(0L);
        } else {
            result.setNrErrors((long)nbrFail);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean processFileFolder(String sourceFileFolderName, String destinationFileFolderName, String wildcard, IWorkflowEngine<WorkflowMeta> parentWorkflow, Result result) {
        boolean entrystatus;
        block48: {
            entrystatus = false;
            FileObject sourceFileFolder = null;
            FileObject destinationFileFolder = null;
            this.listFilesRemove.clear();
            this.listAddResult.clear();
            String realSourceFileFolderName = this.resolve(sourceFileFolderName);
            String realDestinationFileFolderName = this.resolve(destinationFileFolderName);
            String realWildcard = this.resolve(wildcard);
            try {
                sourceFileFolder = HopVfs.getFileObject((String)realSourceFileFolderName);
                destinationFileFolder = HopVfs.getFileObject((String)realDestinationFileFolderName);
                if (sourceFileFolder.exists()) {
                    if (this.createDestinationFolder(destinationFileFolder)) {
                        if (sourceFileFolder.getType().equals((Object)FileType.FOLDER) && this.destinationIsAFile) {
                            this.logError(BaseMessages.getString(PKG, (String)"ActionCopyFiles.Log.CanNotCopyFolderToFile", (String[])new String[]{HopVfs.getFriendlyURI((String)realSourceFileFolderName), HopVfs.getFriendlyURI((String)realDestinationFileFolderName)}));
                            ++this.nbrFail;
                        } else {
                            if (destinationFileFolder.getType().equals((Object)FileType.FOLDER) && sourceFileFolder.getType().equals((Object)FileType.FILE)) {
                                NameFileFilter nameFileFilter = new NameFileFilter(Arrays.asList(sourceFileFolder.getName().getBaseName()));
                                FileFilterSelector fileSelector = new FileFilterSelector((FileFilter)nameFileFilter);
                                destinationFileFolder.copyFrom(sourceFileFolder.getParent(), (FileSelector)fileSelector);
                                if (this.isDetailed()) {
                                    this.logDetailed(BaseMessages.getString(PKG, (String)"ActionCopyFiles.Log.FileCopied", (String[])new String[]{HopVfs.getFriendlyURI((FileObject)sourceFileFolder), HopVfs.getFriendlyURI((FileObject)destinationFileFolder)}));
                                }
                            } else if (sourceFileFolder.getType().equals((Object)FileType.FILE) && this.destinationIsAFile) {
                                destinationFileFolder.copyFrom(sourceFileFolder, (FileSelector)new TextOneToOneFileSelector(destinationFileFolder));
                            } else {
                                if (this.isDetailed()) {
                                    this.logDetailed("  ");
                                    this.logDetailed(BaseMessages.getString(PKG, (String)"ActionCopyFiles.Log.FetchFolder", (String[])new String[]{HopVfs.getFriendlyURI((FileObject)sourceFileFolder)}));
                                }
                                TextFileSelector textFileSelector = new TextFileSelector(sourceFileFolder, destinationFileFolder, realWildcard, parentWorkflow);
                                try {
                                    destinationFileFolder.copyFrom(sourceFileFolder, (FileSelector)textFileSelector);
                                }
                                finally {
                                    textFileSelector.shutdown();
                                }
                            }
                            if (this.removeSourceFiles && !this.listFilesRemove.isEmpty()) {
                                String sourceFilefoldername = sourceFileFolder.toString();
                                int trimPathLength = sourceFilefoldername.length() + 1;
                                Iterator<String> iter = this.listFilesRemove.iterator();
                                while (iter.hasNext() && !parentWorkflow.isStopped()) {
                                    String fileremoventry = iter.next();
                                    FileObject removeFile = null;
                                    if (fileremoventry.startsWith(sourceFilefoldername) && trimPathLength < fileremoventry.length()) {
                                        removeFile = sourceFileFolder.getChild(fileremoventry.substring(trimPathLength));
                                    }
                                    if (removeFile == null) {
                                        removeFile = HopVfs.getFileObject((String)fileremoventry);
                                    }
                                    if (removeFile.getType() != FileType.FILE) continue;
                                    boolean deletefile = removeFile.delete();
                                    this.logBasic(" ------ ");
                                    if (!deletefile) {
                                        this.logError("      " + BaseMessages.getString(PKG, (String)"ActionCopyFiles.Error.Exception.CanRemoveFileFolder", (String[])new String[]{HopVfs.getFriendlyURI((String)fileremoventry)}));
                                        continue;
                                    }
                                    if (!this.isDetailed()) continue;
                                    this.logDetailed("      " + BaseMessages.getString(PKG, (String)"ActionCopyFiles.Log.FileFolderRemoved", (String[])new String[]{HopVfs.getFriendlyURI((String)fileremoventry)}));
                                }
                            }
                            if (this.addResultFilenames && !this.listAddResult.isEmpty()) {
                                String destinationFilefoldername = destinationFileFolder.toString();
                                int trimPathLength = destinationFilefoldername.length() + 1;
                                for (String fileaddentry : this.listAddResult) {
                                    FileObject addFile = null;
                                    if (fileaddentry.startsWith(destinationFilefoldername) && trimPathLength < fileaddentry.length()) {
                                        addFile = destinationFileFolder.getChild(fileaddentry.substring(trimPathLength));
                                    }
                                    if (addFile == null) {
                                        addFile = HopVfs.getFileObject((String)fileaddentry);
                                    }
                                    if (addFile.getType() != FileType.FILE) continue;
                                    ResultFile resultFile = new ResultFile(0, addFile, parentWorkflow.getWorkflowName(), this.toString());
                                    result.getResultFiles().put(resultFile.getFile().toString(), resultFile);
                                    if (!this.isDetailed()) continue;
                                    this.logDetailed(" ------ ");
                                    this.logDetailed("      " + BaseMessages.getString(PKG, (String)"ActionCopyFiles.Log.FileAddedToResultFilesName", (String[])new String[]{HopVfs.getFriendlyURI((String)fileaddentry)}));
                                }
                            }
                        }
                        entrystatus = true;
                        break block48;
                    }
                    this.logError(BaseMessages.getString(PKG, (String)"ActionCopyFiles.Error.DestinationFolderNotFound", (String[])new String[]{HopVfs.getFriendlyURI((String)realDestinationFileFolderName)}));
                    break block48;
                }
                this.logError(BaseMessages.getString(PKG, (String)"ActionCopyFiles.Error.SourceFileNotExists", (String[])new String[]{HopVfs.getFriendlyURI((String)realSourceFileFolderName)}));
            }
            catch (FileSystemException fse) {
                this.logError(BaseMessages.getString(PKG, (String)"ActionCopyFiles.Error.Exception.CopyProcessFileSystemException", (String[])new String[]{fse.getMessage()}), fse);
            }
            catch (Exception e) {
                this.logError(BaseMessages.getString(PKG, (String)"ActionCopyFiles.Error.Exception.CopyProcess", (String[])new String[]{HopVfs.getFriendlyURI((String)realSourceFileFolderName), HopVfs.getFriendlyURI((String)realDestinationFileFolderName), e.getMessage()}), e);
            }
            finally {
                if (sourceFileFolder != null) {
                    try {
                        sourceFileFolder.close();
                        sourceFileFolder = null;
                    }
                    catch (IOException fse) {}
                }
                if (destinationFileFolder != null) {
                    try {
                        destinationFileFolder.close();
                        destinationFileFolder = null;
                    }
                    catch (IOException fse) {}
                }
            }
        }
        return entrystatus;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean createDestinationFolder(FileObject filefolder) {
        FileObject folder = null;
        try {
            folder = this.destinationIsAFile ? filefolder.getParent() : filefolder;
            if (!folder.exists()) {
                if (this.createDestinationFolder) {
                    if (this.isDetailed()) {
                        this.logDetailed("Folder  " + HopVfs.getFriendlyURI((FileObject)folder) + " does not exist !");
                    }
                    folder.createFolder();
                    if (this.isDetailed()) {
                        this.logDetailed("Folder parent was created.");
                    }
                } else {
                    this.logError("Folder  " + HopVfs.getFriendlyURI((FileObject)folder) + " does not exist !");
                    boolean bl = false;
                    return bl;
                }
            }
            boolean bl = true;
            return bl;
        }
        catch (Exception e) {
            this.logError("Couldn't created parent folder " + HopVfs.getFriendlyURI((FileObject)folder), e);
        }
        finally {
            if (folder != null) {
                try {
                    folder.close();
                    folder = null;
                }
                catch (Exception exception) {}
            }
        }
        return false;
    }

    public void check(List<ICheckResult> remarks, WorkflowMeta workflowMeta, IVariables variables, IHopMetadataProvider metadataProvider) {
        boolean res = ActionValidatorUtils.andValidator().validate((ICheckResultSource)this, "arguments", remarks, AndValidator.putValidators((IActionValidator[])new IActionValidator[]{ActionValidatorUtils.notNullValidator()}));
        if (!res) {
            return;
        }
        ValidatorContext ctx = new ValidatorContext();
        AbstractFileValidator.putVariableSpace((ValidatorContext)ctx, (IVariables)this.getVariables());
        AndValidator.putValidators((ValidatorContext)ctx, (IActionValidator[])new IActionValidator[]{ActionValidatorUtils.notNullValidator(), ActionValidatorUtils.fileExistsValidator()});
        for (int i = 0; i < this.sourceFileFolder.length; ++i) {
            ActionValidatorUtils.andValidator().validate((ICheckResultSource)this, "arguments[" + i + "]", remarks, ctx);
        }
    }

    public boolean isEvaluation() {
        return true;
    }

    public String loadURL(String url, String ncName, IHopMetadataProvider metadataProvider, Map<String, String> mappings) {
        if (!Utils.isEmpty((CharSequence)ncName) && !Utils.isEmpty((CharSequence)url)) {
            mappings.put(url, ncName);
        }
        return url;
    }

    public void setConfigurationMappings(Map<String, String> mappings) {
        this.configurationMappings = mappings;
    }

    public String getConfigurationBy(String url) {
        return this.configurationMappings.get(url);
    }

    public String getUrlPath(String incomingURL) {
        String path = null;
        try {
            String noVariablesURL = incomingURL.replaceAll("[${}]", "/");
            FileName fileName = HopVfs.getFileSystemManager().resolveURI(noVariablesURL);
            String root = fileName.getRootURI();
            path = incomingURL.substring(root.length() - 1);
        }
        catch (FileSystemException e) {
            path = null;
        }
        return path;
    }

    public boolean isCopyEmptyFolders() {
        return this.copyEmptyFolders;
    }

    public void setCopyEmptyFolders(boolean copyEmptyFolders) {
        this.copyEmptyFolders = copyEmptyFolders;
    }

    public boolean isArgFromPrevious() {
        return this.argFromPrevious;
    }

    public void setArgFromPrevious(boolean argFromPrevious) {
        this.argFromPrevious = argFromPrevious;
    }

    public boolean isOverwriteFiles() {
        return this.overwriteFiles;
    }

    public void setOverwriteFiles(boolean overwriteFiles) {
        this.overwriteFiles = overwriteFiles;
    }

    public boolean isIncludeSubFolders() {
        return this.includeSubFolders;
    }

    public void setIncludeSubFolders(boolean includeSubFolders) {
        this.includeSubFolders = includeSubFolders;
    }

    public boolean isAddResultFilenames() {
        return this.addResultFilenames;
    }

    public void setAddResultFilenames(boolean addResultFilenames) {
        this.addResultFilenames = addResultFilenames;
    }

    public boolean isRemoveSourceFiles() {
        return this.removeSourceFiles;
    }

    public void setRemoveSourceFiles(boolean removeSourceFiles) {
        this.removeSourceFiles = removeSourceFiles;
    }

    public boolean isDestinationIsAFile() {
        return this.destinationIsAFile;
    }

    public void setDestinationIsAFile(boolean destinationIsAFile) {
        this.destinationIsAFile = destinationIsAFile;
    }

    public boolean isCreateDestinationFolder() {
        return this.createDestinationFolder;
    }

    public void setCreateDestinationFolder(boolean createDestinationFolder) {
        this.createDestinationFolder = createDestinationFolder;
    }

    public String[] getSourceFileFolder() {
        return this.sourceFileFolder;
    }

    public void setSourceFileFolder(String[] sourceFileFolder) {
        this.sourceFileFolder = sourceFileFolder;
    }

    public String[] getDestinationFileFolder() {
        return this.destinationFileFolder;
    }

    public void setDestinationFileFolder(String[] destinationFileFolder) {
        this.destinationFileFolder = destinationFileFolder;
    }

    public String[] getWildcard() {
        return this.wildcard;
    }

    public void setWildcard(String[] wildcard) {
        this.wildcard = wildcard;
    }

    public HashSet<String> getListFilesRemove() {
        return this.listFilesRemove;
    }

    public void setListFilesRemove(HashSet<String> listFilesRemove) {
        this.listFilesRemove = listFilesRemove;
    }

    public HashSet<String> getListAddResult() {
        return this.listAddResult;
    }

    public void setListAddResult(HashSet<String> listAddResult) {
        this.listAddResult = listAddResult;
    }

    public int getNbrFail() {
        return this.nbrFail;
    }

    public void setNbrFail(int nbrFail) {
        this.nbrFail = nbrFail;
    }

    public Map<String, String> getConfigurationMappings() {
        return this.configurationMappings;
    }

    private class TextOneFileSelector
    implements FileSelector {
        String filename = null;
        String folderName = null;
        String destfolder = null;
        private int traverseCount;

        public TextOneFileSelector(String sourcefolderin, String sourcefilenamein, String destfolderin) {
            if (!Utils.isEmpty((CharSequence)sourcefilenamein)) {
                this.filename = sourcefilenamein;
            }
            if (!Utils.isEmpty((CharSequence)sourcefolderin)) {
                this.folderName = sourcefolderin;
            }
            if (!Utils.isEmpty((CharSequence)destfolderin)) {
                this.destfolder = destfolderin;
            }
        }

        public boolean includeFile(FileSelectInfo info) {
            boolean resultat = false;
            String filename = null;
            try {
                if (info.getFile().getType() == FileType.FILE) {
                    if (info.getFile().getName().getBaseName().equals(filename) && info.getFile().getParent().toString().equals(this.folderName)) {
                        if (HopVfs.getFileObject((String)(filename = this.destfolder + Const.FILE_SEPARATOR + filename)).exists()) {
                            if (ActionCopyFiles.this.isDetailed()) {
                                ActionCopyFiles.this.logDetailed("      " + BaseMessages.getString(PKG, (String)"ActionCopyFiles.Log.FileExists", (String[])new String[]{HopVfs.getFriendlyURI((String)filename)}));
                            }
                            if (ActionCopyFiles.this.overwriteFiles) {
                                if (ActionCopyFiles.this.isDetailed()) {
                                    ActionCopyFiles.this.logDetailed("      " + BaseMessages.getString(PKG, (String)"ActionCopyFiles.Log.FileOverwrite", (String[])new String[]{HopVfs.getFriendlyURI((FileObject)info.getFile()), HopVfs.getFriendlyURI((String)filename)}));
                                }
                                resultat = true;
                            }
                        } else {
                            if (ActionCopyFiles.this.isDetailed()) {
                                ActionCopyFiles.this.logDetailed("      " + BaseMessages.getString(PKG, (String)"ActionCopyFiles.Log.FileCopied", (String[])new String[]{HopVfs.getFriendlyURI((FileObject)info.getFile()), HopVfs.getFriendlyURI((String)filename)}));
                            }
                            resultat = true;
                        }
                    }
                    if (resultat && ActionCopyFiles.this.removeSourceFiles) {
                        ActionCopyFiles.this.listFilesRemove.add(info.getFile().toString());
                    }
                    if (resultat && ActionCopyFiles.this.addResultFilenames) {
                        ActionCopyFiles.this.listAddResult.add(HopVfs.getFileObject(filename).toString());
                    }
                }
            }
            catch (Exception e) {
                ActionCopyFiles.this.logError(BaseMessages.getString(PKG, (String)"ActionCopyFiles.Error.Exception.CopyProcess", (String[])new String[]{HopVfs.getFriendlyURI((FileObject)info.getFile()), HopVfs.getFriendlyURI(filename), e.getMessage()}));
                resultat = false;
            }
            return resultat;
        }

        public boolean traverseDescendents(FileSelectInfo info) {
            return this.traverseCount++ == 0 || ActionCopyFiles.this.includeSubFolders;
        }
    }

    private class TextFileSelector
    implements FileSelector {
        String fileWildcard = null;
        String sourceFolder = null;
        String destinationFolder = null;
        IWorkflowEngine<WorkflowMeta> parentjob;
        Pattern pattern;
        private int traverseCount;
        FileObject destinationFolderObject = null;

        private boolean GetFileWildcard(String selectedfile) {
            boolean getIt = true;
            if (this.pattern != null) {
                Matcher matcher = this.pattern.matcher(selectedfile);
                getIt = matcher.matches();
            }
            return getIt;
        }

        public TextFileSelector(FileObject sourcefolderin, FileObject destinationfolderin, String filewildcard, IWorkflowEngine<WorkflowMeta> parentWorkflow) {
            if (sourcefolderin != null) {
                this.sourceFolder = sourcefolderin.toString();
            }
            if (destinationfolderin != null) {
                this.destinationFolderObject = destinationfolderin;
                this.destinationFolder = this.destinationFolderObject.toString();
            }
            if (!Utils.isEmpty((CharSequence)filewildcard)) {
                this.fileWildcard = filewildcard;
                this.pattern = Pattern.compile(this.fileWildcard);
            }
            this.parentjob = parentWorkflow;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean includeFile(FileSelectInfo info) {
            boolean returncode = false;
            Object filename = null;
            String addFileNameString = null;
            try {
                if (!info.getFile().toString().equals(this.sourceFolder) && !this.parentjob.isStopped()) {
                    String shortFilename = info.getFile().getName().getBaseName();
                    if (this.destinationFolderObject == null) {
                        this.destinationFolderObject = HopVfs.getFileObject((String)this.destinationFolder);
                    }
                    String fullName = info.getFile().toString();
                    String baseFolder = info.getBaseFolder().toString();
                    String path = fullName.substring(fullName.indexOf(baseFolder) + baseFolder.length() + 1);
                    filename = this.destinationFolderObject.resolveFile(path, NameScope.DESCENDENT);
                    if (!info.getFile().getParent().equals(info.getBaseFolder())) {
                        if (ActionCopyFiles.this.includeSubFolders) {
                            if (info.getFile().getType() == FileType.FOLDER) {
                                if (ActionCopyFiles.this.includeSubFolders && ActionCopyFiles.this.copyEmptyFolders && Utils.isEmpty((CharSequence)this.fileWildcard)) {
                                    if (filename == null || !filename.exists()) {
                                        if (ActionCopyFiles.this.isDetailed()) {
                                            ActionCopyFiles.this.logDetailed(" ------ ");
                                            ActionCopyFiles.this.logDetailed("      " + BaseMessages.getString(PKG, (String)"ActionCopyFiles.Log.FolderCopied", (String[])new String[]{HopVfs.getFriendlyURI((FileObject)info.getFile()), filename != null ? HopVfs.getFriendlyURI((FileObject)filename) : ""}));
                                        }
                                        returncode = true;
                                    } else {
                                        if (ActionCopyFiles.this.isDetailed()) {
                                            ActionCopyFiles.this.logDetailed(" ------ ");
                                            ActionCopyFiles.this.logDetailed("      " + BaseMessages.getString(PKG, (String)"ActionCopyFiles.Log.FolderExists", (String[])new String[]{HopVfs.getFriendlyURI((FileObject)filename)}));
                                        }
                                        if (ActionCopyFiles.this.overwriteFiles) {
                                            if (ActionCopyFiles.this.isDetailed()) {
                                                ActionCopyFiles.this.logDetailed("      " + BaseMessages.getString(PKG, (String)"ActionCopyFiles.Log.FolderOverwrite", (String[])new String[]{HopVfs.getFriendlyURI((FileObject)info.getFile()), HopVfs.getFriendlyURI((FileObject)filename)}));
                                            }
                                            returncode = true;
                                        }
                                    }
                                }
                            } else if (this.GetFileWildcard(shortFilename)) {
                                if (filename == null || !filename.exists()) {
                                    if (ActionCopyFiles.this.isDetailed()) {
                                        ActionCopyFiles.this.logDetailed(" ------ ");
                                        ActionCopyFiles.this.logDetailed("      " + BaseMessages.getString(PKG, (String)"ActionCopyFiles.Log.FileCopied", (String[])new String[]{HopVfs.getFriendlyURI((FileObject)info.getFile()), filename != null ? HopVfs.getFriendlyURI((FileObject)filename) : ""}));
                                    }
                                    returncode = true;
                                } else {
                                    if (ActionCopyFiles.this.isDetailed()) {
                                        ActionCopyFiles.this.logDetailed(" ------ ");
                                        ActionCopyFiles.this.logDetailed("      " + BaseMessages.getString(PKG, (String)"ActionCopyFiles.Log.FileExists", (String[])new String[]{HopVfs.getFriendlyURI((FileObject)filename)}));
                                    }
                                    if (ActionCopyFiles.this.overwriteFiles) {
                                        if (ActionCopyFiles.this.isDetailed()) {
                                            ActionCopyFiles.this.logDetailed("       " + BaseMessages.getString(PKG, (String)"ActionCopyFiles.Log.FileExists", (String[])new String[]{HopVfs.getFriendlyURI((FileObject)info.getFile()), HopVfs.getFriendlyURI((FileObject)filename)}));
                                        }
                                        returncode = true;
                                    }
                                }
                            }
                        }
                    } else if (info.getFile().getType() == FileType.FOLDER) {
                        if (ActionCopyFiles.this.includeSubFolders && ActionCopyFiles.this.copyEmptyFolders && Utils.isEmpty((CharSequence)this.fileWildcard)) {
                            if (filename == null || !filename.exists()) {
                                if (ActionCopyFiles.this.isDetailed()) {
                                    ActionCopyFiles.this.logDetailed("", new Object[]{" ------ "});
                                    ActionCopyFiles.this.logDetailed("      " + BaseMessages.getString(PKG, (String)"ActionCopyFiles.Log.FolderCopied", (String[])new String[]{HopVfs.getFriendlyURI((FileObject)info.getFile()), filename != null ? HopVfs.getFriendlyURI((FileObject)filename) : ""}));
                                }
                                returncode = true;
                            } else {
                                if (ActionCopyFiles.this.isDetailed()) {
                                    ActionCopyFiles.this.logDetailed(" ------ ");
                                    ActionCopyFiles.this.logDetailed("      " + BaseMessages.getString(PKG, (String)"ActionCopyFiles.Log.FolderExists", (String[])new String[]{HopVfs.getFriendlyURI((FileObject)filename)}));
                                }
                                if (ActionCopyFiles.this.overwriteFiles) {
                                    if (ActionCopyFiles.this.isDetailed()) {
                                        ActionCopyFiles.this.logDetailed("      " + BaseMessages.getString(PKG, (String)"ActionCopyFiles.Log.FolderOverwrite", (String[])new String[]{HopVfs.getFriendlyURI((FileObject)info.getFile()), HopVfs.getFriendlyURI((FileObject)filename)}));
                                    }
                                    returncode = true;
                                }
                            }
                        }
                    } else {
                        filename = HopVfs.getFileObject((String)(this.destinationFolder + Const.FILE_SEPARATOR + shortFilename));
                        if (this.GetFileWildcard(shortFilename)) {
                            if (filename == null || !filename.exists()) {
                                if (ActionCopyFiles.this.isDetailed()) {
                                    ActionCopyFiles.this.logDetailed(" ------ ");
                                    ActionCopyFiles.this.logDetailed("      " + BaseMessages.getString(PKG, (String)"ActionCopyFiles.Log.FileCopied", (String[])new String[]{HopVfs.getFriendlyURI((FileObject)info.getFile()), filename != null ? HopVfs.getFriendlyURI((FileObject)filename) : ""}));
                                }
                                returncode = true;
                            } else {
                                if (ActionCopyFiles.this.isDetailed()) {
                                    ActionCopyFiles.this.logDetailed(" ------ ");
                                    ActionCopyFiles.this.logDetailed("      " + BaseMessages.getString(PKG, (String)"ActionCopyFiles.Log.FileExists", (String[])new String[]{HopVfs.getFriendlyURI((FileObject)filename)}));
                                }
                                if (ActionCopyFiles.this.overwriteFiles) {
                                    if (ActionCopyFiles.this.isDetailed()) {
                                        ActionCopyFiles.this.logDetailed("      " + BaseMessages.getString(PKG, (String)"ActionCopyFiles.Log.FileExistsInfos", (String[])new String[0]), new Object[]{BaseMessages.getString(PKG, (String)"ActionCopyFiles.Log.FileExists", (String[])new String[]{HopVfs.getFriendlyURI((FileObject)info.getFile()), HopVfs.getFriendlyURI((FileObject)filename)})});
                                    }
                                    returncode = true;
                                }
                            }
                        }
                    }
                }
            }
            catch (Exception e) {
                ActionCopyFiles.this.logError(BaseMessages.getString(PKG, (String)"ActionCopyFiles.Error.Exception.CopyProcess", (String[])new String[]{HopVfs.getFriendlyURI((FileObject)info.getFile()), filename != null ? HopVfs.getFriendlyURI((FileObject)filename) : null, e.getMessage()}));
                returncode = false;
            }
            finally {
                if (filename != null) {
                    try {
                        if (returncode && ActionCopyFiles.this.addResultFilenames) {
                            addFileNameString = filename.toString();
                        }
                        filename.close();
                        filename = null;
                    }
                    catch (IOException iOException) {}
                }
            }
            if (returncode && ActionCopyFiles.this.removeSourceFiles) {
                ActionCopyFiles.this.listFilesRemove.add(info.getFile().toString());
            }
            if (returncode && ActionCopyFiles.this.addResultFilenames) {
                ActionCopyFiles.this.listAddResult.add(addFileNameString);
            }
            return returncode;
        }

        public boolean traverseDescendents(FileSelectInfo info) {
            return this.traverseCount++ == 0 || ActionCopyFiles.this.includeSubFolders;
        }

        public void shutdown() {
            if (this.destinationFolderObject != null) {
                try {
                    this.destinationFolderObject.close();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
        }
    }

    private class TextOneToOneFileSelector
    implements FileSelector {
        FileObject destfile = null;

        public TextOneToOneFileSelector(FileObject destinationfile) {
            if (destinationfile != null) {
                this.destfile = destinationfile;
            }
        }

        public boolean includeFile(FileSelectInfo info) {
            boolean resultat = false;
            Object filename = null;
            try {
                if (this.destfile.exists()) {
                    if (ActionCopyFiles.this.isDetailed()) {
                        ActionCopyFiles.this.logDetailed("      " + BaseMessages.getString(PKG, (String)"ActionCopyFiles.Log.FileExists", (String[])new String[]{HopVfs.getFriendlyURI((FileObject)this.destfile)}));
                    }
                    if (ActionCopyFiles.this.overwriteFiles) {
                        if (ActionCopyFiles.this.isDetailed()) {
                            ActionCopyFiles.this.logDetailed("      " + BaseMessages.getString(PKG, (String)"ActionCopyFiles.Log.FileOverwrite", (String[])new String[]{HopVfs.getFriendlyURI((FileObject)this.destfile)}));
                        }
                        resultat = true;
                    }
                } else {
                    if (ActionCopyFiles.this.isDetailed()) {
                        ActionCopyFiles.this.logDetailed("      " + BaseMessages.getString(PKG, (String)"ActionCopyFiles.Log.FileCopied", (String[])new String[]{HopVfs.getFriendlyURI((FileObject)info.getFile()), HopVfs.getFriendlyURI((FileObject)this.destfile)}));
                    }
                    resultat = true;
                }
                if (resultat && ActionCopyFiles.this.removeSourceFiles) {
                    ActionCopyFiles.this.listFilesRemove.add(info.getFile().toString());
                }
                if (resultat && ActionCopyFiles.this.addResultFilenames) {
                    ActionCopyFiles.this.listAddResult.add(this.destfile.toString());
                }
            }
            catch (Exception e) {
                ActionCopyFiles.this.logError(BaseMessages.getString(PKG, (String)"ActionCopyFiles.Error.Exception.CopyProcess", (String[])new String[]{HopVfs.getFriendlyURI((FileObject)info.getFile()), filename, e.getMessage()}));
            }
            return resultat;
        }

        public boolean traverseDescendents(FileSelectInfo info) {
            return false;
        }
    }
}

