/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.oss.driver.api.core;

import com.datastax.oss.driver.api.core.DriverException;
import com.datastax.oss.driver.api.core.ProtocolVersion;
import com.datastax.oss.driver.api.core.cql.ExecutionInfo;
import com.datastax.oss.driver.api.core.metadata.EndPoint;
import com.datastax.oss.driver.shaded.guava.common.collect.ImmutableList;
import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.Nullable;
import java.util.Collections;
import java.util.List;

public class UnsupportedProtocolVersionException
extends DriverException {
    private static final long serialVersionUID = 0L;
    private final EndPoint endPoint;
    private final List<ProtocolVersion> attemptedVersions;

    @NonNull
    public static UnsupportedProtocolVersionException forSingleAttempt(@NonNull EndPoint endPoint, @NonNull ProtocolVersion attemptedVersion) {
        String message = String.format("[%s] Host does not support protocol version %s", endPoint, attemptedVersion);
        return new UnsupportedProtocolVersionException(endPoint, message, Collections.singletonList(attemptedVersion), null);
    }

    @NonNull
    public static UnsupportedProtocolVersionException forNegotiation(@NonNull EndPoint endPoint, @NonNull List<ProtocolVersion> attemptedVersions) {
        String message = String.format("[%s] Protocol negotiation failed: could not find a common version (attempted: %s). Note that the driver does not support Cassandra 2.0 or lower.", endPoint, attemptedVersions);
        return new UnsupportedProtocolVersionException(endPoint, message, (List<ProtocolVersion>)ImmutableList.copyOf(attemptedVersions), null);
    }

    public UnsupportedProtocolVersionException(@Nullable EndPoint endPoint, @NonNull String message, @NonNull List<ProtocolVersion> attemptedVersions) {
        this(endPoint, message, attemptedVersions, null);
    }

    private UnsupportedProtocolVersionException(EndPoint endPoint, String message, List<ProtocolVersion> attemptedVersions, ExecutionInfo executionInfo) {
        super(message, executionInfo, null, true);
        this.endPoint = endPoint;
        this.attemptedVersions = attemptedVersions;
    }

    @Nullable
    public EndPoint getEndPoint() {
        return this.endPoint;
    }

    @NonNull
    public List<ProtocolVersion> getAttemptedVersions() {
        return this.attemptedVersions;
    }

    @Override
    @NonNull
    public DriverException copy() {
        return new UnsupportedProtocolVersionException(this.endPoint, this.getMessage(), this.attemptedVersions, this.getExecutionInfo());
    }
}

