/*
 * Decompiled with CFR 0.152.
 */
package jnr.netdb;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.Reader;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import jnr.netdb.NetDBEntry;

final class NetDBIterator
implements Iterator<NetDBEntry> {
    private final BufferedReader reader;
    private NetDBEntry next = null;

    public NetDBIterator(Reader r) {
        this.reader = r instanceof BufferedReader ? (BufferedReader)r : new BufferedReader(r);
    }

    NetDBEntry readNextEntry() throws IOException {
        String s = null;
        while ((s = this.reader.readLine()) != null) {
            List<String> aliases2;
            String[] fields;
            String[] line = s.split("#", 2);
            if (line.length < 1 || line[0].length() == 0 || (fields = line[0].trim().split("\\s+")).length < 2 || fields[0] == null || fields[1] == null) continue;
            String serviceName = fields[0];
            String data = fields[1];
            if (fields.length > 2) {
                aliases2 = new ArrayList(fields.length - 2);
                for (int i = 2; i < fields.length; ++i) {
                    if (fields[i] == null) continue;
                    aliases2.add(fields[i]);
                }
            } else {
                aliases2 = Collections.emptyList();
            }
            return new NetDBEntry(serviceName, data, aliases2);
        }
        return null;
    }

    @Override
    public boolean hasNext() {
        try {
            return this.next != null || (this.next = this.readNextEntry()) != null;
        }
        catch (IOException ex) {
            return false;
        }
    }

    @Override
    public NetDBEntry next() {
        try {
            NetDBEntry s;
            NetDBEntry netDBEntry = s = this.next != null ? this.next : this.readNextEntry();
            if (s == null) {
                throw new NoSuchElementException("not found");
            }
            this.next = null;
            return s;
        }
        catch (IOException ex) {
            throw new NoSuchElementException(ex.getMessage());
        }
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException("Not supported yet.");
    }
}

