/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.io.gcp.bigquery;

import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.beam.sdk.extensions.gcp.util.GceMetadataUtil;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;

final class BigQueryIOMetadata {
    private @Nullable @UnknownKeyFor @Initialized String beamJobId;
    private static final @UnknownKeyFor @NonNull @Initialized Pattern VALID_CLOUD_LABEL_PATTERN = Pattern.compile("^[a-z0-9\\_\\-]{1,63}$");

    private BigQueryIOMetadata(@Nullable @UnknownKeyFor @Initialized String beamJobId) {
        this.beamJobId = beamJobId;
    }

    public static @UnknownKeyFor @NonNull @Initialized BigQueryIOMetadata create() {
        String dataflowJobId = GceMetadataUtil.fetchDataflowJobId();
        boolean isDataflowRunner = dataflowJobId != null && !dataflowJobId.isEmpty();
        String beamJobId = null;
        if (isDataflowRunner && BigQueryIOMetadata.isValidCloudLabel(dataflowJobId)) {
            beamJobId = dataflowJobId;
        }
        return new BigQueryIOMetadata(beamJobId);
    }

    public @UnknownKeyFor @NonNull @Initialized Map<@UnknownKeyFor @NonNull @Initialized String, @UnknownKeyFor @NonNull @Initialized String> addAdditionalJobLabels(@UnknownKeyFor @NonNull @Initialized Map<@UnknownKeyFor @NonNull @Initialized String, @UnknownKeyFor @NonNull @Initialized String> jobLabels) {
        if (this.beamJobId != null && !jobLabels.containsKey("beam_job_id")) {
            jobLabels.put("beam_job_id", this.beamJobId);
        }
        return jobLabels;
    }

    public @Nullable @UnknownKeyFor @Initialized String getBeamJobId() {
        return this.beamJobId;
    }

    public static @UnknownKeyFor @NonNull @Initialized boolean isValidCloudLabel(@UnknownKeyFor @NonNull @Initialized String value) {
        Matcher m = VALID_CLOUD_LABEL_PATTERN.matcher(value);
        return m.find();
    }
}

