/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.io.gcp.pubsub;

import com.google.api.client.util.Clock;
import com.google.auto.service.AutoService;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Stream;
import org.apache.beam.sdk.annotations.Experimental;
import org.apache.beam.sdk.annotations.Internal;
import org.apache.beam.sdk.io.gcp.pubsub.PubsubClient;
import org.apache.beam.sdk.io.gcp.pubsub.PubsubGrpcClient;
import org.apache.beam.sdk.io.gcp.pubsub.PubsubIO;
import org.apache.beam.sdk.io.gcp.pubsub.PubsubMessage;
import org.apache.beam.sdk.io.gcp.pubsub.PubsubOptions;
import org.apache.beam.sdk.io.gcp.pubsub.PubsubRowToMessage;
import org.apache.beam.sdk.io.gcp.pubsub.PubsubWriteSchemaTransformConfiguration;
import org.apache.beam.sdk.options.PipelineOptions;
import org.apache.beam.sdk.schemas.Schema;
import org.apache.beam.sdk.schemas.io.Providers;
import org.apache.beam.sdk.schemas.io.payloads.PayloadSerializer;
import org.apache.beam.sdk.schemas.io.payloads.PayloadSerializerProvider;
import org.apache.beam.sdk.schemas.io.payloads.PayloadSerializers;
import org.apache.beam.sdk.schemas.transforms.SchemaTransform;
import org.apache.beam.sdk.schemas.transforms.SchemaTransformProvider;
import org.apache.beam.sdk.schemas.transforms.TypedSchemaTransformProvider;
import org.apache.beam.sdk.transforms.DoFn;
import org.apache.beam.sdk.transforms.PTransform;
import org.apache.beam.sdk.transforms.ParDo;
import org.apache.beam.sdk.values.PCollection;
import org.apache.beam.sdk.values.PCollectionRowTuple;
import org.apache.beam.sdk.values.PCollectionTuple;
import org.apache.beam.sdk.values.Row;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.base.Preconditions;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.collect.ImmutableMap;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;
import org.joda.time.Instant;

@Internal
@Experimental(value=Experimental.Kind.SCHEMAS)
@AutoService(value={SchemaTransformProvider.class})
public class PubsubWriteSchemaTransformProvider
extends TypedSchemaTransformProvider<PubsubWriteSchemaTransformConfiguration> {
    private static final @UnknownKeyFor @NonNull @Initialized String IDENTIFIER = "beam:schematransform:org.apache.beam:pubsub_write:v1";
    static final @UnknownKeyFor @NonNull @Initialized String INPUT_TAG = "input";
    static final @UnknownKeyFor @NonNull @Initialized String ERROR_TAG = "error";

    protected @UnknownKeyFor @NonNull @Initialized Class<@UnknownKeyFor @NonNull @Initialized PubsubWriteSchemaTransformConfiguration> configurationClass() {
        return PubsubWriteSchemaTransformConfiguration.class;
    }

    public @UnknownKeyFor @NonNull @Initialized SchemaTransform from(@UnknownKeyFor @NonNull @Initialized PubsubWriteSchemaTransformConfiguration configuration) {
        return new PubsubWriteSchemaTransform(configuration);
    }

    public @UnknownKeyFor @NonNull @Initialized String identifier() {
        return IDENTIFIER;
    }

    public @UnknownKeyFor @NonNull @Initialized List<@UnknownKeyFor @NonNull @Initialized String> inputCollectionNames() {
        return Collections.singletonList(INPUT_TAG);
    }

    public @UnknownKeyFor @NonNull @Initialized List<@UnknownKeyFor @NonNull @Initialized String> outputCollectionNames() {
        return Collections.singletonList(ERROR_TAG);
    }

    private static class ConvertForRowToMessage
    extends DoFn<Row, Row> {
        private final @UnknownKeyFor @NonNull @Initialized Schema targetSchema;
        @javax.annotation.Nullable
        private final @UnknownKeyFor @Nullable @Initialized Clock clock;
        @javax.annotation.Nullable
        private final @UnknownKeyFor @Nullable @Initialized String attributesFieldName;
        @javax.annotation.Nullable
        private final @UnknownKeyFor @Nullable @Initialized String timestampFieldName;
        @javax.annotation.Nullable
        private final @UnknownKeyFor @Nullable @Initialized String payloadFieldName;

        ConvertForRowToMessage(@UnknownKeyFor @NonNull @Initialized Schema targetSchema, @javax.annotation.Nullable @UnknownKeyFor @Nullable @Initialized Clock clock, @javax.annotation.Nullable @UnknownKeyFor @Nullable @Initialized String attributesFieldName, @javax.annotation.Nullable @UnknownKeyFor @Nullable @Initialized String timestampFieldName, @javax.annotation.Nullable @UnknownKeyFor @Nullable @Initialized String payloadFieldName) {
            this.targetSchema = targetSchema;
            this.clock = clock;
            this.attributesFieldName = attributesFieldName;
            this.timestampFieldName = timestampFieldName;
            this.payloadFieldName = payloadFieldName;
        }

        @DoFn.ProcessElement
        public void process(@DoFn.Element @UnknownKeyFor @NonNull @Initialized Row row, // Could not load outer class - annotation placement on inner may be incorrect
        @UnknownKeyFor @NonNull @Initialized DoFn.OutputReceiver<@UnknownKeyFor @NonNull @Initialized Row> receiver) {
            Instant now = Instant.now();
            if (this.clock != null) {
                now = Instant.ofEpochMilli((long)this.clock.currentTimeMillis());
            }
            HashMap<String, Object> values = new HashMap<String, Object>();
            Preconditions.checkState((boolean)this.targetSchema.hasField("$pubsub_attributes"));
            values.put("$pubsub_attributes", ImmutableMap.of());
            Preconditions.checkState((boolean)this.targetSchema.hasField("$pubsub_event_timestamp"));
            values.put("$pubsub_event_timestamp", now);
            for (String fieldName : row.getSchema().getFieldNames()) {
                if (this.targetSchema.hasField(fieldName)) {
                    values.put(fieldName, row.getValue(fieldName));
                }
                if (this.attributesFieldName != null) {
                    values.put("$pubsub_attributes", row.getValue(this.attributesFieldName));
                }
                if (this.timestampFieldName != null) {
                    values.put("$pubsub_event_timestamp", row.getValue(this.timestampFieldName));
                }
                if (this.payloadFieldName == null) continue;
                values.put("$pubsub_payload", row.getValue(this.payloadFieldName));
            }
            receiver.output((Object)Row.withSchema((Schema)this.targetSchema).withFieldValues(values).build());
        }
    }

    static class PubsubWriteSchemaTransform
    extends PTransform<PCollectionRowTuple, PCollectionRowTuple>
    implements SchemaTransform {
        private final @UnknownKeyFor @NonNull @Initialized PubsubWriteSchemaTransformConfiguration configuration;
        private @UnknownKeyFor @NonNull @Initialized PubsubClient.PubsubClientFactory pubsubClientFactory;

        PubsubWriteSchemaTransform(@UnknownKeyFor @NonNull @Initialized PubsubWriteSchemaTransformConfiguration configuration) {
            this.configuration = configuration;
        }

        @UnknownKeyFor @NonNull @Initialized PubsubWriteSchemaTransform withPubsubClientFactory(@UnknownKeyFor @NonNull @Initialized PubsubClient.PubsubClientFactory factory) {
            this.pubsubClientFactory = factory;
            return this;
        }

        public @UnknownKeyFor @NonNull @Initialized PTransform<@UnknownKeyFor @NonNull @Initialized PCollectionRowTuple, @UnknownKeyFor @NonNull @Initialized PCollectionRowTuple> buildTransform() {
            return this;
        }

        public @UnknownKeyFor @NonNull @Initialized PCollectionRowTuple expand(@UnknownKeyFor @NonNull @Initialized PCollectionRowTuple input) {
            if (input.getAll().size() != 1 || !input.has(PubsubWriteSchemaTransformProvider.INPUT_TAG)) {
                throw new IllegalArgumentException(String.format("%s %s input is expected to contain a single %s tagged PCollection<Row>", input.getClass().getSimpleName(), ((Object)((Object)this)).getClass().getSimpleName(), PubsubWriteSchemaTransformProvider.INPUT_TAG));
            }
            PCollection rows = input.get(PubsubWriteSchemaTransformProvider.INPUT_TAG);
            if (rows.getSchema().getFieldCount() == 0) {
                throw new IllegalArgumentException(String.format("empty Schema for %s", PubsubWriteSchemaTransformProvider.INPUT_TAG));
            }
            Schema targetSchema = this.buildTargetSchema(rows.getSchema());
            rows = ((PCollection)rows.apply(ConvertForRowToMessage.class.getSimpleName(), this.convertForRowToMessage(targetSchema))).setRowSchema(targetSchema);
            Schema schema = rows.getSchema();
            Schema serializableSchema = PubsubRowToMessage.removeFields(schema, "$pubsub_attributes", "$pubsub_event_timestamp");
            PubsubRowToMessage.FieldMatcher payloadRowMatcher = PubsubRowToMessage.FieldMatcher.of("$pubsub_payload", Schema.TypeName.ROW);
            if (payloadRowMatcher.match(serializableSchema)) {
                serializableSchema = serializableSchema.getField("$pubsub_payload").getType().getRowSchema();
            }
            this.validateTargetSchemaAgainstPubsubSchema(serializableSchema, input.getPipeline().getOptions());
            PCollectionTuple pct = (PCollectionTuple)rows.apply(PubsubRowToMessage.class.getSimpleName(), (PTransform)this.buildPubsubRowToMessage(serializableSchema));
            PCollection messages = pct.get(PubsubRowToMessage.OUTPUT);
            messages.apply(PubsubIO.Write.class.getSimpleName(), this.buildPubsubWrite());
            return PCollectionRowTuple.of((String)PubsubWriteSchemaTransformProvider.ERROR_TAG, (PCollection)pct.get(PubsubRowToMessage.ERROR));
        }

        @UnknownKeyFor @NonNull @Initialized PayloadSerializer getPayloadSerializer(@UnknownKeyFor @NonNull @Initialized Schema schema) {
            if (this.configuration.getFormat() == null) {
                return null;
            }
            String format = this.configuration.getFormat();
            Set availableFormats = Providers.loadProviders(PayloadSerializerProvider.class).keySet();
            if (!availableFormats.contains(format)) {
                String availableFormatsString = String.join((CharSequence)",", availableFormats);
                throw new IllegalArgumentException(String.format("%s is not among the valid formats: [%s]", format, availableFormatsString));
            }
            return PayloadSerializers.getSerializer((String)this.configuration.getFormat(), (Schema)schema, (Map)ImmutableMap.of());
        }

        @UnknownKeyFor @NonNull @Initialized PubsubRowToMessage buildPubsubRowToMessage(@UnknownKeyFor @NonNull @Initialized Schema schema) {
            PubsubRowToMessage.Builder builder = PubsubRowToMessage.builder().setPayloadSerializer(this.getPayloadSerializer(schema));
            if (this.configuration.getTarget() != null) {
                builder = builder.setTargetTimestampAttributeName(this.configuration.getTarget().getTimestampAttributeKey());
            }
            return builder.build();
        }

        @UnknownKeyFor @NonNull @Initialized PubsubIO.Write<@UnknownKeyFor @NonNull @Initialized PubsubMessage> buildPubsubWrite() {
            PubsubIO.Write<PubsubMessage> write = PubsubIO.writeMessages().to(this.configuration.getTopic());
            if (this.configuration.getIdAttribute() != null) {
                write = write.withIdAttribute(this.configuration.getIdAttribute());
            }
            if (this.pubsubClientFactory != null) {
                write = write.withClientFactory(this.pubsubClientFactory);
            }
            return write;
        }

        void validateSourceSchemaAgainstConfiguration(@UnknownKeyFor @NonNull @Initialized Schema sourceSchema) {
            PubsubRowToMessage.FieldMatcher fieldMatcher;
            Schema.FieldType fieldType;
            String fieldName;
            if (sourceSchema.getFieldCount() == 0) {
                throw new IllegalArgumentException(String.format("empty Schema for %s", PubsubWriteSchemaTransformProvider.INPUT_TAG));
            }
            if (this.configuration.getSource() == null) {
                return;
            }
            PubsubWriteSchemaTransformConfiguration.SourceConfiguration source = this.configuration.getSource();
            if (source.getAttributesFieldName() != null) {
                fieldName = source.getAttributesFieldName();
                fieldType = PubsubRowToMessage.ATTRIBUTES_FIELD_TYPE;
                fieldMatcher = PubsubRowToMessage.FieldMatcher.of(fieldName, fieldType);
                Preconditions.checkArgument((boolean)fieldMatcher.match(sourceSchema), (Object)String.format("schema missing field: %s for type %s: ", fieldName, fieldType));
            }
            if (source.getTimestampFieldName() != null) {
                fieldName = source.getTimestampFieldName();
                fieldType = PubsubRowToMessage.EVENT_TIMESTAMP_FIELD_TYPE;
                fieldMatcher = PubsubRowToMessage.FieldMatcher.of(fieldName, fieldType);
                Preconditions.checkArgument((boolean)fieldMatcher.match(sourceSchema), (Object)String.format("schema missing field: %s for type: %s", fieldName, fieldType));
            }
            if (source.getPayloadFieldName() == null) {
                return;
            }
            fieldName = source.getPayloadFieldName();
            PubsubRowToMessage.FieldMatcher bytesFieldMatcher = PubsubRowToMessage.FieldMatcher.of(fieldName, PubsubRowToMessage.PAYLOAD_BYTES_TYPE_NAME);
            PubsubRowToMessage.FieldMatcher rowFieldMatcher = PubsubRowToMessage.FieldMatcher.of(fieldName, PubsubRowToMessage.PAYLOAD_ROW_TYPE_NAME);
            PubsubRowToMessage.SchemaReflection schemaReflection = PubsubRowToMessage.SchemaReflection.of(sourceSchema);
            Preconditions.checkArgument((boolean)schemaReflection.matchesAny(bytesFieldMatcher, rowFieldMatcher), (Object)String.format("schema missing field: %s for types %s or %s", fieldName, PubsubRowToMessage.PAYLOAD_BYTES_TYPE_NAME, PubsubRowToMessage.PAYLOAD_ROW_TYPE_NAME));
            String[] fieldsToExclude = (String[])Stream.of(source.getAttributesFieldName(), source.getTimestampFieldName(), source.getPayloadFieldName()).filter(Objects::nonNull).toArray(String[]::new);
            Schema userFieldsSchema = PubsubRowToMessage.removeFields(sourceSchema, fieldsToExclude);
            if (userFieldsSchema.getFieldCount() > 0) {
                throw new IllegalArgumentException(String.format("user fields incompatible with %s field", source.getPayloadFieldName()));
            }
        }

        void validateTargetSchemaAgainstPubsubSchema(@UnknownKeyFor @NonNull @Initialized Schema targetSchema, @UnknownKeyFor @NonNull @Initialized PipelineOptions options) {
            Preconditions.checkArgument((options != null ? 1 : 0) != 0);
            try (PubsubClient pubsubClient = this.getPubsubClient((PubsubOptions)options.as(PubsubOptions.class));){
                PubsubClient.TopicPath topicPath = PubsubClient.topicPathFromPath(this.configuration.getTopic());
                PubsubClient.SchemaPath schemaPath = pubsubClient.getSchemaPath(topicPath);
                if (schemaPath == null || schemaPath.equals(PubsubClient.SchemaPath.DELETED_SCHEMA)) {
                    return;
                }
                Schema expectedSchema = pubsubClient.getSchema(schemaPath);
                Preconditions.checkState((boolean)targetSchema.equals((Object)expectedSchema), (Object)String.format("input schema mismatch with expected schema at path: %s\ninput schema: %s\nPub/Sub schema: %s", schemaPath, targetSchema, expectedSchema));
            }
            catch (IOException e) {
                throw new IllegalStateException(e.getMessage());
            }
        }

        @UnknownKeyFor @NonNull @Initialized Schema buildTargetSchema(@UnknownKeyFor @NonNull @Initialized Schema sourceSchema) {
            this.validateSourceSchemaAgainstConfiguration(sourceSchema);
            Schema.FieldType payloadFieldType = null;
            ArrayList<String> fieldsToRemove = new ArrayList<String>();
            if (this.configuration.getSource() != null) {
                PubsubWriteSchemaTransformConfiguration.SourceConfiguration source = this.configuration.getSource();
                if (source.getAttributesFieldName() != null) {
                    fieldsToRemove.add(source.getAttributesFieldName());
                }
                if (source.getTimestampFieldName() != null) {
                    fieldsToRemove.add(source.getTimestampFieldName());
                }
                if (source.getPayloadFieldName() != null) {
                    String fieldName = source.getPayloadFieldName();
                    Schema.Field field = sourceSchema.getField(fieldName);
                    payloadFieldType = field.getType();
                    fieldsToRemove.add(fieldName);
                }
            }
            Schema targetSchema = PubsubRowToMessage.builder().build().inputSchemaFactory(payloadFieldType).buildSchema(sourceSchema.getFields().toArray(new Schema.Field[0]));
            return PubsubRowToMessage.removeFields(targetSchema, fieldsToRemove.toArray(new String[0]));
        }

        private @UnknownKeyFor @NonNull @Initialized PubsubClient.PubsubClientFactory getPubsubClientFactory() {
            if (this.pubsubClientFactory != null) {
                return this.pubsubClientFactory;
            }
            return PubsubGrpcClient.FACTORY;
        }

        private @UnknownKeyFor @NonNull @Initialized PubsubClient getPubsubClient(@UnknownKeyFor @NonNull @Initialized PubsubOptions options) throws @UnknownKeyFor @NonNull @Initialized IOException {
            return this.getPubsubClientFactory().newClient(this.configuration.getTarget().getTimestampAttributeKey(), this.configuration.getIdAttribute(), options);
        }

        // Could not load outer class - annotation placement on inner may be incorrect
        @UnknownKeyFor @NonNull @Initialized ParDo.SingleOutput<@UnknownKeyFor @NonNull @Initialized Row, @UnknownKeyFor @NonNull @Initialized Row> convertForRowToMessage(@UnknownKeyFor @NonNull @Initialized Schema targetSchema) {
            return this.convertForRowToMessage(targetSchema, null);
        }

        // Could not load outer class - annotation placement on inner may be incorrect
        @UnknownKeyFor @NonNull @Initialized ParDo.SingleOutput<@UnknownKeyFor @NonNull @Initialized Row, @UnknownKeyFor @NonNull @Initialized Row> convertForRowToMessage(@UnknownKeyFor @NonNull @Initialized Schema targetSchema, @javax.annotation.Nullable @UnknownKeyFor @Nullable @Initialized Clock clock) {
            String attributesName = null;
            String timestampName = null;
            String payloadName = null;
            PubsubWriteSchemaTransformConfiguration.SourceConfiguration source = this.configuration.getSource();
            if (source != null) {
                attributesName = source.getAttributesFieldName();
                timestampName = source.getTimestampFieldName();
                payloadName = source.getPayloadFieldName();
            }
            return ParDo.of((DoFn)new ConvertForRowToMessage(targetSchema, clock, attributesName, timestampName, payloadName));
        }
    }
}

