/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.io.gcp.spanner;

import com.google.cloud.spanner.BatchReadOnlyTransaction;
import com.google.cloud.spanner.TimestampBound;
import org.apache.beam.sdk.io.gcp.spanner.SpannerAccessor;
import org.apache.beam.sdk.io.gcp.spanner.SpannerConfig;
import org.apache.beam.sdk.io.gcp.spanner.Transaction;
import org.apache.beam.sdk.transforms.DoFn;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;

class CreateTransactionFn
extends DoFn<Object, Transaction> {
    private final @UnknownKeyFor @NonNull @Initialized SpannerConfig config;
    private final @UnknownKeyFor @NonNull @Initialized TimestampBound timestampBound;
    private transient @UnknownKeyFor @NonNull @Initialized SpannerAccessor spannerAccessor;

    CreateTransactionFn(@UnknownKeyFor @NonNull @Initialized SpannerConfig config, @UnknownKeyFor @NonNull @Initialized TimestampBound timestampBound) {
        this.config = config;
        this.timestampBound = timestampBound;
    }

    @DoFn.Setup
    public void setup() throws @UnknownKeyFor @NonNull @Initialized Exception {
        this.spannerAccessor = SpannerAccessor.getOrCreate(this.config);
    }

    @DoFn.Teardown
    public void teardown() throws @UnknownKeyFor @NonNull @Initialized Exception {
        this.spannerAccessor.close();
    }

    @DoFn.ProcessElement
    public void processElement(/*
     * Issues handling annotations - annotations may be inaccurate
     */
    // Could not load outer class - annotation placement on inner may be incorrect
    @UnknownKeyFor @UnknownKeyFor @UnknownKeyFor @NonNull @Initialized @NonNull @Initialized @NonNull @Initialized DoFn. @UnknownKeyFor @NonNull @Initialized ProcessContext c) throws @UnknownKeyFor @NonNull @Initialized Exception {
        BatchReadOnlyTransaction tx = this.spannerAccessor.getBatchClient().batchReadOnlyTransaction(this.timestampBound);
        c.output((Object)Transaction.create(tx.getBatchTransactionId()));
    }
}

