/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.io.gcp.testing;

import com.google.api.client.http.HttpRequestInitializer;
import com.google.api.client.http.HttpTransport;
import com.google.api.client.json.JsonFactory;
import com.google.api.client.util.BackOff;
import com.google.api.client.util.BackOffUtils;
import com.google.api.client.util.ClassInfo;
import com.google.api.client.util.Data;
import com.google.api.client.util.Sleeper;
import com.google.api.services.bigquery.Bigquery;
import com.google.api.services.bigquery.BigqueryScopes;
import com.google.api.services.bigquery.model.Dataset;
import com.google.api.services.bigquery.model.DatasetReference;
import com.google.api.services.bigquery.model.GetQueryResultsResponse;
import com.google.api.services.bigquery.model.Job;
import com.google.api.services.bigquery.model.JobConfiguration;
import com.google.api.services.bigquery.model.JobConfigurationQuery;
import com.google.api.services.bigquery.model.QueryRequest;
import com.google.api.services.bigquery.model.QueryResponse;
import com.google.api.services.bigquery.model.Table;
import com.google.api.services.bigquery.model.TableDataInsertAllRequest;
import com.google.api.services.bigquery.model.TableDataInsertAllResponse;
import com.google.api.services.bigquery.model.TableFieldSchema;
import com.google.api.services.bigquery.model.TableList;
import com.google.api.services.bigquery.model.TableReference;
import com.google.api.services.bigquery.model.TableRow;
import com.google.api.services.bigquery.model.TableSchema;
import com.google.auth.Credentials;
import com.google.auth.http.HttpCredentialsAdapter;
import com.google.auth.oauth2.GoogleCredentials;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Random;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import org.apache.beam.sdk.annotations.Internal;
import org.apache.beam.sdk.extensions.gcp.util.BackOffAdapter;
import org.apache.beam.sdk.extensions.gcp.util.Transport;
import org.apache.beam.sdk.util.FluentBackoff;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.base.Preconditions;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.collect.ImmutableList;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.collect.Lists;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;
import org.joda.time.Duration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Internal
public class BigqueryClient {
    private static final @UnknownKeyFor @NonNull @Initialized Logger LOG = LoggerFactory.getLogger(BigqueryClient.class);
    static final @UnknownKeyFor @NonNull @Initialized int MAX_QUERY_RETRIES = 4;
    static final @UnknownKeyFor @NonNull @Initialized Long QUERY_TIMEOUT_MS = 20000L;
    private static final @UnknownKeyFor @NonNull @Initialized Duration INITIAL_BACKOFF = Duration.standardSeconds((long)1L);
    static final @UnknownKeyFor @NonNull @Initialized FluentBackoff BACKOFF_FACTORY = FluentBackoff.DEFAULT.withMaxRetries(4).withInitialBackoff(INITIAL_BACKOFF);
    private static final @UnknownKeyFor @NonNull @Initialized Collection<@UnknownKeyFor @NonNull @Initialized String> RESERVED_FIELD_NAMES = ClassInfo.of(TableRow.class).getNames();
    private @UnknownKeyFor @NonNull @Initialized Bigquery bqClient;

    private static @UnknownKeyFor @NonNull @Initialized Credentials getDefaultCredential() {
        GoogleCredentials credential;
        try {
            credential = GoogleCredentials.getApplicationDefault();
        }
        catch (IOException e) {
            throw new RuntimeException("Failed to get application default credential.", e);
        }
        if (credential.createScopedRequired()) {
            ArrayList bigqueryScope = Lists.newArrayList((Iterable)BigqueryScopes.all());
            credential = credential.createScoped((Collection)bigqueryScope);
        }
        return credential;
    }

    public static @UnknownKeyFor @NonNull @Initialized Bigquery getNewBigqueryClient(@UnknownKeyFor @NonNull @Initialized String applicationName) {
        HttpTransport transport = Transport.getTransport();
        JsonFactory jsonFactory = Transport.getJsonFactory();
        Credentials credential = BigqueryClient.getDefaultCredential();
        return new Bigquery.Builder(transport, jsonFactory, (HttpRequestInitializer)new HttpCredentialsAdapter(credential)).setApplicationName(applicationName).build();
    }

    public static @UnknownKeyFor @NonNull @Initialized BigqueryClient getClient(@UnknownKeyFor @NonNull @Initialized String applicationName) {
        return new BigqueryClient(applicationName);
    }

    public BigqueryClient(@UnknownKeyFor @NonNull @Initialized String applicationName) {
        this.bqClient = BigqueryClient.getNewBigqueryClient(applicationName);
    }

    @Nonnull
    public @UnknownKeyFor @NonNull @Initialized QueryResponse queryWithRetries(@UnknownKeyFor @NonNull @Initialized String query, @UnknownKeyFor @NonNull @Initialized String projectId) throws @UnknownKeyFor @NonNull @Initialized IOException, @UnknownKeyFor @NonNull @Initialized InterruptedException {
        return this.queryWithRetries(query, projectId, false, false);
    }

    @Nonnull
    public @UnknownKeyFor @NonNull @Initialized QueryResponse queryWithRetriesUsingStandardSql(@UnknownKeyFor @NonNull @Initialized String query, @UnknownKeyFor @NonNull @Initialized String projectId) throws @UnknownKeyFor @NonNull @Initialized IOException, @UnknownKeyFor @NonNull @Initialized InterruptedException {
        return this.queryWithRetries(query, projectId, false, true);
    }

    private @Nullable @UnknownKeyFor @Initialized Object getTypedCellValue(@UnknownKeyFor @NonNull @Initialized TableFieldSchema fieldSchema, @UnknownKeyFor @NonNull @Initialized Object v) {
        if (Data.isNull((Object)v)) {
            return null;
        }
        if (Objects.equals(fieldSchema.getMode(), "REPEATED")) {
            TableFieldSchema elementSchema = fieldSchema.clone().setMode("REQUIRED");
            List rawCells = (List)v;
            ImmutableList.Builder values = ImmutableList.builder();
            for (Map element : rawCells) {
                values.add(this.getTypedCellValue(elementSchema, element.get("v")));
            }
            return values.build();
        }
        if ("RECORD".equals(fieldSchema.getType())) {
            Map typedV = (Map)v;
            return this.getTypedTableRow(fieldSchema.getFields(), typedV);
        }
        if ("FLOAT".equals(fieldSchema.getType())) {
            return Double.parseDouble((String)v);
        }
        if ("BOOLEAN".equals(fieldSchema.getType())) {
            return Boolean.parseBoolean((String)v);
        }
        if ("TIMESTAMP".equals(fieldSchema.getType())) {
            return (String)v;
        }
        return v;
    }

    private @UnknownKeyFor @NonNull @Initialized TableRow getTypedTableRow(@UnknownKeyFor @NonNull @Initialized List<@UnknownKeyFor @NonNull @Initialized TableFieldSchema> fields, @UnknownKeyFor @NonNull @Initialized Map<@UnknownKeyFor @NonNull @Initialized String, @UnknownKeyFor @NonNull @Initialized Object> rawRow) {
        List cells;
        TableRow row;
        if (rawRow instanceof TableRow) {
            row = (TableRow)rawRow;
            cells = row.getF();
            row.setF(null);
        } else {
            List rawCells;
            row = new TableRow();
            cells = rawCells = (List)rawRow.get("f");
        }
        Preconditions.checkState((cells.size() == fields.size() ? 1 : 0) != 0, (String)"Expected that the row has the same number of cells %s as fields in the schema %s", (int)cells.size(), (int)fields.size());
        Iterator cellIt = cells.iterator();
        Iterator<TableFieldSchema> fieldIt = fields.iterator();
        while (cellIt.hasNext()) {
            Map cell = (Map)cellIt.next();
            TableFieldSchema fieldSchema = fieldIt.next();
            Object convertedValue = this.getTypedCellValue(fieldSchema, cell.get("v"));
            String fieldName = fieldSchema.getName();
            Preconditions.checkArgument((!RESERVED_FIELD_NAMES.contains(fieldName) ? 1 : 0) != 0, (String)"BigQueryIO does not support records with columns named %s", (Object)fieldName);
            if (convertedValue == null) continue;
            row.set(fieldName, convertedValue);
        }
        return row;
    }

    private @UnknownKeyFor @NonNull @Initialized QueryResponse getTypedTableRows(@UnknownKeyFor @NonNull @Initialized QueryResponse response) {
        List rows = response.getRows();
        TableSchema schema = response.getSchema();
        response.setRows(rows.stream().map(r -> this.getTypedTableRow(schema.getFields(), (Map<String, Object>)r)).collect(Collectors.toList()));
        return response;
    }

    @Nonnull
    public @UnknownKeyFor @NonNull @Initialized List<@UnknownKeyFor @NonNull @Initialized TableRow> queryUnflattened(@UnknownKeyFor @NonNull @Initialized String query, @UnknownKeyFor @NonNull @Initialized String projectId, @UnknownKeyFor @NonNull @Initialized boolean typed, @UnknownKeyFor @NonNull @Initialized boolean useStandardSql) throws @UnknownKeyFor @NonNull @Initialized IOException, @UnknownKeyFor @NonNull @Initialized InterruptedException {
        GetQueryResultsResponse qResponse;
        Random rnd = new Random(System.currentTimeMillis());
        String temporaryDatasetId = "_dataflow_temporary_dataset_" + rnd.nextInt(1000000);
        String temporaryTableId = "dataflow_temporary_table_" + rnd.nextInt(1000000);
        TableReference tempTableReference = new TableReference().setProjectId(projectId).setDatasetId(temporaryDatasetId).setTableId(temporaryTableId);
        this.createNewDataset(projectId, temporaryDatasetId);
        this.createNewTable(projectId, temporaryDatasetId, new Table().setTableReference(tempTableReference));
        JobConfigurationQuery jcQuery = new JobConfigurationQuery().setFlattenResults(Boolean.valueOf(false)).setAllowLargeResults(Boolean.valueOf(true)).setDestinationTable(tempTableReference).setUseLegacySql(Boolean.valueOf(!useStandardSql)).setQuery(query);
        JobConfiguration jc = new JobConfiguration().setQuery(jcQuery);
        Job job = new Job().setConfiguration(jc);
        Job insertedJob = (Job)this.bqClient.jobs().insert(projectId, job).execute();
        while (!(qResponse = (GetQueryResultsResponse)this.bqClient.jobs().getQueryResults(projectId, insertedJob.getJobReference().getJobId()).execute()).getJobComplete().booleanValue()) {
        }
        TableSchema schema = qResponse.getSchema();
        List rows = qResponse.getRows();
        this.deleteDataset(projectId, temporaryDatasetId);
        return !typed ? rows : rows.stream().map(r -> this.getTypedTableRow(schema.getFields(), (Map<String, Object>)r)).collect(Collectors.toList());
    }

    @Nonnull
    public @UnknownKeyFor @NonNull @Initialized QueryResponse queryWithRetries(@UnknownKeyFor @NonNull @Initialized String query, @UnknownKeyFor @NonNull @Initialized String projectId, @UnknownKeyFor @NonNull @Initialized boolean typed) throws @UnknownKeyFor @NonNull @Initialized IOException, @UnknownKeyFor @NonNull @Initialized InterruptedException {
        return this.queryWithRetries(query, projectId, typed, false);
    }

    @Nonnull
    private @UnknownKeyFor @NonNull @Initialized QueryResponse queryWithRetries(@UnknownKeyFor @NonNull @Initialized String query, @UnknownKeyFor @NonNull @Initialized String projectId, @UnknownKeyFor @NonNull @Initialized boolean typed, @UnknownKeyFor @NonNull @Initialized boolean useStandardSql) throws @UnknownKeyFor @NonNull @Initialized IOException, @UnknownKeyFor @NonNull @Initialized InterruptedException {
        Sleeper sleeper = Sleeper.DEFAULT;
        BackOff backoff = BackOffAdapter.toGcpBackOff((org.apache.beam.sdk.util.BackOff)BACKOFF_FACTORY.backoff());
        IOException lastException = null;
        QueryRequest bqQueryRequest = new QueryRequest().setQuery(query).setTimeoutMs(QUERY_TIMEOUT_MS).setUseLegacySql(Boolean.valueOf(!useStandardSql));
        do {
            if (lastException != null) {
                LOG.warn("Retrying query ({}) after exception", (Object)bqQueryRequest.getQuery(), (Object)lastException);
            }
            try {
                QueryResponse response = (QueryResponse)this.bqClient.jobs().query(projectId, bqQueryRequest).execute();
                if (response != null) {
                    return typed ? this.getTypedTableRows(response) : response;
                }
                lastException = new IOException("Expected valid response from query job, but received null.");
            }
            catch (IOException e) {
                lastException = e;
            }
        } while (BackOffUtils.next((Sleeper)sleeper, (BackOff)backoff));
        throw new RuntimeException(String.format("Unable to get BigQuery response after retrying %d times using query (%s)", 4, bqQueryRequest.getQuery()), lastException);
    }

    public void createNewDataset(@UnknownKeyFor @NonNull @Initialized String projectId, @UnknownKeyFor @NonNull @Initialized String datasetId) throws @UnknownKeyFor @NonNull @Initialized IOException, @UnknownKeyFor @NonNull @Initialized InterruptedException {
        this.createNewDataset(projectId, datasetId, null);
    }

    public void createNewDataset(@UnknownKeyFor @NonNull @Initialized String projectId, @UnknownKeyFor @NonNull @Initialized String datasetId, @Nullable @UnknownKeyFor @Initialized Long defaultTableExpirationMs) throws @UnknownKeyFor @NonNull @Initialized IOException, @UnknownKeyFor @NonNull @Initialized InterruptedException {
        Sleeper sleeper = Sleeper.DEFAULT;
        BackOff backoff = BackOffAdapter.toGcpBackOff((org.apache.beam.sdk.util.BackOff)BACKOFF_FACTORY.backoff());
        IOException lastException = null;
        do {
            if (lastException != null) {
                LOG.warn("Retrying insert dataset ({}) after exception", (Object)datasetId, lastException);
            }
            try {
                Dataset response = (Dataset)this.bqClient.datasets().insert(projectId, new Dataset().setDatasetReference(new DatasetReference().setDatasetId(datasetId)).setDefaultTableExpirationMs(defaultTableExpirationMs)).execute();
                if (response != null) {
                    LOG.info("Successfully created new dataset : " + response.getId());
                    return;
                }
                lastException = new IOException("Expected valid response from insert dataset job, but received null.");
            }
            catch (IOException e) {
                lastException = e;
            }
        } while (BackOffUtils.next((Sleeper)sleeper, (BackOff)backoff));
        throw new RuntimeException(String.format("Unable to get BigQuery response after retrying %d times for dataset (%s)", 4, datasetId), lastException);
    }

    public void deleteTable(@UnknownKeyFor @NonNull @Initialized String projectId, @UnknownKeyFor @NonNull @Initialized String datasetId, @UnknownKeyFor @NonNull @Initialized String tableName) {
        try {
            this.bqClient.tables().delete(projectId, datasetId, tableName).execute();
            LOG.info("Successfully deleted table: " + tableName);
        }
        catch (Exception e) {
            LOG.debug("Exception caught when deleting table: " + e.getMessage());
        }
    }

    public void deleteDataset(@UnknownKeyFor @NonNull @Initialized String projectId, @UnknownKeyFor @NonNull @Initialized String datasetId) {
        try {
            TableList tables = (TableList)this.bqClient.tables().list(projectId, datasetId).execute();
            for (TableList.Tables table : tables.getTables()) {
                this.deleteTable(projectId, datasetId, table.getTableReference().getTableId());
            }
        }
        catch (Exception e) {
            LOG.debug("Exceptions caught when listing all tables: " + e.getMessage());
        }
        try {
            this.bqClient.datasets().delete(projectId, datasetId).execute();
            LOG.info("Successfully deleted dataset: " + datasetId);
        }
        catch (Exception e) {
            LOG.debug("Exceptions caught when deleting dataset: " + e.getMessage());
        }
    }

    public void createNewTable(@UnknownKeyFor @NonNull @Initialized String projectId, @UnknownKeyFor @NonNull @Initialized String datasetId, @UnknownKeyFor @NonNull @Initialized Table newTable) throws @UnknownKeyFor @NonNull @Initialized IOException, @UnknownKeyFor @NonNull @Initialized InterruptedException {
        Sleeper sleeper = Sleeper.DEFAULT;
        BackOff backoff = BackOffAdapter.toGcpBackOff((org.apache.beam.sdk.util.BackOff)BACKOFF_FACTORY.backoff());
        IOException lastException = null;
        do {
            if (lastException != null) {
                LOG.warn("Retrying create table ({}) after exception", (Object)newTable.getId(), (Object)lastException);
            }
            try {
                Table response = (Table)this.bqClient.tables().insert(projectId, datasetId, newTable).execute();
                if (response != null) {
                    LOG.info("Successfully created new table: " + response.getId());
                    return;
                }
                lastException = new IOException("Expected valid response from create table job, but received null.");
            }
            catch (IOException e) {
                lastException = e;
            }
        } while (BackOffUtils.next((Sleeper)sleeper, (BackOff)backoff));
        throw new RuntimeException(String.format("Unable to get BigQuery response after retrying %d times for table (%s)", 4, newTable.getId()), lastException);
    }

    public void insertDataToTable(@UnknownKeyFor @NonNull @Initialized String projectId, @UnknownKeyFor @NonNull @Initialized String datasetId, @UnknownKeyFor @NonNull @Initialized String tableName, @UnknownKeyFor @NonNull @Initialized List<@UnknownKeyFor @NonNull @Initialized Map<@UnknownKeyFor @NonNull @Initialized String, @UnknownKeyFor @NonNull @Initialized Object>> rows) throws @UnknownKeyFor @NonNull @Initialized IOException, @UnknownKeyFor @NonNull @Initialized InterruptedException {
        Sleeper sleeper = Sleeper.DEFAULT;
        BackOff backoff = BackOffAdapter.toGcpBackOff((org.apache.beam.sdk.util.BackOff)BACKOFF_FACTORY.backoff());
        IOException lastException = null;
        do {
            if (lastException != null) {
                LOG.warn("Retrying insert table ({}) after exception", (Object)tableName, lastException);
            }
            try {
                List dataRows = rows.stream().map(row -> new TableDataInsertAllRequest.Rows().setJson(row)).collect(Collectors.toList());
                TableDataInsertAllResponse response = (TableDataInsertAllResponse)this.bqClient.tabledata().insertAll(projectId, datasetId, tableName, new TableDataInsertAllRequest().setRows(dataRows)).execute();
                if (response != null && (response.getInsertErrors() == null || response.getInsertErrors().isEmpty())) {
                    LOG.info("Successfully inserted data into table : " + tableName);
                    return;
                }
                if (response == null || response.getInsertErrors() == null) {
                    lastException = new IOException("Expected valid response from insert data job, but received null.");
                    continue;
                }
                lastException = new IOException(String.format("Got insertion error (%s)", response.getInsertErrors().toString()));
            }
            catch (IOException e) {
                lastException = e;
            }
        } while (BackOffUtils.next((Sleeper)sleeper, (BackOff)backoff));
        throw new RuntimeException(String.format("Unable to get BigQuery response after retrying %d times for table (%s)", 4, tableName), lastException);
    }

    public @UnknownKeyFor @NonNull @Initialized Table getTableResource(@UnknownKeyFor @NonNull @Initialized String projectId, @UnknownKeyFor @NonNull @Initialized String datasetId, @UnknownKeyFor @NonNull @Initialized String tableId) throws @UnknownKeyFor @NonNull @Initialized IOException, @UnknownKeyFor @NonNull @Initialized InterruptedException {
        Sleeper sleeper = Sleeper.DEFAULT;
        BackOff backoff = BackOffAdapter.toGcpBackOff((org.apache.beam.sdk.util.BackOff)BACKOFF_FACTORY.backoff());
        IOException lastException = null;
        do {
            if (lastException != null) {
                LOG.warn("Retrying tables.get ({}) after exception", (Object)tableId, lastException);
            }
            try {
                Table response = (Table)this.bqClient.tables().get(projectId, datasetId, tableId).execute();
                if (response != null) {
                    return response;
                }
                lastException = new IOException("Expected valid response from tables.get, but received null.");
            }
            catch (IOException e) {
                lastException = e;
            }
        } while (BackOffUtils.next((Sleeper)sleeper, (BackOff)backoff));
        throw new RuntimeException(String.format("Unable to get BigQuery response after retrying %d times for tables.get (%s)", 4, tableId), lastException);
    }
}

