/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.redshift.geometric;

import com.amazon.redshift.geometric.RedshiftPoint;
import com.amazon.redshift.util.RedshiftObject;
import com.amazon.redshift.util.RedshiftTokenizer;
import java.io.Serializable;
import java.sql.SQLException;

public class RedshiftPolygon
extends RedshiftObject
implements Serializable,
Cloneable {
    public RedshiftPoint[] points;

    public RedshiftPolygon(RedshiftPoint[] points) {
        this();
        this.points = points;
    }

    public RedshiftPolygon(String s) throws SQLException {
        this();
        this.setValue(s);
    }

    public RedshiftPolygon() {
        this.setType("polygon");
    }

    @Override
    public void setValue(String s) throws SQLException {
        RedshiftTokenizer t = new RedshiftTokenizer(RedshiftTokenizer.removePara(s), ',');
        int npoints = t.getSize();
        this.points = new RedshiftPoint[npoints];
        for (int p = 0; p < npoints; ++p) {
            this.points[p] = new RedshiftPoint(t.getToken(p));
        }
    }

    @Override
    public boolean equals(Object obj) {
        if (obj instanceof RedshiftPolygon) {
            RedshiftPolygon p = (RedshiftPolygon)obj;
            if (p.points.length != this.points.length) {
                return false;
            }
            for (int i = 0; i < this.points.length; ++i) {
                if (this.points[i].equals(p.points[i])) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    @Override
    public int hashCode() {
        int hash = 0;
        for (int i = 0; i < this.points.length && i < 5; ++i) {
            hash ^= this.points[i].hashCode();
        }
        return hash;
    }

    @Override
    public Object clone() throws CloneNotSupportedException {
        RedshiftPolygon newRSpolygon = (RedshiftPolygon)super.clone();
        if (newRSpolygon.points != null) {
            newRSpolygon.points = (RedshiftPoint[])newRSpolygon.points.clone();
            for (int i = 0; i < newRSpolygon.points.length; ++i) {
                if (newRSpolygon.points[i] == null) continue;
                newRSpolygon.points[i] = (RedshiftPoint)newRSpolygon.points[i].clone();
            }
        }
        return newRSpolygon;
    }

    @Override
    public String getValue() {
        StringBuilder b = new StringBuilder();
        b.append("(");
        for (int p = 0; p < this.points.length; ++p) {
            if (p > 0) {
                b.append(",");
            }
            b.append(this.points[p].toString());
        }
        b.append(")");
        return b.toString();
    }
}

