/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.core.database;

import java.util.ArrayList;
import java.util.List;
import org.apache.hop.core.RowMetaAndData;
import org.apache.hop.core.row.RowMeta;
import org.apache.hop.core.row.value.ValueMetaString;

public class DatabaseConnectionPoolParameter {
    private String parameter;
    private String defaultValue;
    private String description;

    public DatabaseConnectionPoolParameter() {
    }

    public DatabaseConnectionPoolParameter(String parameter, String defaultValue, String description) {
        this();
        this.parameter = parameter;
        this.defaultValue = defaultValue;
        this.description = description;
    }

    public String getDefaultValue() {
        return this.defaultValue;
    }

    public void setDefaultValue(String defaultValue) {
        this.defaultValue = defaultValue;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public String getParameter() {
        return this.parameter;
    }

    public void setParameter(String parameter) {
        this.parameter = parameter;
    }

    public static final String[] getParameterNames(DatabaseConnectionPoolParameter[] poolParameters) {
        String[] names = new String[poolParameters.length];
        for (int i = 0; i < names.length; ++i) {
            names[i] = poolParameters[i].getParameter();
        }
        return names;
    }

    public static final DatabaseConnectionPoolParameter findParameter(String parameterName, DatabaseConnectionPoolParameter[] poolParameters) {
        for (int i = 0; i < poolParameters.length; ++i) {
            if (!poolParameters[i].getParameter().equalsIgnoreCase(parameterName)) continue;
            return poolParameters[i];
        }
        return null;
    }

    public static final List<RowMetaAndData> getRowList(DatabaseConnectionPoolParameter[] poolParameters, String titleParameter, String titleDefaultValue, String titleDescription) {
        RowMeta rowMeta = new RowMeta();
        rowMeta.addValueMeta(new ValueMetaString(titleParameter));
        rowMeta.addValueMeta(new ValueMetaString(titleDefaultValue));
        rowMeta.addValueMeta(new ValueMetaString(titleDescription));
        ArrayList<RowMetaAndData> list = new ArrayList<RowMetaAndData>();
        for (int i = 0; i < poolParameters.length; ++i) {
            DatabaseConnectionPoolParameter p = poolParameters[i];
            Object[] row = new Object[rowMeta.size()];
            row[0] = p.getParameter();
            row[1] = p.getDefaultValue();
            row[2] = p.getDescription();
            list.add(new RowMetaAndData(rowMeta, row));
        }
        return list;
    }
}

