/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.pipeline.transforms.databaselookup.readallcache;

import java.util.BitSet;

class SearchingContext {
    private BitSet candidates = null;
    private boolean noResult = false;
    private BitSet working;

    boolean isEmpty() {
        return this.noResult;
    }

    void setEmpty() {
        this.noResult = true;
        this.candidates = new BitSet(0);
        this.working = null;
    }

    BitSet getCandidates() {
        return this.candidates;
    }

    void init(int amount) {
        this.candidates = new BitSet(amount);
        this.candidates.set(0, amount, true);
        this.working = new BitSet(amount);
    }

    BitSet getWorkingSet() {
        this.working.clear();
        return this.working;
    }

    void intersect(BitSet set, boolean inverse) {
        if (inverse) {
            this.candidates.andNot(set);
        } else {
            this.candidates.and(set);
        }
        this.checkEmpty();
    }

    private void checkEmpty() {
        if (this.candidates.nextSetBit(0) == -1) {
            this.setEmpty();
        }
    }
}

