/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.streaming;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import org.apache.spark.internal.Logging;
import org.apache.spark.streaming.Duration;
import org.apache.spark.streaming.StreamingContext;
import org.apache.spark.streaming.Time;
import org.apache.spark.streaming.dstream.DStream;
import org.apache.spark.streaming.dstream.InputDStream;
import org.apache.spark.streaming.dstream.ReceiverInputDStream;
import org.apache.spark.streaming.scheduler.Job;
import org.apache.spark.util.Utils$;
import org.slf4j.Logger;
import scala.Function0;
import scala.Function1;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.Seq;
import scala.collection.SeqLike;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.ArrayOps;
import scala.collection.mutable.ArraySeq;
import scala.collection.mutable.ArraySeq$;
import scala.collection.parallel.immutable.ParVector;
import scala.math.Ordering;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.java8.JFunction0;

@ScalaSignature(bytes="\u0006\u0001\tme!B\u001a5\u0005Qb\u0004\"\u0002'\u0001\t\u0003q\u0005bB)\u0001\u0001\u0004%IA\u0015\u0005\b]\u0002\u0001\r\u0011\"\u0003p\u0011\u00191\u0007\u0001)Q\u0005'\"9Q\u000f\u0001a\u0001\n\u00131\b\"CA\u0001\u0001\u0001\u0007I\u0011BA\u0002\u0011\u0019y\b\u0001)Q\u0005o\"I\u0011q\u0001\u0001A\u0002\u0013%\u0011\u0011\u0002\u0005\n\u0003\u007f\u0001\u0001\u0019!C\u0005\u0003\u0003B\u0001\"!\u0012\u0001A\u0003&\u00111\u0002\u0005\n\u0003\u001f\u0002\u0001\u0019!C\u0001\u0003#B\u0011\"!\u0017\u0001\u0001\u0004%\t!a\u0017\t\u0011\u0005}\u0003\u0001)Q\u0005\u0003'B\u0011\"!\u0019\u0001\u0001\u0004%\t!a\u0019\t\u0013\u0005-\u0004\u00011A\u0005\u0002\u00055\u0004\u0002CA9\u0001\u0001\u0006K!!\u001a\t\u0013\u0005M\u0004\u00011A\u0005\u0002\u0005U\u0004\"CA?\u0001\u0001\u0007I\u0011AA@\u0011!\t\u0019\t\u0001Q!\n\u0005]\u0004\"CAC\u0001\u0001\u0007I\u0011AA;\u0011%\t9\t\u0001a\u0001\n\u0003\tI\t\u0003\u0005\u0002\u000e\u0002\u0001\u000b\u0015BA<\u0011%\ty\t\u0001a\u0001\n\u0003\t\t\u0006C\u0005\u0002\u0012\u0002\u0001\r\u0011\"\u0001\u0002\u0014\"A\u0011q\u0013\u0001!B\u0013\t\u0019\u0006C\u0005\u0002\u001a\u0002\u0001\r\u0011\"\u0003\u0002\u001c\"I\u0011Q\u0014\u0001A\u0002\u0013%\u0011q\u0014\u0005\t\u0003G\u0003\u0001\u0015)\u0003\u0002:!9\u0011q\u0015\u0001\u0005\u0002\u0005%\u0006bBAX\u0001\u0011\u0005\u0011\u0011\u0017\u0005\b\u0003k\u0003A\u0011AA\\\u0011\u001d\tI\f\u0001C\u0001\u0003wCq!a2\u0001\t\u0003\tI\rC\u0004\u0002P\u0002!\t!!5\t\u000f\u0005U\u0007\u0001\"\u0001\u0002X\"9\u0011q\u001d\u0001\u0005\u0002\u0005%\bbBA}\u0001\u0011\u0005\u00111 \u0005\b\u0005\u001b\u0001A\u0011\u0001B\b\u0011\u001d\u0011i\u0002\u0001C\u0001\u0005?AqA!\r\u0001\t\u0003\tY\nC\u0004\u00034\u0001!\t!!\u0003\t\u000f\tU\u0002\u0001\"\u0001\u00038!9!\u0011\n\u0001\u0005\u0002\t-\u0003b\u0002B(\u0001\u0011\u0005!\u0011\u000b\u0005\b\u0005+\u0002A\u0011\u0001B,\u0011\u001d\u0011Y\u0006\u0001C\u0001\u0003oCqA!\u0018\u0001\t\u0003\t9\fC\u0004\u0003`\u0001!\tA!\u0019\t\u000f\t\r\u0004\u0001\"\u0003\u0003f!9!1\u0012\u0001\u0005\n\t5%\u0001\u0004#TiJ,\u0017-\\$sCBD'BA\u001b7\u0003%\u0019HO]3b[&twM\u0003\u00028q\u0005)1\u000f]1sW*\u0011\u0011HO\u0001\u0007CB\f7\r[3\u000b\u0003m\n1a\u001c:h'\u0011\u0001Qh\u0011$\u0011\u0005y\nU\"A \u000b\u0003\u0001\u000bQa]2bY\u0006L!AQ \u0003\r\u0005s\u0017PU3g!\tqD)\u0003\u0002F\u007f\ta1+\u001a:jC2L'0\u00192mKB\u0011qIS\u0007\u0002\u0011*\u0011\u0011JN\u0001\tS:$XM\u001d8bY&\u00111\n\u0013\u0002\b\u0019><w-\u001b8h\u0003\u0019a\u0014N\\5u}\r\u0001A#A(\u0011\u0005A\u0003Q\"\u0001\u001b\u0002\u0019%t\u0007/\u001e;TiJ,\u0017-\\:\u0016\u0003M\u00032\u0001V-\\\u001b\u0005)&B\u0001,X\u0003\u001diW\u000f^1cY\u0016T!\u0001W \u0002\u0015\r|G\u000e\\3di&|g.\u0003\u0002[+\nA\u0011I\u001d:bsN+\u0017\u000f\r\u0002]IB\u0019Q\f\u00192\u000e\u0003yS!a\u0018\u001b\u0002\u000f\u0011\u001cHO]3b[&\u0011\u0011M\u0018\u0002\r\u0013:\u0004X\u000f\u001e#TiJ,\u0017-\u001c\t\u0003G\u0012d\u0001\u0001B\u0005f\t\u0005\u0005\t\u0011!B\u0001O\n\u0019q\fJ\u0019\u0002\u001b%t\u0007/\u001e;TiJ,\u0017-\\:!#\tA7\u000e\u0005\u0002?S&\u0011!n\u0010\u0002\b\u001d>$\b.\u001b8h!\tqD.\u0003\u0002n\u007f\t\u0019\u0011I\\=\u0002!%t\u0007/\u001e;TiJ,\u0017-\\:`I\u0015\fHC\u00019t!\tq\u0014/\u0003\u0002s\u007f\t!QK\\5u\u0011\u001d!8!!AA\u0002M\u000b1\u0001\u001f\u00132\u00035yW\u000f\u001e9viN#(/Z1ngV\tq\u000fE\u0002U3b\u0004$!_?\u0011\u0007uSH0\u0003\u0002|=\n9Ai\u0015;sK\u0006l\u0007CA2~\t%qx!!A\u0001\u0002\u000b\u0005qMA\u0002`II\nab\\;uaV$8\u000b\u001e:fC6\u001c\b%A\tpkR\u0004X\u000f^*ue\u0016\fWn]0%KF$2\u0001]A\u0003\u0011\u001d!h!!AA\u0002]\fA#\u001b8qkR\u001cFO]3b[:\u000bW.Z!oI&#UCAA\u0006!\u0019\ti!!\b\u0002$9!\u0011qBA\r\u001d\u0011\t\t\"a\u0006\u000e\u0005\u0005M!bAA\u000b\u001b\u00061AH]8pizJ\u0011\u0001Q\u0005\u0004\u00037y\u0014a\u00029bG.\fw-Z\u0005\u0005\u0003?\t\tCA\u0002TKFT1!a\u0007@!\u001dq\u0014QEA\u0015\u0003sI1!a\n@\u0005\u0019!V\u000f\u001d7feA!\u00111FA\u001a\u001d\u0011\ti#a\f\u0011\u0007\u0005Eq(C\u0002\u00022}\na\u0001\u0015:fI\u00164\u0017\u0002BA\u001b\u0003o\u0011aa\u0015;sS:<'bAA\u0019\u007fA\u0019a(a\u000f\n\u0007\u0005urHA\u0002J]R\f\u0001$\u001b8qkR\u001cFO]3b[:\u000bW.Z!oI&#u\fJ3r)\r\u0001\u00181\t\u0005\ti&\t\t\u00111\u0001\u0002\f\u0005)\u0012N\u001c9viN#(/Z1n\u001d\u0006lW-\u00118e\u0013\u0012\u0003\u0003f\u0001\u0006\u0002JA\u0019a(a\u0013\n\u0007\u00055sH\u0001\u0005w_2\fG/\u001b7f\u0003A\u0011X-\\3nE\u0016\u0014H)\u001e:bi&|g.\u0006\u0002\u0002TA\u0019\u0001+!\u0016\n\u0007\u0005]CG\u0001\u0005EkJ\fG/[8o\u0003Q\u0011X-\\3nE\u0016\u0014H)\u001e:bi&|gn\u0018\u0013fcR\u0019\u0001/!\u0018\t\u0011Qd\u0011\u0011!a\u0001\u0003'\n\u0011C]3nK6\u0014WM\u001d#ve\u0006$\u0018n\u001c8!\u0003Q\u0019\u0007.Z2la>Lg\u000e^%o!J|wM]3tgV\u0011\u0011Q\r\t\u0004}\u0005\u001d\u0014bAA5\u007f\t9!i\\8mK\u0006t\u0017\u0001G2iK\u000e\\\u0007o\\5oi&s\u0007K]8he\u0016\u001c8o\u0018\u0013fcR\u0019\u0001/a\u001c\t\u0011Q|\u0011\u0011!a\u0001\u0003K\nQc\u00195fG.\u0004x.\u001b8u\u0013:\u0004&o\\4sKN\u001c\b%\u0001\u0005{KJ|G+[7f+\t\t9\bE\u0002Q\u0003sJ1!a\u001f5\u0005\u0011!\u0016.\\3\u0002\u0019i,'o\u001c+j[\u0016|F%Z9\u0015\u0007A\f\t\t\u0003\u0005u%\u0005\u0005\t\u0019AA<\u0003%QXM]8US6,\u0007%A\u0005ti\u0006\u0014H\u000fV5nK\u0006i1\u000f^1siRKW.Z0%KF$2\u0001]AF\u0011!!X#!AA\u0002\u0005]\u0014AC:uCJ$H+[7fA\u0005i!-\u0019;dQ\u0012+(/\u0019;j_:\f\u0011CY1uG\"$UO]1uS>tw\fJ3r)\r\u0001\u0018Q\u0013\u0005\tib\t\t\u00111\u0001\u0002T\u0005q!-\u0019;dQ\u0012+(/\u0019;j_:\u0004\u0013\u0001\u00048v[J+7-Z5wKJ\u001cXCAA\u001d\u0003AqW/\u001c*fG\u0016Lg/\u001a:t?\u0012*\u0017\u000fF\u0002q\u0003CC\u0001\u0002^\u000e\u0002\u0002\u0003\u0007\u0011\u0011H\u0001\u000e]Vl'+Z2fSZ,'o\u001d\u0011)\u0007q\tI%A\u0003ti\u0006\u0014H\u000fF\u0002q\u0003WCq!!,\u001e\u0001\u0004\t9(\u0001\u0003uS6,\u0017a\u0002:fgR\f'\u000f\u001e\u000b\u0004a\u0006M\u0006bBAW=\u0001\u0007\u0011qO\u0001\u0005gR|\u0007\u000fF\u0001q\u0003)\u0019X\r^\"p]R,\u0007\u0010\u001e\u000b\u0004a\u0006u\u0006bBA`A\u0001\u0007\u0011\u0011Y\u0001\u0004gN\u001c\u0007c\u0001)\u0002D&\u0019\u0011Q\u0019\u001b\u0003!M#(/Z1nS:<7i\u001c8uKb$\u0018\u0001E:fi\n\u000bGo\u00195EkJ\fG/[8o)\r\u0001\u00181\u001a\u0005\b\u0003\u001b\f\u0003\u0019AA*\u0003!!WO]1uS>t\u0017\u0001\u0003:f[\u0016l'-\u001a:\u0015\u0007A\f\u0019\u000eC\u0004\u0002N\n\u0002\r!a\u0015\u0002\u001d\u0005$G-\u00138qkR\u001cFO]3b[R\u0019\u0001/!7\t\u000f\u0005m7\u00051\u0001\u0002^\u0006Y\u0011N\u001c9viN#(/Z1na\u0011\ty.a9\u0011\tu\u0003\u0017\u0011\u001d\t\u0004G\u0006\rHaCAs\u00033\f\t\u0011!A\u0003\u0002\u001d\u00141a\u0018\u00135\u0003=\tG\rZ(viB,Ho\u0015;sK\u0006lGc\u00019\u0002l\"9\u0011Q\u001e\u0013A\u0002\u0005=\u0018\u0001D8viB,Ho\u0015;sK\u0006l\u0007\u0007BAy\u0003k\u0004B!\u0018>\u0002tB\u00191-!>\u0005\u0017\u0005]\u00181^A\u0001\u0002\u0003\u0015\ta\u001a\u0002\u0004?\u0012*\u0014aD4fi&s\u0007/\u001e;TiJ,\u0017-\\:\u0015\u0005\u0005u\b#\u0002 \u0002\u0000\n\r\u0011b\u0001B\u0001\u007f\t)\u0011I\u001d:bsB\"!Q\u0001B\u0005!\u0011i\u0006Ma\u0002\u0011\u0007\r\u0014I\u0001\u0002\u0006\u0003\f\u0015\n\t\u0011!A\u0003\u0002\u001d\u00141a\u0018\u00137\u0003A9W\r^(viB,Ho\u0015;sK\u0006l7\u000f\u0006\u0002\u0003\u0012A)a(a@\u0003\u0014A\"!Q\u0003B\r!\u0011i&Pa\u0006\u0011\u0007\r\u0014I\u0002\u0002\u0006\u0003\u001c\u0019\n\t\u0011!A\u0003\u0002\u001d\u00141a\u0018\u00138\u0003]9W\r\u001e*fG\u0016Lg/\u001a:J]B,Ho\u0015;sK\u0006l7\u000f\u0006\u0002\u0003\"A)a(a@\u0003$A\"!Q\u0005B\u0017!\u0015i&q\u0005B\u0016\u0013\r\u0011IC\u0018\u0002\u0015%\u0016\u001cW-\u001b<fe&s\u0007/\u001e;E'R\u0014X-Y7\u0011\u0007\r\u0014i\u0003\u0002\u0006\u00030\u001d\n\t\u0011!A\u0003\u0002\u001d\u00141a\u0018\u00139\u0003=9W\r\u001e(v[J+7-Z5wKJ\u001c\u0018aF4fi&s\u0007/\u001e;TiJ,\u0017-\u001c(b[\u0016\fe\u000eZ%E\u000319WM\\3sCR,'j\u001c2t)\u0011\u0011IDa\u0012\u0011\r\u00055\u0011Q\u0004B\u001e!\u0011\u0011iDa\u0011\u000e\u0005\t}\"b\u0001B!i\u0005I1o\u00195fIVdWM]\u0005\u0005\u0005\u000b\u0012yDA\u0002K_\nDq!!,+\u0001\u0004\t9(A\u0007dY\u0016\f'/T3uC\u0012\fG/\u0019\u000b\u0004a\n5\u0003bBAWW\u0001\u0007\u0011qO\u0001\u0015kB$\u0017\r^3DQ\u0016\u001c7\u000e]8j]R$\u0015\r^1\u0015\u0007A\u0014\u0019\u0006C\u0004\u0002.2\u0002\r!a\u001e\u0002'\rdW-\u0019:DQ\u0016\u001c7\u000e]8j]R$\u0015\r^1\u0015\u0007A\u0014I\u0006C\u0004\u0002.6\u0002\r!a\u001e\u0002+I,7\u000f^8sK\u000eCWmY6q_&tG\u000fR1uC\u0006Aa/\u00197jI\u0006$X-A\u0011hKRl\u0015\r_%oaV$8\u000b\u001e:fC6\u0014V-\\3nE\u0016\u0014H)\u001e:bi&|g\u000e\u0006\u0002\u0002T\u0005YqO]5uK>\u0013'.Z2u)\r\u0001(q\r\u0005\b\u0005S\n\u0004\u0019\u0001B6\u0003\rywn\u001d\t\u0005\u0005[\u00129(\u0004\u0002\u0003p)!!\u0011\u000fB:\u0003\tIwN\u0003\u0002\u0003v\u0005!!.\u0019<b\u0013\u0011\u0011IHa\u001c\u0003%=\u0013'.Z2u\u001fV$\b/\u001e;TiJ,\u0017-\u001c\u0015\u0006c\tu$\u0011\u0012\t\u0006}\t}$1Q\u0005\u0004\u0005\u0003{$A\u0002;ie><8\u000f\u0005\u0003\u0003n\t\u0015\u0015\u0002\u0002BD\u0005_\u00121\"S(Fq\u000e,\u0007\u000f^5p]\u000e\u0012!1Q\u0001\u000be\u0016\fGm\u00142kK\u000e$Hc\u00019\u0003\u0010\"9!\u0011\u0013\u001aA\u0002\tM\u0015aA8jgB!!Q\u000eBK\u0013\u0011\u00119Ja\u001c\u0003#=\u0013'.Z2u\u0013:\u0004X\u000f^*ue\u0016\fW\u000eK\u00033\u0005{\u0012I\t")
public final class DStreamGraph
implements scala.Serializable,
Logging {
    private ArraySeq<InputDStream<?>> inputStreams;
    private ArraySeq<DStream<?>> outputStreams;
    private volatile Seq<Tuple2<String, Object>> inputStreamNameAndID;
    private Duration rememberDuration;
    private boolean checkpointInProgress;
    private Time zeroTime;
    private Time startTime;
    private Duration batchDuration;
    private volatile int numReceivers;
    private transient Logger org$apache$spark$internal$Logging$$log_;

    public String logName() {
        return Logging.logName$((Logging)this);
    }

    public Logger log() {
        return Logging.log$((Logging)this);
    }

    public void logInfo(Function0<String> msg) {
        Logging.logInfo$((Logging)this, msg);
    }

    public void logDebug(Function0<String> msg) {
        Logging.logDebug$((Logging)this, msg);
    }

    public void logTrace(Function0<String> msg) {
        Logging.logTrace$((Logging)this, msg);
    }

    public void logWarning(Function0<String> msg) {
        Logging.logWarning$((Logging)this, msg);
    }

    public void logError(Function0<String> msg) {
        Logging.logError$((Logging)this, msg);
    }

    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.logInfo$((Logging)this, msg, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.logDebug$((Logging)this, msg, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.logTrace$((Logging)this, msg, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.logWarning$((Logging)this, msg, (Throwable)throwable);
    }

    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.logError$((Logging)this, msg, (Throwable)throwable);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void initializeLogIfNecessary(boolean isInterpreter) {
        Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter);
    }

    public boolean initializeLogIfNecessary(boolean isInterpreter, boolean silent) {
        return Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public boolean initializeLogIfNecessary$default$2() {
        return Logging.initializeLogIfNecessary$default$2$((Logging)this);
    }

    public void initializeForcefully(boolean isInterpreter, boolean silent) {
        Logging.initializeForcefully$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public Logger org$apache$spark$internal$Logging$$log_() {
        return this.org$apache$spark$internal$Logging$$log_;
    }

    public void org$apache$spark$internal$Logging$$log__$eq(Logger x$1) {
        this.org$apache$spark$internal$Logging$$log_ = x$1;
    }

    private ArraySeq<InputDStream<?>> inputStreams() {
        return this.inputStreams;
    }

    private void inputStreams_$eq(ArraySeq<InputDStream<?>> x$1) {
        this.inputStreams = x$1;
    }

    private ArraySeq<DStream<?>> outputStreams() {
        return this.outputStreams;
    }

    private void outputStreams_$eq(ArraySeq<DStream<?>> x$1) {
        this.outputStreams = x$1;
    }

    private Seq<Tuple2<String, Object>> inputStreamNameAndID() {
        return this.inputStreamNameAndID;
    }

    private void inputStreamNameAndID_$eq(Seq<Tuple2<String, Object>> x$1) {
        this.inputStreamNameAndID = x$1;
    }

    public Duration rememberDuration() {
        return this.rememberDuration;
    }

    public void rememberDuration_$eq(Duration x$1) {
        this.rememberDuration = x$1;
    }

    public boolean checkpointInProgress() {
        return this.checkpointInProgress;
    }

    public void checkpointInProgress_$eq(boolean x$1) {
        this.checkpointInProgress = x$1;
    }

    public Time zeroTime() {
        return this.zeroTime;
    }

    public void zeroTime_$eq(Time x$1) {
        this.zeroTime = x$1;
    }

    public Time startTime() {
        return this.startTime;
    }

    public void startTime_$eq(Time x$1) {
        this.startTime = x$1;
    }

    public Duration batchDuration() {
        return this.batchDuration;
    }

    public void batchDuration_$eq(Duration x$1) {
        this.batchDuration = x$1;
    }

    private int numReceivers() {
        return this.numReceivers;
    }

    private void numReceivers_$eq(int x$1) {
        this.numReceivers = x$1;
    }

    public synchronized void start(Time time) {
        Predef$.MODULE$.require(this.zeroTime() == null, (Function0 & Serializable & scala.Serializable)() -> "DStream graph computation already started");
        this.zeroTime_$eq(time);
        this.startTime_$eq(time);
        this.outputStreams().foreach((Function1 & Serializable & scala.Serializable)x$1 -> {
            x$1.initialize(this.zeroTime());
            return BoxedUnit.UNIT;
        });
        this.outputStreams().foreach((Function1 & Serializable & scala.Serializable)x$2 -> {
            x$2.remember(this.rememberDuration());
            return BoxedUnit.UNIT;
        });
        this.outputStreams().foreach((Function1 & Serializable & scala.Serializable)x$3 -> {
            x$3.validateAtStart();
            return BoxedUnit.UNIT;
        });
        this.numReceivers_$eq(this.inputStreams().count((Function1 & Serializable & scala.Serializable)x$4 -> BoxesRunTime.boxToBoolean((boolean)DStreamGraph.$anonfun$start$5(x$4))));
        this.inputStreamNameAndID_$eq((Seq<Tuple2<String, Object>>)((SeqLike)this.inputStreams().map((Function1 & Serializable & scala.Serializable)is -> new Tuple2((Object)is.name(), (Object)BoxesRunTime.boxToInteger((int)is.id())), ArraySeq$.MODULE$.canBuildFrom())).toSeq());
        new ParVector(this.inputStreams().toVector()).foreach((Function1 & Serializable & scala.Serializable)x$5 -> {
            x$5.start();
            return BoxedUnit.UNIT;
        });
    }

    public synchronized void restart(Time time) {
        this.startTime_$eq(time);
    }

    public synchronized void stop() {
        new ParVector(this.inputStreams().toVector()).foreach((Function1 & Serializable & scala.Serializable)x$6 -> {
            x$6.stop();
            return BoxedUnit.UNIT;
        });
    }

    public synchronized void setContext(StreamingContext ssc) {
        this.outputStreams().foreach((Function1 & Serializable & scala.Serializable)x$7 -> {
            x$7.setContext(ssc);
            return BoxedUnit.UNIT;
        });
    }

    public synchronized void setBatchDuration(Duration duration) {
        Predef$.MODULE$.require(this.batchDuration() == null, (Function0 & Serializable & scala.Serializable)() -> new StringBuilder(52).append("Batch duration already set as ").append(this.batchDuration()).append(". Cannot set it again.").toString());
        this.batchDuration_$eq(duration);
    }

    public synchronized void remember(Duration duration) {
        Predef$.MODULE$.require(this.rememberDuration() == null, (Function0 & Serializable & scala.Serializable)() -> new StringBuilder(55).append("Remember duration already set as ").append(this.rememberDuration()).append(". Cannot set it again.").toString());
        this.rememberDuration_$eq(duration);
    }

    public synchronized void addInputStream(InputDStream<?> inputStream) {
        inputStream.setGraph(this);
        this.inputStreams_$eq((ArraySeq)this.inputStreams().$colon$plus(inputStream, ArraySeq$.MODULE$.canBuildFrom()));
    }

    public synchronized void addOutputStream(DStream<?> outputStream) {
        outputStream.setGraph(this);
        this.outputStreams_$eq((ArraySeq)this.outputStreams().$colon$plus(outputStream, ArraySeq$.MODULE$.canBuildFrom()));
    }

    public synchronized InputDStream<?>[] getInputStreams() {
        return (InputDStream[])this.inputStreams().toArray(ClassTag$.MODULE$.apply(InputDStream.class));
    }

    public synchronized DStream<?>[] getOutputStreams() {
        return (DStream[])this.outputStreams().toArray(ClassTag$.MODULE$.apply(DStream.class));
    }

    public synchronized ReceiverInputDStream<?>[] getReceiverInputStreams() {
        return (ReceiverInputDStream[])((TraversableOnce)((TraversableLike)this.inputStreams().filter((Function1 & Serializable & scala.Serializable)x$8 -> BoxesRunTime.boxToBoolean((boolean)DStreamGraph.$anonfun$getReceiverInputStreams$1(x$8)))).map((Function1 & Serializable & scala.Serializable)x$9 -> (ReceiverInputDStream)x$9, ArraySeq$.MODULE$.canBuildFrom())).toArray(ClassTag$.MODULE$.apply(ReceiverInputDStream.class));
    }

    public int getNumReceivers() {
        return this.numReceivers();
    }

    public Seq<Tuple2<String, Object>> getInputStreamNameAndID() {
        return this.inputStreamNameAndID();
    }

    /*
     * WARNING - void declaration
     */
    public Seq<Job> generateJobs(Time time) {
        void var2_4;
        Seq seq;
        this.logDebug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(25).append("Generating jobs for time ").append(time).toString());
        DStreamGraph dStreamGraph = this;
        synchronized (dStreamGraph) {
            seq = ((SeqLike)this.outputStreams().flatMap((Function1 & Serializable & scala.Serializable)outputStream -> {
                Option<Job> jobOption = outputStream.generateJob(time);
                jobOption.foreach((Function1 & Serializable & scala.Serializable)x$10 -> {
                    x$10.setCallSite(outputStream.creationSite());
                    return BoxedUnit.UNIT;
                });
                return Option$.MODULE$.option2Iterable(jobOption);
            }, ArraySeq$.MODULE$.canBuildFrom())).toSeq();
        }
        Seq jobs = seq;
        this.logDebug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(25).append("Generated ").append(jobs.length()).append(" jobs for time ").append(time).toString());
        return var2_4;
    }

    public void clearMetadata(Time time) {
        this.logDebug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(27).append("Clearing metadata for time ").append(time).toString());
        DStreamGraph dStreamGraph = this;
        synchronized (dStreamGraph) {
            this.outputStreams().foreach((Function1 & Serializable & scala.Serializable)x$11 -> {
                x$11.clearMetadata(time);
                return BoxedUnit.UNIT;
            });
        }
        this.logDebug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(30).append("Cleared old metadata for time ").append(time).toString());
    }

    public void updateCheckpointData(Time time) {
        this.logInfo((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(34).append("Updating checkpoint data for time ").append(time).toString());
        DStreamGraph dStreamGraph = this;
        synchronized (dStreamGraph) {
            this.outputStreams().foreach((Function1 & Serializable & scala.Serializable)x$12 -> {
                x$12.updateCheckpointData(time);
                return BoxedUnit.UNIT;
            });
        }
        this.logInfo((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(33).append("Updated checkpoint data for time ").append(time).toString());
    }

    public void clearCheckpointData(Time time) {
        this.logInfo((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(34).append("Clearing checkpoint data for time ").append(time).toString());
        DStreamGraph dStreamGraph = this;
        synchronized (dStreamGraph) {
            this.outputStreams().foreach((Function1 & Serializable & scala.Serializable)x$13 -> {
                x$13.clearCheckpointData(time);
                return BoxedUnit.UNIT;
            });
        }
        this.logInfo((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(33).append("Cleared checkpoint data for time ").append(time).toString());
    }

    public void restoreCheckpointData() {
        this.logInfo((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "Restoring checkpoint data");
        DStreamGraph dStreamGraph = this;
        synchronized (dStreamGraph) {
            this.outputStreams().foreach((Function1 & Serializable & scala.Serializable)x$14 -> {
                x$14.restoreCheckpointData();
                return BoxedUnit.UNIT;
            });
        }
        this.logInfo((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "Restored checkpoint data");
    }

    public synchronized void validate() {
        Predef$.MODULE$.require(this.batchDuration() != null, (Function0 & Serializable & scala.Serializable)() -> "Batch duration has not been set");
        Predef$.MODULE$.require(new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])this.getOutputStreams())).nonEmpty(), (Function0 & Serializable & scala.Serializable)() -> "No output operations registered, so nothing to execute");
    }

    public Duration getMaxInputStreamRememberDuration() {
        return (Duration)((TraversableOnce)((TraversableLike)this.inputStreams().map((Function1 & Serializable & scala.Serializable)x$15 -> x$15.rememberDuration(), ArraySeq$.MODULE$.canBuildFrom())).filter((Function1 & Serializable & scala.Serializable)x$16 -> BoxesRunTime.boxToBoolean((boolean)DStreamGraph.$anonfun$getMaxInputStreamRememberDuration$2(x$16)))).maxBy((Function1 & Serializable & scala.Serializable)x$17 -> BoxesRunTime.boxToLong((long)x$17.milliseconds()), (Ordering)Ordering.Long$.MODULE$);
    }

    private void writeObject(ObjectOutputStream oos) throws IOException {
        Utils$.MODULE$.tryOrIOException((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            this.logDebug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "DStreamGraph.writeObject used");
            DStreamGraph dStreamGraph = this;
            synchronized (dStreamGraph) {
                this.checkpointInProgress_$eq(true);
                this.logDebug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "Enabled checkpoint mode");
                oos.defaultWriteObject();
                this.checkpointInProgress_$eq(false);
                this.logDebug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "Disabled checkpoint mode");
            }
        });
    }

    private void readObject(ObjectInputStream ois) throws IOException {
        Utils$.MODULE$.tryOrIOException((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            this.logDebug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "DStreamGraph.readObject used");
            DStreamGraph dStreamGraph = this;
            synchronized (dStreamGraph) {
                this.checkpointInProgress_$eq(true);
                ois.defaultReadObject();
                this.checkpointInProgress_$eq(false);
            }
        });
    }

    public static final /* synthetic */ boolean $anonfun$start$5(InputDStream x$4) {
        return x$4 instanceof ReceiverInputDStream;
    }

    public static final /* synthetic */ boolean $anonfun$getReceiverInputStreams$1(InputDStream x$8) {
        return x$8 instanceof ReceiverInputDStream;
    }

    public static final /* synthetic */ boolean $anonfun$getMaxInputStreamRememberDuration$2(Duration x$16) {
        return x$16 != null;
    }

    public DStreamGraph() {
        Logging.$init$((Logging)this);
        this.inputStreams = (ArraySeq)ArraySeq$.MODULE$.empty();
        this.outputStreams = (ArraySeq)ArraySeq$.MODULE$.empty();
        this.inputStreamNameAndID = Nil$.MODULE$;
        this.rememberDuration = null;
        this.checkpointInProgress = false;
        this.zeroTime = null;
        this.startTime = null;
        this.batchDuration = null;
        this.numReceivers = 0;
    }
}

