/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.databases.sybase;

import org.apache.hop.core.Const;
import org.apache.hop.core.database.BaseDatabaseMeta;
import org.apache.hop.core.database.DatabaseMetaPlugin;
import org.apache.hop.core.database.IDatabase;
import org.apache.hop.core.gui.plugin.GuiPlugin;
import org.apache.hop.core.row.IValueMeta;

@DatabaseMetaPlugin(type="SYBASE", typeDescription="Sybase", documentationUrl="/database/databases/sybase.html")
@GuiPlugin(id="GUI-SybaseDatabaseMeta")
public class SybaseDatabaseMeta
extends BaseDatabaseMeta
implements IDatabase {
    public int[] getAccessTypeList() {
        return new int[]{0};
    }

    public int getDefaultDatabasePort() {
        if (this.getAccessType() == 0) {
            return 5001;
        }
        return -1;
    }

    public int getNotFoundTK(boolean useAutoinc) {
        if (this.isSupportsAutoInc() && useAutoinc) {
            return 1;
        }
        return super.getNotFoundTK(useAutoinc);
    }

    public String getDriverClass() {
        return "net.sourceforge.jtds.jdbc.Driver";
    }

    public String getURL(String hostname, String port, String databaseName) {
        return "jdbc:jtds:sybase://" + hostname + ":" + port + "/" + databaseName;
    }

    public String getSchemaTableCombination(String schemaName, String tablePart) {
        return tablePart;
    }

    public boolean isRequiringTransactionsOnQueries() {
        return false;
    }

    public String getAddColumnStatement(String tableName, IValueMeta v, String tk, boolean useAutoinc, String pk, boolean semicolon) {
        return "ALTER TABLE " + tableName + " ADD " + this.getFieldDefinition(v, tk, pk, useAutoinc, true, false);
    }

    public String getModifyColumnStatement(String tableName, IValueMeta v, String tk, boolean useAutoinc, String pk, boolean semicolon) {
        return "ALTER TABLE " + tableName + " MODIFY " + this.getFieldDefinition(v, tk, pk, useAutoinc, true, false);
    }

    public String getFieldDefinition(IValueMeta v, String tk, String pk, boolean useAutoinc, boolean addFieldName, boolean addCr) {
        Object retval = "";
        String fieldname = v.getName();
        int length = v.getLength();
        int precision = v.getPrecision();
        if (addFieldName) {
            retval = (String)retval + fieldname + " ";
        }
        int type = v.getType();
        switch (type) {
            case 3: 
            case 9: {
                retval = (String)retval + "DATETIME NULL";
                break;
            }
            case 4: {
                if (this.isSupportsBooleanDataType()) {
                    retval = (String)retval + "BOOLEAN";
                    break;
                }
                retval = (String)retval + "CHAR(1)";
                break;
            }
            case 1: 
            case 5: 
            case 6: {
                if (fieldname.equalsIgnoreCase(tk) || fieldname.equalsIgnoreCase(pk)) {
                    if (useAutoinc) {
                        retval = (String)retval + "INTEGER IDENTITY NOT NULL";
                        break;
                    }
                    retval = (String)retval + "INTEGER NOT NULL PRIMARY KEY";
                    break;
                }
                if (precision != 0 || precision == 0 && length > 9) {
                    if (precision > 0 && length > 0) {
                        retval = (String)retval + "DECIMAL(" + length + ", " + precision + ") NULL";
                        break;
                    }
                    retval = (String)retval + "DOUBLE PRECISION NULL";
                    break;
                }
                if (length < 3) {
                    retval = (String)retval + "TINYINT NULL";
                    break;
                }
                if (length < 5) {
                    retval = (String)retval + "SMALLINT NULL";
                    break;
                }
                retval = (String)retval + "INTEGER NULL";
                break;
            }
            case 2: {
                if (length >= 2048) {
                    retval = (String)retval + "TEXT NULL";
                    break;
                }
                retval = (String)retval + "VARCHAR";
                if (length > 0) {
                    retval = (String)retval + "(" + length + ")";
                }
                retval = (String)retval + " NULL";
                break;
            }
            default: {
                retval = (String)retval + " UNKNOWN";
            }
        }
        if (addCr) {
            retval = (String)retval + Const.CR;
        }
        return retval;
    }

    public String getExtraOptionsHelpText() {
        return "http://jtds.sourceforge.net/faq.html#urlFormat";
    }

    public String getSqlInsertAutoIncUnknownDimensionRow(String schemaTable, String keyField, String versionField) {
        return "insert into " + schemaTable + "(" + versionField + ") values (1)";
    }

    public String quoteSqlString(String string) {
        string = string.replace("'", "''");
        string = string.replace("\\n", "\\0xd");
        string = string.replace("\\r", "\\0xa");
        return "'" + string + "'";
    }

    public boolean isSybaseVariant() {
        return true;
    }
}

