/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.runners.core.serialization;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.Base64;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;

public class Base64Serializer {
    private Base64Serializer() {
    }

    public static @UnknownKeyFor @NonNull @Initialized String serializeUnchecked(@UnknownKeyFor @NonNull @Initialized Serializable serializable) {
        try {
            return Base64Serializer.serialize(serializable);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public static <T> T deserializeUnchecked(@UnknownKeyFor @NonNull @Initialized String serialized, @UnknownKeyFor @NonNull @Initialized Class<T> klass) {
        try {
            return Base64Serializer.deserialize(serialized, klass);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private static <T> T deserialize(@UnknownKeyFor @NonNull @Initialized String serialized, @UnknownKeyFor @NonNull @Initialized Class<T> klass) throws @UnknownKeyFor @NonNull @Initialized IOException, @UnknownKeyFor @NonNull @Initialized ClassNotFoundException {
        byte[] bytes = Base64.getDecoder().decode(serialized);
        ObjectInputStream ois = new ObjectInputStream(new ByteArrayInputStream(bytes));
        Object object = ois.readObject();
        ois.close();
        return (T)object;
    }

    private static @UnknownKeyFor @NonNull @Initialized String serialize(@UnknownKeyFor @NonNull @Initialized Serializable serializable) throws @UnknownKeyFor @NonNull @Initialized IOException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        ObjectOutputStream oos = new ObjectOutputStream(baos);
        oos.writeObject(serializable);
        oos.close();
        return Base64.getEncoder().encodeToString(baos.toByteArray());
    }
}

