/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.runners.core.triggers;

import java.util.Arrays;
import org.apache.beam.runners.core.triggers.ExecutableTriggerStateMachine;
import org.apache.beam.runners.core.triggers.TriggerStateMachine;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.annotations.VisibleForTesting;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;
import org.checkerframework.dataflow.qual.SideEffectFree;

class OrFinallyStateMachine
extends TriggerStateMachine {
    private static final @UnknownKeyFor @NonNull @Initialized int ACTUAL = 0;
    private static final @UnknownKeyFor @NonNull @Initialized int UNTIL = 1;

    @VisibleForTesting
    OrFinallyStateMachine(@UnknownKeyFor @NonNull @Initialized TriggerStateMachine actual, @UnknownKeyFor @NonNull @Initialized TriggerStateMachine until) {
        super(Arrays.asList(actual, until));
    }

    @Override
    public void prefetchOnElement(@UnknownKeyFor @NonNull @Initialized TriggerStateMachine.PrefetchContext c) {
        for (ExecutableTriggerStateMachine subTrigger : c.trigger().subTriggers()) {
            subTrigger.invokePrefetchOnElement(c.forTrigger(subTrigger));
        }
    }

    @Override
    public void onElement(@UnknownKeyFor @NonNull @Initialized TriggerStateMachine.OnElementContext c) throws @UnknownKeyFor @NonNull @Initialized Exception {
        c.trigger().subTrigger(0).invokeOnElement(c);
        c.trigger().subTrigger(1).invokeOnElement(c);
    }

    @Override
    public void prefetchOnMerge(@UnknownKeyFor @NonNull @Initialized TriggerStateMachine.MergingPrefetchContext c) {
        for (ExecutableTriggerStateMachine subTrigger : c.trigger().subTriggers()) {
            subTrigger.invokePrefetchOnMerge(c.forTrigger(subTrigger));
        }
    }

    @Override
    public void onMerge(@UnknownKeyFor @NonNull @Initialized TriggerStateMachine.OnMergeContext c) throws @UnknownKeyFor @NonNull @Initialized Exception {
        for (ExecutableTriggerStateMachine subTrigger : c.trigger().subTriggers()) {
            subTrigger.invokeOnMerge(c);
        }
        this.updateFinishedState(c);
    }

    @Override
    public void prefetchShouldFire(@UnknownKeyFor @NonNull @Initialized TriggerStateMachine.PrefetchContext c) {
        for (ExecutableTriggerStateMachine subTrigger : c.trigger().subTriggers()) {
            subTrigger.invokePrefetchShouldFire(c.forTrigger(subTrigger));
        }
    }

    @Override
    public @UnknownKeyFor @NonNull @Initialized boolean shouldFire(@UnknownKeyFor @NonNull @Initialized TriggerStateMachine.TriggerContext context) throws @UnknownKeyFor @NonNull @Initialized Exception {
        return context.trigger().subTrigger(0).invokeShouldFire(context) || context.trigger().subTrigger(1).invokeShouldFire(context);
    }

    @Override
    public void onFire(@UnknownKeyFor @NonNull @Initialized TriggerStateMachine.TriggerContext context) throws @UnknownKeyFor @NonNull @Initialized Exception {
        ExecutableTriggerStateMachine actualSubtrigger = context.trigger().subTrigger(0);
        ExecutableTriggerStateMachine untilSubtrigger = context.trigger().subTrigger(1);
        if (untilSubtrigger.invokeShouldFire(context)) {
            untilSubtrigger.invokeOnFire(context);
            actualSubtrigger.invokeClear(context);
        } else {
            actualSubtrigger.invokeOnFire(context);
        }
        this.updateFinishedState(context);
    }

    @Override
    @SideEffectFree
    public @UnknownKeyFor @NonNull @Initialized String toString() {
        return String.format("%s.orFinally(%s)", this.subTriggers.get(0), this.subTriggers.get(1));
    }

    private void updateFinishedState(@UnknownKeyFor @NonNull @Initialized TriggerStateMachine.TriggerContext c) throws @UnknownKeyFor @NonNull @Initialized Exception {
        boolean anyStillFinished = false;
        for (ExecutableTriggerStateMachine subTrigger : c.trigger().subTriggers()) {
            anyStillFinished |= c.forTrigger(subTrigger).trigger().isFinished();
        }
        c.trigger().setFinished(anyStillFinished);
    }
}

