/*
 * Decompiled with CFR 0.152.
 */
package com.dropbox.core.v2.team;

import com.dropbox.core.stone.UnionSerializer;
import com.dropbox.core.v2.account.SetProfilePhotoError;
import com.fasterxml.jackson.core.JsonGenerationException;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonToken;
import java.io.IOException;
import java.util.Arrays;

public final class MembersSetProfilePhotoError {
    public static final MembersSetProfilePhotoError USER_NOT_FOUND = new MembersSetProfilePhotoError().withTag(Tag.USER_NOT_FOUND);
    public static final MembersSetProfilePhotoError USER_NOT_IN_TEAM = new MembersSetProfilePhotoError().withTag(Tag.USER_NOT_IN_TEAM);
    public static final MembersSetProfilePhotoError SET_PROFILE_DISALLOWED = new MembersSetProfilePhotoError().withTag(Tag.SET_PROFILE_DISALLOWED);
    public static final MembersSetProfilePhotoError OTHER = new MembersSetProfilePhotoError().withTag(Tag.OTHER);
    private Tag _tag;
    private SetProfilePhotoError photoErrorValue;

    private MembersSetProfilePhotoError() {
    }

    private MembersSetProfilePhotoError withTag(Tag _tag) {
        MembersSetProfilePhotoError result = new MembersSetProfilePhotoError();
        result._tag = _tag;
        return result;
    }

    private MembersSetProfilePhotoError withTagAndPhotoError(Tag _tag, SetProfilePhotoError photoErrorValue) {
        MembersSetProfilePhotoError result = new MembersSetProfilePhotoError();
        result._tag = _tag;
        result.photoErrorValue = photoErrorValue;
        return result;
    }

    public Tag tag() {
        return this._tag;
    }

    public boolean isUserNotFound() {
        return this._tag == Tag.USER_NOT_FOUND;
    }

    public boolean isUserNotInTeam() {
        return this._tag == Tag.USER_NOT_IN_TEAM;
    }

    public boolean isSetProfileDisallowed() {
        return this._tag == Tag.SET_PROFILE_DISALLOWED;
    }

    public boolean isPhotoError() {
        return this._tag == Tag.PHOTO_ERROR;
    }

    public static MembersSetProfilePhotoError photoError(SetProfilePhotoError value) {
        if (value == null) {
            throw new IllegalArgumentException("Value is null");
        }
        return new MembersSetProfilePhotoError().withTagAndPhotoError(Tag.PHOTO_ERROR, value);
    }

    public SetProfilePhotoError getPhotoErrorValue() {
        if (this._tag != Tag.PHOTO_ERROR) {
            throw new IllegalStateException("Invalid tag: required Tag.PHOTO_ERROR, but was Tag." + this._tag.name());
        }
        return this.photoErrorValue;
    }

    public boolean isOther() {
        return this._tag == Tag.OTHER;
    }

    public int hashCode() {
        int hash = Arrays.hashCode(new Object[]{this._tag, this.photoErrorValue});
        hash = 31 * super.hashCode() + hash;
        return hash;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (obj instanceof MembersSetProfilePhotoError) {
            MembersSetProfilePhotoError other = (MembersSetProfilePhotoError)obj;
            if (this._tag != other._tag) {
                return false;
            }
            switch (this._tag) {
                case USER_NOT_FOUND: {
                    return true;
                }
                case USER_NOT_IN_TEAM: {
                    return true;
                }
                case SET_PROFILE_DISALLOWED: {
                    return true;
                }
                case PHOTO_ERROR: {
                    return this.photoErrorValue == other.photoErrorValue || this.photoErrorValue.equals((Object)other.photoErrorValue);
                }
                case OTHER: {
                    return true;
                }
            }
            return false;
        }
        return false;
    }

    public String toString() {
        return Serializer.INSTANCE.serialize(this, false);
    }

    public String toStringMultiline() {
        return Serializer.INSTANCE.serialize(this, true);
    }

    static class Serializer
    extends UnionSerializer<MembersSetProfilePhotoError> {
        public static final Serializer INSTANCE = new Serializer();

        Serializer() {
        }

        @Override
        public void serialize(MembersSetProfilePhotoError value, JsonGenerator g) throws IOException, JsonGenerationException {
            switch (value.tag()) {
                case USER_NOT_FOUND: {
                    g.writeString("user_not_found");
                    break;
                }
                case USER_NOT_IN_TEAM: {
                    g.writeString("user_not_in_team");
                    break;
                }
                case SET_PROFILE_DISALLOWED: {
                    g.writeString("set_profile_disallowed");
                    break;
                }
                case PHOTO_ERROR: {
                    g.writeStartObject();
                    this.writeTag("photo_error", g);
                    g.writeFieldName("photo_error");
                    SetProfilePhotoError.Serializer.INSTANCE.serialize(value.photoErrorValue, g);
                    g.writeEndObject();
                    break;
                }
                default: {
                    g.writeString("other");
                }
            }
        }

        @Override
        public MembersSetProfilePhotoError deserialize(JsonParser p) throws IOException, JsonParseException {
            MembersSetProfilePhotoError value;
            String tag;
            boolean collapsed;
            if (p.getCurrentToken() == JsonToken.VALUE_STRING) {
                collapsed = true;
                tag = Serializer.getStringValue(p);
                p.nextToken();
            } else {
                collapsed = false;
                Serializer.expectStartObject(p);
                tag = Serializer.readTag(p);
            }
            if (tag == null) {
                throw new JsonParseException(p, "Required field missing: .tag");
            }
            if ("user_not_found".equals(tag)) {
                value = USER_NOT_FOUND;
            } else if ("user_not_in_team".equals(tag)) {
                value = USER_NOT_IN_TEAM;
            } else if ("set_profile_disallowed".equals(tag)) {
                value = SET_PROFILE_DISALLOWED;
            } else if ("photo_error".equals(tag)) {
                SetProfilePhotoError fieldValue = null;
                Serializer.expectField("photo_error", p);
                fieldValue = SetProfilePhotoError.Serializer.INSTANCE.deserialize(p);
                value = MembersSetProfilePhotoError.photoError(fieldValue);
            } else {
                value = OTHER;
            }
            if (!collapsed) {
                Serializer.skipFields(p);
                Serializer.expectEndObject(p);
            }
            return value;
        }
    }

    public static enum Tag {
        USER_NOT_FOUND,
        USER_NOT_IN_TEAM,
        SET_PROFILE_DISALLOWED,
        PHOTO_ERROR,
        OTHER;

    }
}

