/*
 * Decompiled with CFR 0.152.
 */
package com.dropbox.core.v2.users;

import com.dropbox.core.stone.StoneSerializers;
import com.dropbox.core.stone.UnionSerializer;
import com.fasterxml.jackson.core.JsonGenerationException;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonToken;
import java.io.IOException;
import java.util.Arrays;

public final class PaperAsFilesValue {
    public static final PaperAsFilesValue OTHER = new PaperAsFilesValue().withTag(Tag.OTHER);
    private Tag _tag;
    private Boolean enabledValue;

    private PaperAsFilesValue() {
    }

    private PaperAsFilesValue withTag(Tag _tag) {
        PaperAsFilesValue result = new PaperAsFilesValue();
        result._tag = _tag;
        return result;
    }

    private PaperAsFilesValue withTagAndEnabled(Tag _tag, Boolean enabledValue) {
        PaperAsFilesValue result = new PaperAsFilesValue();
        result._tag = _tag;
        result.enabledValue = enabledValue;
        return result;
    }

    public Tag tag() {
        return this._tag;
    }

    public boolean isEnabled() {
        return this._tag == Tag.ENABLED;
    }

    public static PaperAsFilesValue enabled(boolean value) {
        return new PaperAsFilesValue().withTagAndEnabled(Tag.ENABLED, value);
    }

    public boolean getEnabledValue() {
        if (this._tag != Tag.ENABLED) {
            throw new IllegalStateException("Invalid tag: required Tag.ENABLED, but was Tag." + this._tag.name());
        }
        return this.enabledValue;
    }

    public boolean isOther() {
        return this._tag == Tag.OTHER;
    }

    public int hashCode() {
        int hash = Arrays.hashCode(new Object[]{this._tag, this.enabledValue});
        return hash;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (obj instanceof PaperAsFilesValue) {
            PaperAsFilesValue other = (PaperAsFilesValue)obj;
            if (this._tag != other._tag) {
                return false;
            }
            switch (this._tag) {
                case ENABLED: {
                    return this.enabledValue == other.enabledValue;
                }
                case OTHER: {
                    return true;
                }
            }
            return false;
        }
        return false;
    }

    public String toString() {
        return Serializer.INSTANCE.serialize(this, false);
    }

    public String toStringMultiline() {
        return Serializer.INSTANCE.serialize(this, true);
    }

    static class Serializer
    extends UnionSerializer<PaperAsFilesValue> {
        public static final Serializer INSTANCE = new Serializer();

        Serializer() {
        }

        @Override
        public void serialize(PaperAsFilesValue value, JsonGenerator g) throws IOException, JsonGenerationException {
            switch (value.tag()) {
                case ENABLED: {
                    g.writeStartObject();
                    this.writeTag("enabled", g);
                    g.writeFieldName("enabled");
                    StoneSerializers.boolean_().serialize(value.enabledValue, g);
                    g.writeEndObject();
                    break;
                }
                default: {
                    g.writeString("other");
                }
            }
        }

        @Override
        public PaperAsFilesValue deserialize(JsonParser p) throws IOException, JsonParseException {
            PaperAsFilesValue value;
            String tag;
            boolean collapsed;
            if (p.getCurrentToken() == JsonToken.VALUE_STRING) {
                collapsed = true;
                tag = Serializer.getStringValue(p);
                p.nextToken();
            } else {
                collapsed = false;
                Serializer.expectStartObject(p);
                tag = Serializer.readTag(p);
            }
            if (tag == null) {
                throw new JsonParseException(p, "Required field missing: .tag");
            }
            if ("enabled".equals(tag)) {
                Boolean fieldValue = null;
                Serializer.expectField("enabled", p);
                fieldValue = StoneSerializers.boolean_().deserialize(p);
                value = PaperAsFilesValue.enabled(fieldValue);
            } else {
                value = OTHER;
            }
            if (!collapsed) {
                Serializer.skipFields(p);
                Serializer.expectEndObject(p);
            }
            return value;
        }
    }

    public static enum Tag {
        ENABLED,
        OTHER;

    }
}

