/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.oss.protocol.internal.response.event;

import com.datastax.oss.protocol.internal.Message;
import com.datastax.oss.protocol.internal.PrimitiveCodec;
import com.datastax.oss.protocol.internal.PrimitiveSizes;
import com.datastax.oss.protocol.internal.ProtocolErrors;
import com.datastax.oss.protocol.internal.response.Event;
import java.util.List;

public class SchemaChangeEvent
extends Event {
    public final String changeType;
    public final String target;
    public final String keyspace;
    public final String object;
    public final List<String> arguments;

    public SchemaChangeEvent(String changeType, String target, String keyspace, String object, List<String> arguments) {
        super("SCHEMA_CHANGE");
        this.changeType = changeType;
        this.target = target;
        this.keyspace = keyspace;
        this.object = object;
        this.arguments = arguments;
    }

    public String toString() {
        return String.format("EVENT SCHEMA_CHANGE(%s %s %s%s%s)", this.changeType, this.target, this.keyspace, this.object == null ? "" : "." + this.object, this.arguments == null ? "" : this.arguments);
    }

    public static class SubCodec
    extends Event.SubCodec {
        public SubCodec(int protocolVersion) {
            super("SCHEMA_CHANGE", protocolVersion);
        }

        @Override
        public <B> void encode(B dest, Message message, PrimitiveCodec<B> encoder) {
            SchemaChangeEvent event = (SchemaChangeEvent)message;
            encoder.writeString(event.changeType, dest);
            encoder.writeString(event.target, dest);
            encoder.writeString(event.keyspace, dest);
            switch (event.target) {
                case "KEYSPACE": {
                    break;
                }
                case "TABLE": 
                case "TYPE": {
                    encoder.writeString(event.object, dest);
                    break;
                }
                case "AGGREGATE": 
                case "FUNCTION": {
                    encoder.writeString(event.object, dest);
                    encoder.writeStringList(event.arguments, dest);
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Unknown schema change target: " + event.target);
                }
            }
        }

        @Override
        public int encodedSize(Message message) {
            SchemaChangeEvent event = (SchemaChangeEvent)message;
            ProtocolErrors.check(this.protocolVersion >= 4 || !"AGGREGATE".equals(event.target) && !"FUNCTION".equals(event.target), "%s schema change events are not supported in protocol version %d", event.target, this.protocolVersion);
            int size = PrimitiveSizes.sizeOfString(event.changeType);
            size += PrimitiveSizes.sizeOfString(event.target);
            size += PrimitiveSizes.sizeOfString(event.keyspace);
            switch (event.target) {
                case "KEYSPACE": {
                    break;
                }
                case "TABLE": 
                case "TYPE": {
                    size += PrimitiveSizes.sizeOfString(event.object);
                    break;
                }
                case "AGGREGATE": 
                case "FUNCTION": {
                    size += PrimitiveSizes.sizeOfString(event.object);
                    size += PrimitiveSizes.sizeOfStringList(event.arguments);
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Unknown schema change target: " + event.target);
                }
            }
            return size;
        }

        @Override
        public <B> Message decode(B source, PrimitiveCodec<B> decoder) {
            List<String> arguments;
            String object;
            String changeType = decoder.readString(source);
            String target = decoder.readString(source);
            ProtocolErrors.check(this.protocolVersion >= 4 || !"AGGREGATE".equals(target) && !"FUNCTION".equals(target), "%s schema change events are not supported in protocol version %d", target, this.protocolVersion);
            String keyspace = decoder.readString(source);
            switch (target) {
                case "KEYSPACE": {
                    object = null;
                    arguments = null;
                    break;
                }
                case "TABLE": 
                case "TYPE": {
                    object = decoder.readString(source);
                    arguments = null;
                    break;
                }
                case "AGGREGATE": 
                case "FUNCTION": {
                    object = decoder.readString(source);
                    arguments = decoder.readStringList(source);
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Unknown schema change target: " + target);
                }
            }
            return new SchemaChangeEvent(changeType, target, keyspace, object, arguments);
        }
    }
}

