/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.dom;

import javax.xml.parsers.DocumentBuilder;
import javax.xml.transform.Source;
import javax.xml.transform.sax.SAXSource;
import net.sf.saxon.Configuration;
import net.sf.saxon.dom.DocumentOverNodeInfo;
import net.sf.saxon.event.PipelineConfiguration;
import net.sf.saxon.event.Receiver;
import net.sf.saxon.event.Sender;
import net.sf.saxon.om.NodeInfo;
import net.sf.saxon.tinytree.TinyBuilder;
import net.sf.saxon.tinytree.TinyDocumentImpl;
import net.sf.saxon.trans.XPathException;
import org.w3c.dom.DOMImplementation;
import org.w3c.dom.Document;
import org.xml.sax.EntityResolver;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class DocumentBuilderImpl
extends DocumentBuilder {
    private EntityResolver entityResolver;
    private ErrorHandler errorHandler;

    public boolean isNamespaceAware() {
        return true;
    }

    public boolean isValidating() {
        return false;
    }

    public Document newDocument() {
        return new DocumentOverNodeInfo();
    }

    public Document parse(InputSource inputSource) throws SAXException {
        try {
            TinyBuilder tinyBuilder = new TinyBuilder();
            Configuration configuration = new Configuration();
            PipelineConfiguration pipelineConfiguration = configuration.makePipelineConfiguration();
            tinyBuilder.setPipelineConfiguration(pipelineConfiguration);
            SAXSource sAXSource = new SAXSource(inputSource);
            if (this.entityResolver != null) {
                sAXSource.getXMLReader().setEntityResolver(this.entityResolver);
            }
            if (this.errorHandler != null) {
                sAXSource.getXMLReader().setErrorHandler(this.errorHandler);
            }
            sAXSource.setSystemId(inputSource.getSystemId());
            new Sender(pipelineConfiguration).send((Source)sAXSource, (Receiver)tinyBuilder);
            TinyDocumentImpl tinyDocumentImpl = (TinyDocumentImpl)tinyBuilder.getCurrentRoot();
            return (Document)((Object)DocumentOverNodeInfo.wrap((NodeInfo)tinyDocumentImpl));
        }
        catch (XPathException xPathException) {
            throw new SAXException((Exception)((Object)xPathException));
        }
    }

    public void setEntityResolver(EntityResolver entityResolver) {
        this.entityResolver = entityResolver;
    }

    public void setErrorHandler(ErrorHandler errorHandler) {
        this.errorHandler = errorHandler;
    }

    public DOMImplementation getDOMImplementation() {
        return this.newDocument().getImplementation();
    }
}

